/*
 * Decompiled with CFR 0.152.
 */
package jfr.pagesucker;

import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import jfr.awt.MessageDialog;
import jfr.html.Parser;
import jfr.html.parser.AuthorizationErr;
import jfr.html.parser.PageNotFoundException;
import jfr.html.parser.Problem;
import jfr.list.GenericList;
import jfr.macos.AboutHandler;
import jfr.pagesucker.AuthenticationSettings;
import jfr.pagesucker.Constants;
import jfr.pagesucker.ControlFrame;
import jfr.pagesucker.DataFilesSettings;
import jfr.pagesucker.ExpertSettings;
import jfr.pagesucker.HTMLFilesSettings;
import jfr.pagesucker.M3UFilesSettings;
import jfr.pagesucker.OptionsSettings;
import jfr.pagesucker.ParseThread;
import jfr.pagesucker.Preferences;
import jfr.pagesucker.ProxySettings;
import jfr.pagesucker.RAMFilesSettings;
import jfr.pagesucker.Registration;
import jfr.pagesucker.ScriptSettings;
import jfr.pagesucker.Settings;
import jfr.pagesucker.SuckerParser;
import jfr.util.Aborter;
import jfr.util.FileSet;
import jfr.util.ModifiableInteger;
import jfr.util.StringUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PageSucker {
    public static Date beta_expiration_date = null;
    public static int os_type = 0;
    public static int registration_checksum1 = 0;
    public static int registration_checksum2 = 0;
    public static String registration_name = null;
    public static String registration_number = null;
    public static String version_string;
    public static int java_version;
    public static int java_sub_version;
    public static int java_sub_sub_version;
    public ControlFrame frame_control = null;
    public HTMLFilesSettings settings_html = new HTMLFilesSettings();
    public DataFilesSettings settings_data = new DataFilesSettings();
    public RAMFilesSettings settings_ram_files = new RAMFilesSettings();
    public M3UFilesSettings settings_m3u_files = new M3UFilesSettings();
    public ScriptSettings settings_script = new ScriptSettings();
    public OptionsSettings settings_options = new OptionsSettings();
    public ExpertSettings settings_expert = new ExpertSettings();
    public ProxySettings settings_proxy = new ProxySettings();
    public AuthenticationSettings settings_authentication = new AuthenticationSettings();
    private FileDialog filedialog_save_page = null;
    private DataOutputStream out_stream_logfile = null;
    public Perl5Compiler compiler_regexp_filter = new Perl5Compiler();
    private Perl5Matcher matcher_regexp_filter = new Perl5Matcher();
    public static BASE64Encoder base64_encoder;
    public static BASE64Decoder base64_decoder;
    public String base_url_path_string;
    public String base_url_host;
    public int base_url_port;
    FileSet set_files_in_use;
    Hashtable hashtable_authentications;
    private Hashtable table_saved_files;
    private GenericList list_unparsed_pages;
    private int active_threads;
    private int active_parsing_threads;
    private int total_saved_files;
    private int total_errors;
    private String page_save_dir;
    Aborter aborter = new Aborter();
    private byte application_status = 1;
    Settings editing_settings = null;
    public Settings working_settings = null;
    private static AboutHandler about_handler;

    public PageSucker() {
        URLConnection.setDefaultAllowUserInteraction(true);
    }

    public void initialize() {
        boolean registered = false;
        if (beta_expiration_date == null) {
            registered = Registration.loadRegistrationFile();
        } else {
            registration_checksum1 = 982731;
            registration_checksum2 = 983216;
            registration_name = "Beta Tester";
        }
        this.editing_settings = new Settings();
        this.working_settings = this.editing_settings.makeClone();
        this.editing_settings.loadFromFile(true);
        Preferences prefs = Preferences.getInstance();
        prefs.loadFromDisk();
        if (this.frame_control == null) {
            this.frame_control = this.settings_options.isRememberWindowPositions() ? new ControlFrame(prefs.control_frame_location, prefs.control_frame_size) : new ControlFrame(null, null);
            this.filedialog_save_page = new FileDialog((Frame)this.frame_control, "Choose a page save dir:", 1);
        }
        if (this.settings_options.isRememberWindowPositions()) {
            if (prefs.html_files_frame_open) {
                this.settings_html.showFrame();
            }
            if (prefs.data_files_frame_open) {
                this.settings_data.showFrame();
            }
            if (prefs.ram_files_frame_open) {
                this.settings_ram_files.showFrame();
            }
            if (prefs.m3u_files_frame_open) {
                this.settings_m3u_files.showFrame();
            }
            if (prefs.script_frame_open) {
                this.settings_script.showFrame();
            }
            if (prefs.options_frame_open) {
                this.settings_options.showFrame();
            }
            if (prefs.expert_frame_open) {
                this.settings_expert.showFrame();
            }
            if (prefs.proxy_frame_open) {
                this.settings_proxy.showFrame();
            }
            if (prefs.authentication_frame_open) {
                this.settings_authentication.showFrame();
            }
            ((Component)this.frame_control).setVisible(true);
        }
        this.checkForValidJavaEngine();
        if (beta_expiration_date == null) {
            if (!registered) {
                Registration.showRegistrationDialog();
            }
        } else {
            Date now = new Date();
            DateFormat df = DateFormat.getDateInstance(0);
            df.setTimeZone(TimeZone.getDefault());
            if (now.after(beta_expiration_date)) {
                new MessageDialog((Frame)this.frame_control, "Sorry, but this beta version has expired.\nIt was only valid until " + df.format(beta_expiration_date), 3).handle();
                System.exit(0);
            } else {
                new MessageDialog((Frame)this.frame_control, "This is a time limited beta version that expires on\n" + df.format(beta_expiration_date), 2).handle();
            }
        }
        this.frame_control.button_start_download.setEnabled(true);
    }

    private void checkForValidJavaEngine() {
        boolean newer_java_needed;
        String needed_engine_description;
        int needed_java_sub_sub_version;
        int needed_java_sub_version;
        int needed_java_version;
        switch (os_type) {
            case 1: {
                needed_java_version = 1;
                needed_java_sub_version = 1;
                needed_java_sub_sub_version = 7;
                needed_engine_description = "MRJ 2.1.1";
                break;
            }
            case 2: {
                needed_java_version = 1;
                needed_java_sub_version = 1;
                needed_java_sub_sub_version = 7;
                needed_engine_description = "JRE 1.1.7";
                break;
            }
            default: {
                return;
            }
        }
        boolean bl = newer_java_needed = needed_java_version > java_version || needed_java_version == java_version && needed_java_sub_version > java_sub_version || needed_java_version == java_version && needed_java_sub_version == java_sub_version && needed_java_sub_sub_version > java_sub_sub_version;
        if (newer_java_needed) {
            String[] buttons = new String[]{"Proceed At My Own Risk", "Quit"};
            String button_pressed = new MessageDialog((Frame)this.frame_control, "WARNING: This release of PageSucker requires a newer Java engine than the one currently installed. The recommended engine is " + needed_engine_description + ". You can get it directly from the engine vendor; see the Read Me file for details.\n\nYou may try to run PageSucker with your current engine, but if you do experience problems, try upgrading your Java engine.", 3, buttons).handle();
            if (button_pressed == null || button_pressed.equals("Quit")) {
                System.exit(0);
            }
        }
    }

    public void quitApplication() {
        String button_pressed;
        if (this.getStatus() == 2 && !(button_pressed = new MessageDialog((Frame)Main.sucker.frame_control, "A download is in progress! Are you sure that you want to quit?", 2, MessageDialog.array_ok_cancel_buttons).handle()).equals("OK")) {
            return;
        }
        Preferences.getInstance().saveToDisk();
        System.exit(0);
    }

    public boolean gatherEditingSettings() {
        return this.frame_control.saveContentsValues() && this.settings_html.saveContentsValues() && this.settings_data.saveContentsValues() && this.settings_ram_files.saveContentsValues() && this.settings_m3u_files.saveContentsValues() && this.settings_script.saveContentsValues() && this.settings_options.saveContentsValues() && this.settings_expert.saveContentsValues() && this.settings_proxy.saveContentsValues() && this.settings_authentication.saveContentsValues();
    }

    public void updateFramesFromEditingSettings() {
        this.frame_control.updateFromEditingSettings();
        this.settings_html.updateFromEditingSettings();
        this.settings_data.updateFromEditingSettings();
        this.settings_ram_files.updateFromEditingSettings();
        this.settings_m3u_files.updateFromEditingSettings();
        this.settings_script.updateFromEditingSettings();
        this.settings_options.updateFromEditingSettings();
        this.settings_expert.updateFromEditingSettings();
        this.settings_proxy.updateFromEditingSettings();
        this.settings_authentication.updateFromEditingSettings();
    }

    public boolean gatherWorkingSettings() {
        if (!this.gatherEditingSettings()) {
            return false;
        }
        this.working_settings = this.editing_settings.makeClone();
        Properties props = System.getProperties();
        ((Hashtable)props).put("proxyHost", Main.sucker.working_settings.http_proxy_host);
        ((Hashtable)props).put("http.proxyHost", Main.sucker.working_settings.http_proxy_host);
        ((Hashtable)props).put("proxyPort", String.valueOf(Main.sucker.working_settings.http_proxy_port));
        ((Hashtable)props).put("http.proxyPort", String.valueOf(Main.sucker.working_settings.http_proxy_port));
        ((Hashtable)props).put("proxySet", this.working_settings.http_proxy_host.length() != 0 ? "true" : "false");
        ((Hashtable)props).put("http.proxySet", this.working_settings.http_proxy_host.length() != 0 ? "true" : "false");
        ((Hashtable)props).put("ftpProxyHost", Main.sucker.working_settings.ftp_proxy_host);
        ((Hashtable)props).put("ftp.proxyHost", Main.sucker.working_settings.ftp_proxy_host);
        ((Hashtable)props).put("ftpProxyPort", String.valueOf(Main.sucker.working_settings.ftp_proxy_port));
        ((Hashtable)props).put("ftp.proxyPort", String.valueOf(Main.sucker.working_settings.ftp_proxy_port));
        ((Hashtable)props).put("ftpProxySet", this.working_settings.ftp_proxy_host.length() != 0 ? "true" : "false");
        ((Hashtable)props).put("ftp.proxySet", this.working_settings.ftp_proxy_host.length() != 0 ? "true" : "false");
        System.setProperties(props);
        if (this.working_settings.authentications != null && this.working_settings.authentications.length > 0) {
            this.hashtable_authentications = new Hashtable(this.working_settings.authentications.length);
            int i = 0;
            while (i < this.working_settings.authentications.length) {
                String login = Settings.getAuthenticationLogin(this.working_settings.authentications[i]);
                String host = Settings.getAuthenticationHost(this.working_settings.authentications[i]);
                this.hashtable_authentications.put(host, base64_encoder.encode(login.getBytes()));
                ++i;
            }
        } else {
            this.hashtable_authentications = null;
        }
        if (registration_checksum1 + 485 != registration_checksum2 && Main.sucker.editing_settings.max_threads > 3) {
            new MessageDialog((Frame)this.frame_control, "The number of threads is limited to 3 in the demo version of PageSucker; although more than 3 threads have been set in the Expert Settings window only three threads will be used for this session. Select \"Register...\" from the \"File\" menu to register your copy.", 3).handle();
        }
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized void startDownload() {
        block43: {
            FileOutputStream fos_logfile;
            block41: {
                Object url_string = null;
                fos_logfile = null;
                this.setStatus("Application Status: Idle", (byte)1);
                this.aborter.clearAbort();
                this.page_save_dir = this.askForPageSaveDir();
                this.frame_control.repaint();
                if (this.page_save_dir == null) break block41;
                if (this.gatherWorkingSettings()) break block42;
            }
            Object var6_3 = null;
            this.frame_control.button_stop_download.setEnabled(false);
            this.frame_control.button_start_download.setEnabled(true);
            this.aborter.clearAbort();
            if (fos_logfile == null) return;
            Date now = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(0, 1);
            df.setTimeZone(TimeZone.getDefault());
            try {
                this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                fos_logfile.close();
                this.out_stream_logfile = null;
                return;
            }
            catch (IOException iOException) {
                this.logMessage("WARNING: Couldn't close log file.");
            }
            {
                SuckerParser parser;
                block42: {
                    return;
                }
                this.frame_control.button_start_download.setEnabled(false);
                this.frame_control.button_stop_download.setEnabled(true);
                this.setStatus("Application Status: Creating Log File", (byte)2);
                try {
                    fos_logfile = new FileOutputStream(this.working_settings.logfilespec);
                    this.out_stream_logfile = new DataOutputStream(fos_logfile);
                    if (this.out_stream_logfile == null) {
                        throw new IOException("NULL DataOutputStream created");
                    }
                }
                catch (IOException iOException) {
                    this.logMessage("WARNING: Can't create log file.");
                    this.out_stream_logfile = null;
                }
                this.writeLogFileHeader();
                this.active_threads = 0;
                this.active_parsing_threads = 0;
                this.total_saved_files = 0;
                this.total_errors = 0;
                ((TextComponent)this.frame_control.textfield_total_saved_files).setText("0");
                ((TextComponent)this.frame_control.textfield_total_errors).setText("0");
                try {
                    String normalized_url_string;
                    boolean save_m3u_files;
                    this.setStatus("Application Status: Initializing", (byte)2);
                    this.frame_control.prepareThreadStatusList();
                    URL url = Parser.buildNormalizedURL(null, this.working_settings.base_url_string, this.working_settings.untyped_object_mode != 11);
                    this.base_url_host = url.getHost();
                    this.base_url_port = url.getPort();
                    this.table_saved_files = new Hashtable(2000, 0.8f);
                    this.list_unparsed_pages = new GenericList();
                    this.set_files_in_use = new FileSet();
                    this.base_url_path_string = Parser.getURLString(url, true, false, false, false);
                    String url_string_wo_ref = Parser.getURLString(url, true, true, false, false);
                    String lower_url_string_wo_ref = url_string_wo_ref.toLowerCase();
                    boolean is_html = this.isHTML(lower_url_string_wo_ref);
                    boolean is_ram = this.isRAM(lower_url_string_wo_ref);
                    boolean is_m3u = this.isM3U(lower_url_string_wo_ref);
                    boolean must_be_parsed = is_html || is_ram || is_m3u;
                    boolean save_ram_files = this.working_settings.ram_file_action == 22;
                    boolean bl = save_m3u_files = this.working_settings.m3u_file_action == 32;
                    byte file_kind = is_html ? (byte)1 : (is_ram ? (byte)2 : (is_m3u ? (byte)3 : 4));
                    ModifiableInteger strategy = new ModifiableInteger(this.working_settings.existing_file_strategy);
                    String dir_name = null;
                    if ((is_html && this.working_settings.save_html_pages || is_ram && save_ram_files || is_m3u && save_m3u_files || !is_html && !is_ram && !is_m3u && this.matchesSaveTypesFilter(lower_url_string_wo_ref)) && this.matchesRegexpFilter(normalized_url_string = Parser.getURLString(url = Parser.addDefaultNameToURL(url, this.working_settings.default_page_names), true, true, true, true))) {
                        dir_name = this.page_save_dir;
                    }
                    if (must_be_parsed || dir_name != null) {
                        parser = new SuckerParser(url, null, this.working_settings.default_page_names, dir_name, file_kind, this.working_settings.use_absolute_paths_in_ram_files, this.working_settings.use_absolute_paths_in_m3u_files, strategy, this.set_files_in_use, this.aborter, this.working_settings.max_recursion_depth, this.working_settings.dont_allow_gt_in_strings, this.working_settings.accept_single_line_comments);
                        this.inscribeSaveFile(Parser.getURLString(url, true, true, false, false), parser.getSaveFile());
                        this.launchNewParseThread(parser);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.setStatus("*** ERROR: Base Page - Malformed URL ***", (byte)1);
                    this.logError("Base Page - Malformed URL: \"" + this.working_settings.base_url_string + "\".");
                    Object var6_4 = null;
                    this.frame_control.button_stop_download.setEnabled(false);
                    this.frame_control.button_start_download.setEnabled(true);
                    this.aborter.clearAbort();
                    if (fos_logfile == null) return;
                    now = new Date();
                    df = DateFormat.getDateTimeInstance(0, 1);
                    df.setTimeZone(TimeZone.getDefault());
                    try {
                        this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                        fos_logfile.close();
                        this.out_stream_logfile = null;
                        return;
                    }
                    catch (IOException iOException) {
                        this.logMessage("WARNING: Couldn't close log file.");
                    }
                    return;
                }
                catch (PageNotFoundException e) {
                    this.setStatus("*** ERROR: Base Page - Page Not Found ***", (byte)1);
                    this.logError("Base Page - Page Not Found: \"" + e.getMessage() + "\".");
                    Object var6_5 = null;
                    this.frame_control.button_stop_download.setEnabled(false);
                    this.frame_control.button_start_download.setEnabled(true);
                    this.aborter.clearAbort();
                    if (fos_logfile == null) return;
                    now = new Date();
                    df = DateFormat.getDateTimeInstance(0, 1);
                    df.setTimeZone(TimeZone.getDefault());
                    try {
                        this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                        fos_logfile.close();
                        this.out_stream_logfile = null;
                        return;
                    }
                    catch (IOException iOException) {
                        this.logMessage("WARNING: Couldn't close log file.");
                    }
                    return;
                }
                catch (AuthorizationErr e) {
                    this.setStatus("*** ERROR: Base Page - Unauthorized Access ***", (byte)1);
                    this.logError("Base Page - Unauthorized Access: \"" + e.getMessage() + "\".");
                    Object var6_6 = null;
                    this.frame_control.button_stop_download.setEnabled(false);
                    this.frame_control.button_start_download.setEnabled(true);
                    this.aborter.clearAbort();
                    if (fos_logfile == null) return;
                    now = new Date();
                    df = DateFormat.getDateTimeInstance(0, 1);
                    df.setTimeZone(TimeZone.getDefault());
                    try {
                        this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                        fos_logfile.close();
                        this.out_stream_logfile = null;
                        return;
                    }
                    catch (IOException iOException) {
                        this.logMessage("WARNING: Couldn't close log file.");
                    }
                    return;
                }
                catch (Problem e) {
                    this.setStatus("*** ERROR: Base Page - Parser Error ***", (byte)1);
                    this.logError("Base Page - A Parser Error has occurred: " + e.getMessage(), e);
                    Object var6_7 = null;
                    this.frame_control.button_stop_download.setEnabled(false);
                    this.frame_control.button_start_download.setEnabled(true);
                    this.aborter.clearAbort();
                    if (fos_logfile == null) return;
                    now = new Date();
                    df = DateFormat.getDateTimeInstance(0, 1);
                    df.setTimeZone(TimeZone.getDefault());
                    try {
                        this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                        fos_logfile.close();
                        this.out_stream_logfile = null;
                        return;
                    }
                    catch (IOException iOException) {
                        this.logMessage("WARNING: Couldn't close log file.");
                    }
                    return;
                }
                catch (ThreadDeath e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.doUnexpectedError(e);
                    Object var6_8 = null;
                    this.frame_control.button_stop_download.setEnabled(false);
                    this.frame_control.button_start_download.setEnabled(true);
                    this.aborter.clearAbort();
                    if (fos_logfile == null) return;
                    now = new Date();
                    df = DateFormat.getDateTimeInstance(0, 1);
                    df.setTimeZone(TimeZone.getDefault());
                    try {
                        this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                        fos_logfile.close();
                        this.out_stream_logfile = null;
                        return;
                    }
                    catch (IOException iOException) {
                        this.logMessage("WARNING: Couldn't close log file.");
                    }
                    return;
                }
                this.setStatus("Application Status: Processing Linked Pages", (byte)2);
                boolean status_aborting_set = false;
                while (true) {
                    if ((parser = (SuckerParser)this.list_unparsed_pages.getFirst()) != null) {
                        if (parser.getParsePageFlag() && this.active_parsing_threads >= this.working_settings.max_parsing_threads && !this.aborter.abortRequested()) {
                            try {
                                this.wait(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        try {
                            if (!this.aborter.abortRequested()) {
                                this.launchNewParseThread(parser);
                            } else if (!status_aborting_set) {
                                this.setStatus("Application Status: Aborting / Waiting for all Threads to Terminate", (byte)2);
                                status_aborting_set = true;
                            }
                            parser.remove();
                            ((TextComponent)this.frame_control.textfield_remaining_documents).setText(Long.toString(this.list_unparsed_pages.getNumberOfElements()));
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            this.logMessage("An out of memory condition was encountered in the master thread.");
                            if (parser.getHeader() != null) {
                                if (this.working_settings.max_threads > 1) {
                                    this.working_settings.max_threads = this.active_threads;
                                    this.logMessage("Reducing maximum number of concurrent threads to " + this.working_settings.max_threads + '.');
                                    continue;
                                }
                                this.logMessage("Aborting.");
                                this.aborter.requestAbort();
                                continue;
                            }
                            this.logMessage("No data loss should have occurred. Continuing ...");
                        }
                        catch (ThreadDeath e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            this.logError("Yeech!! A fatal error occurred in the master thread:", e);
                            this.aborter.requestAbort();
                        }
                        continue;
                    }
                    try {
                        this.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.active_threads <= 0 && this.list_unparsed_pages.getNumberOfElements() <= 0L) break;
                }
            }
            Object var6_9 = null;
            this.frame_control.button_stop_download.setEnabled(false);
            this.frame_control.button_start_download.setEnabled(true);
            this.aborter.clearAbort();
            if (fos_logfile != null) {
                now = new Date();
                df = DateFormat.getDateTimeInstance(0, 1);
                df.setTimeZone(TimeZone.getDefault());
                try {
                    this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                    fos_logfile.close();
                    this.out_stream_logfile = null;
                }
                catch (IOException iOException) {
                    this.logMessage("WARNING: Couldn't close log file.");
                }
            }
            break block43;
            catch (Throwable throwable) {
                Object var6_10 = null;
                this.frame_control.button_stop_download.setEnabled(false);
                this.frame_control.button_start_download.setEnabled(true);
                this.aborter.clearAbort();
                if (fos_logfile == null) throw throwable;
                now = new Date();
                df = DateFormat.getDateTimeInstance(0, 1);
                df.setTimeZone(TimeZone.getDefault());
                try {
                    this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + "Log End (" + df.format(now) + ")." + Constants.endl);
                    fos_logfile.close();
                    this.out_stream_logfile = null;
                    throw throwable;
                }
                catch (IOException iOException) {
                    this.logMessage("WARNING: Couldn't close log file.");
                }
                throw throwable;
            }
        }
        this.setStatus("Application Status: Idle", (byte)1);
        if (!this.working_settings.beep_when_finished) return;
        Toolkit.getDefaultToolkit().beep();
        new MessageDialog((Frame)this.frame_control, "Your download is finished!", 1).handle();
    }

    synchronized void incrementActiveThreads(Parser parser) {
        ((TextComponent)this.frame_control.textfield_active_threads).setText(Integer.toString(++this.active_threads));
        if (parser.getParsePageFlag()) {
            ++this.active_parsing_threads;
        }
    }

    synchronized void decrementActiveThreads(Parser parser) {
        ((TextComponent)this.frame_control.textfield_active_threads).setText(Integer.toString(--this.active_threads));
        if (parser.getParsePageFlag()) {
            --this.active_parsing_threads;
        }
        this.notifyAll();
    }

    synchronized void incrementTotalSavedFiles() {
        ((TextComponent)this.frame_control.textfield_total_saved_files).setText(Integer.toString(++this.total_saved_files));
    }

    synchronized void incrementTotalErrors() {
        ((TextComponent)this.frame_control.textfield_total_errors).setText(Integer.toString(++this.total_errors));
    }

    /*
     * WARNING - void declaration
     */
    synchronized void launchNewParseThread(SuckerParser parser) throws Throwable {
        while (this.active_threads >= this.working_settings.max_threads) {
            try {
                this.wait(3000L);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.aborter.abortRequested()) continue;
            return;
        }
        this.incrementActiveThreads(parser);
        try {
            ParseThread thread = new ParseThread(parser);
            if (thread == null) {
                throw new OutOfMemoryError();
            }
            thread.start();
        }
        catch (Throwable e) {
            void thread;
            this.decrementActiveThreads(parser);
            throw thread;
        }
    }

    public synchronized void setStatus(String item, byte status) {
        ((TextComponent)this.frame_control.textfield_status).setText(item);
        this.application_status = status;
    }

    public synchronized byte getStatus() {
        return this.application_status;
    }

    synchronized void inscribeUnparsedPage(SuckerParser parser) {
        if (parser.getParsePageFlag()) {
            parser.insertLast(this.list_unparsed_pages);
        } else {
            parser.insertFirst(this.list_unparsed_pages);
        }
        ((TextComponent)this.frame_control.textfield_remaining_documents).setText(Long.toString(this.list_unparsed_pages.getNumberOfElements()));
        this.notifyAll();
    }

    synchronized void inscribeSaveFile(String url_string, File save_file) {
        if (this.working_settings.treat_urls_case_insensitive) {
            url_string = url_string.toLowerCase();
        }
        this.table_saved_files.put(url_string, save_file != null ? save_file : new Object());
    }

    synchronized Object retrieveSaveFile(String url_string) {
        if (this.working_settings.treat_urls_case_insensitive) {
            url_string = url_string.toLowerCase();
        }
        return this.table_saved_files.get(url_string);
    }

    synchronized boolean isURLKnown(String url_string) {
        if (this.working_settings.treat_urls_case_insensitive) {
            url_string = url_string.toLowerCase();
        }
        return this.table_saved_files.containsKey(url_string);
    }

    synchronized boolean createParserForPage(URL url, String ref_url_string, String url_string, byte in_file_kind, Parser calling_parser, int in_recursion_level, char quote_char) throws Problem, IOException {
        boolean url_replaced = false;
        String query_url_string_wo_ref = Parser.getURLString(url, true, true, false, true);
        boolean parse_page = in_file_kind == 1 || in_file_kind == 2 || in_file_kind == 3;
        Object obj = this.retrieveSaveFile(query_url_string_wo_ref);
        if (obj != null) {
            if (obj instanceof File) {
                calling_parser.writeLocalURL((File)obj, url.getRef(), quote_char);
                url_replaced = true;
            }
        } else {
            String dir_name = null;
            if (in_file_kind == 4) {
                dir_name = this.page_save_dir;
            } else if (in_file_kind == 1 && this.working_settings.save_html_pages || in_file_kind == 2 && this.working_settings.ram_file_action == 22 || in_file_kind == 3 && this.working_settings.m3u_file_action == 32) {
                dir_name = this.matchesRegexpFilter(url_string) ? this.page_save_dir : null;
            }
            ModifiableInteger strategy = new ModifiableInteger(this.working_settings.existing_file_strategy);
            SuckerParser parser = new SuckerParser(url, ref_url_string, this.working_settings.default_page_names, dir_name, in_file_kind, this.working_settings.use_absolute_paths_in_ram_files, this.working_settings.use_absolute_paths_in_m3u_files, strategy, this.set_files_in_use, this.aborter, in_recursion_level, this.working_settings.dont_allow_gt_in_strings, this.working_settings.accept_single_line_comments);
            if (parser.getSaveFile() != null && (strategy.value == 1 || strategy.value == 2)) {
                this.inscribeSaveFile(query_url_string_wo_ref, parser.getSaveFile());
                calling_parser.writeLocalURL(parser.getSaveFile(), url.getRef(), quote_char);
                url_replaced = true;
            } else {
                this.inscribeSaveFile(query_url_string_wo_ref, null);
            }
            if (strategy.value == 1 || strategy.value == 2 && parse_page) {
                this.inscribeUnparsedPage(parser);
            }
        }
        return url_replaced;
    }

    synchronized boolean matchesRegexpFilter(String url_string) {
        return this.working_settings.pattern_regexp_filter == null || this.matcher_regexp_filter.matches(url_string, (Pattern)this.working_settings.pattern_regexp_filter);
    }

    boolean matchesSaveTypesFilter(String lower_url_string_wo_ref) {
        int dot_index;
        boolean result = true;
        int slash_index = lower_url_string_wo_ref.lastIndexOf(47);
        if (slash_index > (dot_index = lower_url_string_wo_ref.lastIndexOf(46))) {
            result = this.working_settings.untyped_object_mode == 12 && this.working_settings.save_untyped_non_html;
        } else if (this.working_settings.save_types != null && this.working_settings.save_types.length > 0) {
            result = false;
            int i = 0;
            while (i < this.working_settings.save_types.length) {
                if (lower_url_string_wo_ref.endsWith(this.working_settings.save_types[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    boolean isHTML(String lower_url_string_wo_ref) {
        int dot_index;
        int slash_index;
        if (lower_url_string_wo_ref.endsWith("/")) {
            return true;
        }
        if (this.working_settings.html_types != null) {
            int i = 0;
            while (i < this.working_settings.html_types.length) {
                if (lower_url_string_wo_ref.endsWith(this.working_settings.html_types[i])) {
                    return true;
                }
                ++i;
            }
        }
        return (slash_index = lower_url_string_wo_ref.lastIndexOf(47)) > (dot_index = lower_url_string_wo_ref.lastIndexOf(46)) && (this.working_settings.untyped_object_mode == 13 || this.working_settings.untyped_object_mode == 11);
    }

    boolean isRAM(String lower_url_string_wo_ref) {
        return this.working_settings.parse_ram_files && lower_url_string_wo_ref.endsWith(".ram");
    }

    boolean isM3U(String lower_url_string_wo_ref) {
        return this.working_settings.parse_m3u_files && lower_url_string_wo_ref.endsWith(".m3u");
    }

    synchronized void doUnexpectedError(Throwable e) {
        this.logError("*** UNEXPECTED ERROR: ", e);
    }

    public synchronized void logMessage(String message) {
        block2: {
            System.out.println();
            System.out.println(message);
            if (this.out_stream_logfile == null) break block2;
            try {
                this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + message + Constants.endl);
            }
            catch (IOException e1) {
                System.out.println("*** ERROR WHILE WRITING LOG FILE:");
                e1.printStackTrace();
            }
        }
    }

    public synchronized void logError(String message) {
        this.logMessage(message);
        this.incrementTotalErrors();
    }

    public synchronized void logError(String message, Throwable e) {
        System.out.println();
        System.out.println(message);
        e.printStackTrace();
        if (this.out_stream_logfile != null) {
            try {
                this.out_stream_logfile.writeBytes(String.valueOf(Constants.endl) + message + Constants.endl);
                e.printStackTrace(new PrintWriter(this.out_stream_logfile));
            }
            catch (IOException e1) {
                System.out.println("*** ERROR WHILE WRITING LOG FILE:");
                e1.printStackTrace();
            }
        }
        this.incrementTotalErrors();
    }

    void writeLogFileHeader() {
        Date now = new Date();
        DateFormat df = DateFormat.getDateTimeInstance(0, 1);
        df.setTimeZone(TimeZone.getDefault());
        if (this.out_stream_logfile == null) {
            return;
        }
        String os_properties = String.valueOf(System.getProperty("os.name", "Unknown")) + ' ' + System.getProperty("os.version", "???") + " (" + System.getProperty("os.arch", "???") + ')';
        String interpreter_properties = String.valueOf(System.getProperty("java.vendor", "Unknown")) + " (Java Version: " + System.getProperty("java.version", "???") + " / Class Version: " + System.getProperty("java.class.version", "???") + ')';
        try {
            this.out_stream_logfile.writeBytes("** PageSucker " + version_string + " Logfile" + Constants.endl);
            this.out_stream_logfile.writeBytes("** Created on " + df.format(now) + Constants.endl);
            this.out_stream_logfile.writeBytes("** Platform: " + os_properties + Constants.endl);
            this.out_stream_logfile.writeBytes("** Interpreter: " + interpreter_properties + Constants.endl + Constants.endl);
            this.working_settings.writeLog(this.out_stream_logfile);
        }
        catch (IOException iOException) {
            this.logMessage("*** Couldn't write log file header.");
        }
    }

    private String askForPageSaveDir() {
        this.filedialog_save_page.setFile("(The filename is ignored)");
        ((Component)this.filedialog_save_page).setVisible(true);
        String save_dir = this.filedialog_save_page.getDirectory();
        return save_dir;
    }

    private static void initializeJavaVersion() {
        String version_string = System.getProperty("java.version", "0.0.0");
        String[] version_array = StringUtils.tokenizeString(version_string, '.');
        int i = 0;
        while (i < version_array.length) {
            version_array[i] = Constants.alphabet_decimal_number.span(version_array[i]);
            ++i;
        }
        java_sub_sub_version = 0;
        java_sub_version = 0;
        java_version = 0;
        try {
            if (version_array.length > 0) {
                java_version = Integer.parseInt(version_array[0]);
            }
            if (version_array.length > 1) {
                java_sub_version = Integer.parseInt(version_array[1]);
            }
            if (version_array.length > 2) {
                java_sub_sub_version = Integer.parseInt(version_array[2]);
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    static {
        java_version = 0;
        java_sub_version = 0;
        java_sub_sub_version = 0;
        base64_encoder = new BASE64Encoder();
        base64_decoder = new BASE64Decoder();
        about_handler = null;
        String os_name = System.getProperty("os.name", "unknown");
        os_type = os_name.equals("macos") || os_name.equals("Mac OS") ? 1 : (os_name.startsWith("Windows") ? 2 : (os_name.startsWith("OS/2") ? 3 : 0));
        StringBuffer version_string_buffer = new StringBuffer(String.valueOf(2));
        version_string_buffer.append('.');
        version_string_buffer.append(String.valueOf(1));
        version_string = version_string_buffer.toString();
        PageSucker.initializeJavaVersion();
        if (os_type == 1) {
            about_handler = new AboutHandler();
        }
    }
}

