#!/usr/bin/perl
# Quick Website News
# Licensed Under the GNU General Public License (see COPYING File)
#
# You are welcome to modify and improve this program as long as any
# improvements are added to the public code base. I would be more than
# pleased to recieve improvements, comment and suggestions by email at qwn@tildemh.com.
# The latest version of these scripts will always be available from my website
# http://www.tildemh.com
#
#                     Copyright (c) 2001 by Mark Howard
#
#       This program is free software; you can redistribute it and/or
#       modify it under the terms of the GNU General Public License as
#       published by the Free Software Foundation; either version 2 of
#       the License, or (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program in the file 'COPYING'; if not, write to
#       the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
#       Boston, MA 02111-1307, USA, or contact the author:
#
#QWN
# conf.cgi - loads config info and displays it in a html form for editing.

use qwnui;
use config;
use session;
use checksess;
use encode;

&checksess::validsess;
&checksess::loadedproj;

print "Content-Type: text/html\n\n";

print <<END;
<html>
<head>
<title>QWN - Settings</title>
<link href="style.css" typ=text/css rel=stylesheet>
</head>
<body>
END
qwnui::qwnheader;
&checksess::loadedproj;
print "<H1 align=center>Project Settings</h1>";
print <<END;
<form action="index.cgi" method=post>
<center><input type=submit value="Save">&nbsp;&nbsp;<input type=reset value="Undo">
<input type=hidden name=action value=saveconf>
<br><br><table width=100%>
END

$v=&encode::unencode($session::projname);
print "<tr><td width=30%><p align=right>Project Name: <td><input type=text name=projname value=\"$v\">";

print "<tr><td colspan=2><hr><h2>Security Settings</h2>";
$v=&encode::unencode($session::password);
print "<tr><td><p align=right>Password: <td><input type=password name=password value=\"$v\">";
print "<tr><td colspan=2><p>Hosts to allow / Deny. These are for limiting who can edit the settings and news items. Hosts to deny should be separated by commas. These can be either host names or IP addresses. To allow access to all, use * in the allow list and leave the deny list empty. For best security, add your host address (printed on the <a href=\"index.cgi\">front page</a> to the allow list and leave the deny list empty (all others will be denied access unless allow is *).";
$v=&encode::unencode($session::hostsdeny);
print "<tr><td><p align=right>Hosts to Deny: <td><input type=text name=hostsdeny size=80 value=\"$v\">";
$v=&encode::unencode($session::hostsallow);
print "<tr><td><p align=right>Hosts to Allow:<td><input type=text name=hostsallow size=80 value=\"$v\"> ";


print "<tr><td colspan=2><hr><h2>Project Files</h2>";
$v=&encode::unencode($session::filename);
print "<tr><td><p align=right>Project Settings File: <td><input type=hidden name=filename value=\"$v\">$v";
$v=&encode::unencode($session::htmldir);
print "<tr><td valign=top><p align=right>Directory for HTML news files: <td><input type=text name=htmldir value=\"$v\" size=50><p>This is where the static HTML pages of news will be placed, named as defined below. This should be the full path used by the server, not necessarily related to the website's virtual root.";
$v=&encode::unencode($session::newsdb);
print "<tr><td><p align=right>News Database File: <td><p>&lt;QWN DIRECTORY&gt;\/config\/<input type=text name=newsdb value=\"$v\">";
$v=&encode::unencode($session::firstfile);
print "<tr><td><p align=right>First HTML News Filename: <td><input type=text name=firstfile value=\"$v\" size=50>";
$v=&encode::unencode($session::otherfiles);
print "<tr><td><p align=right>Style of Other HTML News Filenames: <td><input type=text name=otherfiles value=\"$v\" size=50>";



print "<tr><td colspan=2><hr><h2>HTML Output Configuration</h2>";
$v=&encode::unencode($session::defauthor);
print "<tr><td><p align=right>Default Author (to appear on the add news page): <td><input type=text name=defauthor value=\"$v\" size=50>";
$v=&encode::unencode($session::firstpagecount);
print "<tr><td><p align=right>Number of items on first page: <td><input type=text name=firstpagecount value=\"$v\" size=4>";
$v=&encode::unencode($session::otherpagecount);
print "<tr><td><p align=right>Number of items on other pages: <td><input type=text name=otherpagecount value=\"$v\" size=4>";
$v=&encode::unencode($session::firsthtmlstart);
print "<tr><td><p align=right>Start HTML for first page: <td><textarea name=firsthtmlstart  rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::firsthtmlend);
print "<tr><td><p align=right>End HTML for first page: <td><textarea name=firsthtmlend  rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::htmlstart);
print "<tr><td><p align=right>Start HTML for other pages: <td><textarea name=htmlstart  rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::htmlend);
print "<tr><td><p align=right>End HTML for other pages: <td><textarea name=htmlend rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::firstitemtemplate);
print "<tr><td><p align=right>News item template for first page: <td><textarea name=firstitemtemplate rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::otheritemtemplate);
print "<tr><td><p align=right>News item template for other pages<td><textarea name=otheritemtemplate rows=6 cols=60>$v</textarea>";
$v=&encode::unencode($session::dateformat);
print "<tr><td><p align=right>Date Format: <td><input type=text name=dateformat value=\"$v\">";
print "<br>hh - hours<br>nn - minutes<br>ss - seconds<br>dd - day [1..31]<br>ddd - day [Mon..Sun]<br>dddd - day [Monday..Sunday]";
print "<br>mm - month [1..12]<br>mmm - month [Jan..Dec]<br>mmmm - month [January..December]<br>yy - year";
# $v=&encode::unencode($session::backupfrequency);
# print "<tr><td><p align=right>Backup Frequnecy: <td><input type=text name=backupfrequency value=\"$v\">";


print <<END;
</table>
<center><input type=submit value="Save">&nbsp;&nbsp;<input type=reset value="Undo">
</form>
END


&config::savesess;


print "</body></html>";

&config::savesess;