/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import jms.graphics.GenericThumbnail;
import jms.graphics.ImageDisplayer;

class ThumbnailsPanel
extends Container {
    public static int SPACE = 3;
    public static int MIN_THUMB_NUM = 7;
    public static int MIN_ROW_NUM = 4;
    private int numberOfThumbnails;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private Dimension lastSize;
    private int thumbnailRowNumber = MIN_THUMB_NUM;
    private Image offScreenImage;
    private Dimension offScreenSize;
    private Graphics offScreenGraphics;

    public ThumbnailsPanel() {
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        this.numberOfThumbnails = 0;
    }

    public synchronized void manageResize() {
        if (this.lastSize == null) {
            this.lastSize = this.getSize();
        }
        Dimension d = this.getSize();
        if (d.width == this.lastSize.width && d.height == this.lastSize.height) {
            return;
        }
        this.lastSize = d;
        this.updateLayout();
        this.repaint();
    }

    public void clear(boolean close_all) {
        Component[] thumbnails = this.getComponents();
        int i = 0;
        while (i < thumbnails.length) {
            this.remove(this, (GenericThumbnail)thumbnails[i]);
            ++i;
        }
        this.numberOfThumbnails = 0;
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        this.gbc = new GridBagConstraints();
        if (close_all) {
            ImageDisplayer.destroyAll();
        }
        this.doLayout();
        this.validate();
        System.gc();
        this.repaint();
    }

    public void add(Component c, GenericThumbnail t) {
        this.gbc.gridwidth = (this.numberOfThumbnails + 1) % this.thumbnailRowNumber == 0 ? 0 : 1;
        this.gbc.insets = new Insets(SPACE, SPACE, SPACE, SPACE);
        this.gbl.setConstraints(t, this.gbc);
        this.add(t);
        ++this.numberOfThumbnails;
    }

    public void remove(Component c, GenericThumbnail t) {
        this.gbl.removeLayoutComponent(t);
        this.remove(t);
        --this.numberOfThumbnails;
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public void update(Graphics g) {
        Dimension d = this.getSize();
        if (this.lastSize == null) {
            this.lastSize = d;
        }
        if (this.offScreenImage == null || d.width != this.offScreenSize.width || d.height != this.offScreenSize.height) {
            this.offScreenImage = this.createImage(d.width, d.height);
            this.offScreenSize = d;
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
        this.paint(this.offScreenGraphics);
        g.drawImage(this.offScreenImage, 0, 0, null);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width - 1, d.height - 1);
        super.paint(g);
    }

    public synchronized void updateLayout() {
        Dimension d = this.lastSize;
        if (this.lastSize == null) {
            d = this.getSize();
        }
        this.thumbnailRowNumber = d.width / 94;
        if (this.thumbnailRowNumber < MIN_THUMB_NUM) {
            this.thumbnailRowNumber = MIN_THUMB_NUM;
        }
        Component[] thumbnails = this.getComponents();
        this.clear(false);
        int i = 0;
        while (i < thumbnails.length) {
            this.add((Component)this, (GenericThumbnail)thumbnails[i]);
            ++i;
        }
        this.doLayout();
        this.validate();
        this.repaint();
    }

    public Dimension getMinimumSize() {
        return new Dimension(280, 280);
    }
}

