/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.File;
import java.util.Hashtable;
import jms.de.NamingConventionPanel;
import jms.graphics.MessageBox;

class OptionsPanel
extends Panel {
    private Label threadsNumberLabel;
    private TextField threadsNumberField;
    private Label outputDirLabel;
    private TextField outputDirField;
    private Label maxStoringSizeLabel;
    private TextField maxStoringSizeField;
    private Checkbox viewerActiveCheckbox;
    private Checkbox reloadLastSessionCheckbox;
    public NamingConventionPanel namingPanel;

    public OptionsPanel() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.threadsNumberLabel = new Label("Simultaneous savings (from 5 to 25) :");
        this.threadsNumberField = new TextField("", 26);
        this.outputDirLabel = new Label("Output directory :");
        this.outputDirField = new TextField("", 26);
        this.maxStoringSizeLabel = new Label("Maximum amout of saved files (in Mb):");
        this.maxStoringSizeField = new TextField("", 26);
        this.viewerActiveCheckbox = new Checkbox("Enable viewer", true, null);
        this.reloadLastSessionCheckbox = new Checkbox("Reload last session at startup", true, null);
        this.namingPanel = new NamingConventionPanel("Download");
        gbc.gridwidth = 1;
        gbc.insets = new Insets(5, 1, 5, 1);
        gbc.anchor = 17;
        gbl.setConstraints(this.threadsNumberLabel, gbc);
        this.add(this.threadsNumberLabel);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.threadsNumberField, gbc);
        this.add(this.threadsNumberField);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbl.setConstraints(this.outputDirLabel, gbc);
        this.add(this.outputDirLabel);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.outputDirField, gbc);
        this.add(this.outputDirField);
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbl.setConstraints(this.maxStoringSizeLabel, gbc);
        this.add(this.maxStoringSizeLabel);
        gbc.anchor = 13;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.maxStoringSizeField, gbc);
        this.add(this.maxStoringSizeField);
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbl.setConstraints(this.viewerActiveCheckbox, gbc);
        this.add(this.viewerActiveCheckbox);
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbl.setConstraints(this.reloadLastSessionCheckbox, gbc);
        this.add(this.reloadLastSessionCheckbox);
        gbc.insets = new Insets(10, 1, 5, 1);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        gbl.setConstraints(this.namingPanel, gbc);
        this.add(this.namingPanel);
        this.setBackground(Color.lightGray);
    }

    public OptionsPanel(Hashtable h) {
        this();
        this.setValues(h);
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.lightGray);
        g.fill3DRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, true);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void setValues(Hashtable properties) {
        this.setValues((String)properties.get("threadsNumber"), (String)properties.get("outputDirectory"), (String)properties.get("prefixName"), (String)properties.get("suffixName"), (String)properties.get("digitNumber"), (String)properties.get("startIndex"), (String)properties.get("stopIndex"), (String)properties.get("fromLinksState"), (String)properties.get("loadEmbedImages"), (String)properties.get("viewerActive"), (String)properties.get("reloadLastSession"), (String)properties.get("maxStoringSize"));
    }

    public void setValues(String t, String o, String p, String s, String dn, String start, String stop, String link_state, String load_embed_images, String viewer, String reload, String ss) {
        ((TextComponent)this.threadsNumberField).setText(t);
        ((TextComponent)this.outputDirField).setText(o);
        ((TextComponent)this.maxStoringSizeField).setText(ss);
        if (viewer.equals("on")) {
            this.viewerActiveCheckbox.setState(true);
        } else {
            this.viewerActiveCheckbox.setState(false);
        }
        if (reload.equals("on")) {
            this.reloadLastSessionCheckbox.setState(true);
        } else {
            this.reloadLastSessionCheckbox.setState(false);
        }
        this.namingPanel.setValues(p, s, dn, start, stop, link_state, load_embed_images);
    }

    public Hashtable getValues() {
        Hashtable properties = this.namingPanel.getValues();
        properties.put("threadsNumber", this.threadsNumberField.getText());
        properties.put("outputDirectory", this.outputDirField.getText());
        properties.put("maxStoringSize", this.maxStoringSizeField.getText());
        if (this.viewerActiveCheckbox.getState()) {
            properties.put("viewerActive", "on");
        } else {
            properties.put("viewerActive", "off");
        }
        if (this.reloadLastSessionCheckbox.getState()) {
            properties.put("reloadLastSession", "on");
        } else {
            properties.put("reloadLastSession", "off");
        }
        return properties;
    }

    public boolean viewerIsActive() {
        return this.viewerActiveCheckbox.getState();
    }

    public boolean goodParameters() {
        File f;
        int n = -1;
        String s = null;
        MessageBox mb = null;
        n = this.getThreadNumber();
        if (n < 5 || n > 25) {
            mb = new MessageBox("Bad connections number!|The number must be between 5 and 25.");
            return false;
        }
        s = this.getDirectory();
        if (!s.trim().equals("") && !(f = new File(s)).isDirectory()) {
            mb = new MessageBox("Bad output directory!|Please verify the path and the name.");
            return false;
        }
        n = this.getMaxStoringSize();
        if (n == -1) {
            mb = new MessageBox("Bad number for Maximum amout of saved files!|Please verify it.|The number is in MegaBytes (Mb).");
            return false;
        }
        n = this.getNumberOfDigits();
        if (n == -1) {
            mb = new MessageBox("Bad number of digits!|Please verify it.|It must be a positive number.");
            return false;
        }
        int start = this.getStartIndex();
        if (start == -1) {
            mb = new MessageBox("Bad start index!|Please verify it.|It must be a positive number.");
            return false;
        }
        int stop = this.getStopIndex();
        if (stop == -1) {
            mb = new MessageBox("Bad stop index!|Please verify it.|It must be a positive number.");
            return false;
        }
        if (start > stop) {
            mb = new MessageBox("Incorrect entry!|Please verify that stop index is greater than start index.");
            return false;
        }
        return true;
    }

    public int getThreadNumber() {
        int n = NamingConventionPanel.getNumber(this.threadsNumberField.getText());
        if (n <= 0) {
            return -1;
        }
        return n;
    }

    public String getDirectory() {
        return this.outputDirField.getText();
    }

    public void setDirectory(String path) {
        ((TextComponent)this.outputDirField).setText(path);
    }

    public int getMaxStoringSize() {
        int n = NamingConventionPanel.getNumber(this.maxStoringSizeField.getText());
        if (n <= 0) {
            return -1;
        }
        return n;
    }

    public void setMaxStoringSize(int storing_size) {
        ((TextComponent)this.maxStoringSizeField).setText(String.valueOf(storing_size));
    }

    public boolean downloadFilesFromLinks() {
        return this.namingPanel.downloadFilesFromLinks();
    }

    public boolean downloadEmbedImages() {
        return this.namingPanel.downloadEmbedImages();
    }

    public int getNumberOfDigits() {
        return this.namingPanel.getNumberOfDigits();
    }

    public int getStartIndex() {
        return this.namingPanel.getStartIndex();
    }

    public int getStopIndex() {
        return this.namingPanel.getStopIndex();
    }

    public String getPrefixName() {
        return this.namingPanel.getPrefixName();
    }

    public String getSuffixName() {
        return this.namingPanel.getSuffixName();
    }
}

