/*
 * Decompiled with CFR 0.152.
 */
package chat;

import java.awt.Image;
import java.awt.Label;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class SerializableImage
implements Serializable,
ImageObserver,
Cloneable {
    static final long serialVersionUID = -2975749503113144495L;
    private transient Image image;
    private int[] buffer;
    private int width;
    private int height;

    public SerializableImage(Image image) {
        this.image = image;
        long l = 20000L;
        long l2 = System.currentTimeMillis();
        while ((this.image.getWidth(this) == -1 || this.image.getHeight(this) == -1) && System.currentTimeMillis() - l2 < l) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.width = Math.max(0, this.image.getWidth(this));
        this.height = Math.max(0, this.image.getHeight(this));
        this.buffer = new int[this.width * this.height];
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.buffer, 0, this.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        objectOutputStream.writeInt(this.width);
        objectOutputStream.writeInt(this.height);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)objectOutputStream, new Deflater(9, false));
        new ObjectOutputStream(deflaterOutputStream).writeObject(this.buffer);
        deflaterOutputStream.finish();
        ((FilterOutputStream)deflaterOutputStream).flush();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.width = objectInputStream.readInt();
        this.height = objectInputStream.readInt();
        InflaterInputStream inflaterInputStream = new InflaterInputStream(objectInputStream, new Inflater(false));
        this.buffer = (int[])new ObjectInputStream(inflaterInputStream).readObject();
        this.image = new Label().createImage(new MemoryImageSource(this.width, this.height, ColorModel.getRGBdefault(), this.buffer, 0, this.width));
    }

    public Image getImage() {
        return this.image;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0;
    }
}

