/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;

public class IdeaCipher
extends BlockCipher {
    private int[] encryptKeys = new int[52];
    private int[] decryptKeys = new int[52];
    private int[] tempShorts = new int[4];

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        CryptoUtils.squashBytesToShorts(byArray, n, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.decryptKeys);
        CryptoUtils.spreadShortsToBytes(this.tempShorts, 0, byArray2, n2, 4);
    }

    private static byte[] strToByte(String string) throws IOException {
        String string2 = "0123456789abcdef";
        if (string.length() % 16 != 0) {
            throw new IOException("Encrypted string must be multiplum of 16");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string2.indexOf(string.charAt(n2)) << 4;
            int n4 = string2.indexOf(string.charAt(n2 + 1));
            byArray[n] = (byte)(n3 + n4);
            ++n;
            n2 += 2;
        }
        return byArray;
    }

    private static int mulinv(int n) {
        if (n <= 1) {
            return n;
        }
        int n2 = 1;
        int n3 = 65537 / n;
        int n4 = 65537 % n & 0xFFFF;
        while (n4 != 1) {
            int n5 = n / n4;
            n2 = n2 + n5 * n3 & 0xFFFF;
            if ((n %= n4) == 1) {
                return n2;
            }
            n5 = n4 / n;
            n4 %= n;
            n3 = n3 + n5 * n2 & 0xFFFF;
        }
        return 1 - n3 & 0xFFFF;
    }

    public IdeaCipher(String string) {
        super(16, 8);
        this.setKey(string);
    }

    public IdeaCipher(byte[] byArray) {
        super(16, 8);
        this.setKey(byArray);
    }

    private void idea(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = 0;
        int n6 = 0;
        do {
            n = IdeaCipher.mul(n & 0xFFFF, nArray3[n5++]);
            n2 += nArray3[n5++];
            int n7 = n5++;
            n4 = IdeaCipher.mul(n4 & 0xFFFF, nArray3[n5++]);
            int n8 = n ^ (n3 += nArray3[n7]);
            n8 = IdeaCipher.mul(n8 & 0xFFFF, nArray3[n5++]);
            int n9 = n8 + (n2 ^ n4);
            n9 = IdeaCipher.mul(n9 & 0xFFFF, nArray3[n5++]);
            n8 = n9 + n8;
            n ^= n9;
            n4 ^= n8;
            n8 ^= n2;
            n2 = n3 ^ n9;
            n3 = n8;
        } while (++n6 < 8);
        nArray2[0] = IdeaCipher.mul(n & 0xFFFF, nArray3[n5++]) & 0xFFFF;
        nArray2[1] = n3 + nArray3[n5++] & 0xFFFF;
        nArray2[2] = n2 + nArray3[n5++] & 0xFFFF;
        nArray2[3] = IdeaCipher.mul(n4 & 0xFFFF, nArray3[n5++]) & 0xFFFF;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        do {
            int n2;
            int n3;
            if ((n3 = IdeaCipher.mul(n, n2 = IdeaCipher.mulinv(n))) == 1) continue;
            System.err.println("mul/mulinv flaw: " + n + " * " + n2 + " = " + n3);
        } while (++n < 65536);
    }

    public String encrypt(String string) throws IOException {
        int n = string.length();
        int n2 = 8 - n % 8;
        byte[] byArray = new byte[n + n2];
        byte[] byArray2 = new byte[n + n2];
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = 0;
            ++n3;
        }
        n3 = 0;
        while (n3 < byArray.length) {
            this.encrypt(byArray, n3, byArray2, n3);
            n3 += 8;
        }
        n3 = 0;
        while (n3 < byArray.length) {
            this.decrypt(byArray2, n3, byArray, n3);
            n3 += 8;
        }
        return IdeaCipher.byteToStr(byArray2);
    }

    public void setKey(byte[] byArray) {
        int n = 0;
        do {
            this.encryptKeys[n] = (byArray[2 * n] & 0xFF) << 8 | byArray[2 * n + 1] & 0xFF;
        } while (++n < 8);
        while (n < 52) {
            this.encryptKeys[n] = (this.encryptKeys[n - 8] << 9 | this.encryptKeys[n - 7] >>> 7) & 0xFFFF;
            ++n;
        }
        n = 0;
        int n2 = 51;
        int n3 = IdeaCipher.mulinv(this.encryptKeys[n++]);
        int n4 = -this.encryptKeys[n++];
        int n5 = -this.encryptKeys[n++];
        this.decryptKeys[n2--] = IdeaCipher.mulinv(this.encryptKeys[n++]);
        this.decryptKeys[n2--] = n5;
        this.decryptKeys[n2--] = n4;
        this.decryptKeys[n2--] = n3;
        int n6 = 1;
        do {
            n3 = this.encryptKeys[n++];
            this.decryptKeys[n2--] = this.encryptKeys[n++];
            this.decryptKeys[n2--] = n3;
            n3 = IdeaCipher.mulinv(this.encryptKeys[n++]);
            n4 = -this.encryptKeys[n++];
            n5 = -this.encryptKeys[n++];
            this.decryptKeys[n2--] = IdeaCipher.mulinv(this.encryptKeys[n++]);
            this.decryptKeys[n2--] = n4;
            this.decryptKeys[n2--] = n5;
            this.decryptKeys[n2--] = n3;
        } while (++n6 < 8);
        n3 = this.encryptKeys[n++];
        this.decryptKeys[n2--] = this.encryptKeys[n++];
        this.decryptKeys[n2--] = n3;
        n3 = IdeaCipher.mulinv(this.encryptKeys[n++]);
        n4 = -this.encryptKeys[n++];
        n5 = -this.encryptKeys[n++];
        this.decryptKeys[n2--] = IdeaCipher.mulinv(this.encryptKeys[n++]);
        this.decryptKeys[n2--] = n5;
        this.decryptKeys[n2--] = n4;
        this.decryptKeys[n2--] = n3;
    }

    private static String byteToStr(byte[] byArray) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(string.charAt(byArray[n] >> 4 & 0xF));
            stringBuffer.append(string.charAt(byArray[n] & 0xF));
            ++n;
        }
        return stringBuffer.toString();
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        CryptoUtils.squashBytesToShorts(byArray, n, this.tempShorts, 0, 4);
        this.idea(this.tempShorts, this.tempShorts, this.encryptKeys);
        CryptoUtils.spreadShortsToBytes(this.tempShorts, 0, byArray2, n2, 4);
    }

    private static int mul(int n, int n2) {
        int n3 = n * n2;
        if (n3 != 0) {
            int n4;
            int n5;
            return n5 - n4 + ((n5 = n3 & 0xFFFF) < (n4 = n3 >>> 16) ? 1 : 0) & 0xFFFF;
        }
        if (n != 0) {
            return 1 - n & 0xFFFF;
        }
        return 1 - n2 & 0xFFFF;
    }

    public String decrypt(String string) throws IOException {
        int n = string.length();
        if (n % 16 != 0) {
            throw new IOException("Invalid Idea encrypted string");
        }
        byte[] byArray = IdeaCipher.strToByte(string);
        byte[] byArray2 = new byte[byArray.length];
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray.length) {
            this.decrypt(byArray, n2, byArray2, n2);
            n2 += 8;
        }
        n2 = 0;
        while (n2 < byArray2.length) {
            stringBuffer.append((char)byArray2[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }
}

