package com.db4o.samples;

import com.db4o.lib.Logger;
import com.db4o.*;

public class S02_Set_Complex
{
	public static void main(String[] args)
	{
		ObjectContainer db = Db4o.openFile("samples.yap");
		Company company = new Company();
		company.name = "DreamFactory";
		company.addresses = new Address[2];
		company.addresses[0] = new Address();
		company.addresses[0].street = "San Antonio Drive";
		company.addresses[0].city = "Cloud Valley";
		company.addresses[1] = new Address();
		company.addresses[1].street = "Heaven 17";
		company.addresses[1].city = "Silicon Hills";


		db.set(company);
		// One call to set() stores all newly added members,
		// no matter how complex an object is.


		Logger.log("*** S02 Company 'DreamFactory' and members were stored to samples.yap.");
		db.close();
	}
}
