package com.db4o.sql;

import com.db4o.jgen.*;
import java.util.*;
import java.io.*;

public class SqlConfiguration
{
	private String i_driver;
	private String i_connect;
	private String i_dbFile;
	private String i_package;
	private String i_user = "";
	private String i_password = "";

	public SqlConfiguration(String a_driver, String a_connectString){
		i_driver = a_driver;
		i_connect = a_connectString;
	}

	public SqlConfiguration(String a_driver, String a_connectString, String a_user, String a_password){
		i_driver = a_driver;
		i_connect = a_connectString;
		i_user = a_user ;
		i_password = a_password;
	}

	public SqlConfiguration(String args[], boolean a_needPackage){
		int argLength = a_needPackage ? 3 : 2;
		if (Sql.debug && Sql.defaultParameters){
			args = new String[argLength + 1];
			args[0] = "JData1_2.sql.$Driver";
			// args[1] = "jdbc:JDataConnect://127.0.0.1/josssybase";
			args[1] = "jdbc:JDataConnect://127.0.0.1/db4oImEx";
			args[2] = "db4o.yap";
			if(a_needPackage){
				args[3] = "com.db4o.sql.imex";
			}
		}
		if(args.length > argLength){
			i_driver = args[0];
			i_connect = args[1];
			i_dbFile = args[2];
			if(a_needPackage){
				i_package = args[3];
			}
			if(args.length > argLength + 1){
				i_user = args[argLength + 1];
			}
			if(args.length > argLength + 2){
				i_password = args[argLength + 2];
			}
		}else{
			String msg = "Needed Parameters: <driver> <connectString> <dbFile>";
			if(a_needPackage){
				msg = msg + " <package>";
			}
			msg = msg + " [<user>] [<password>]";
			Sql.msg(msg);
			Sql.msg("Examples:");
			Sql.msg("JData1_2.sql.$Driver");
			Sql.msg("jdbc:JDataConnect://127.0.0.1/db4oImEx");
			Sql.msg("db4o.yap");
			if(a_needPackage){
				Sql.msg("com.db4o.sql.imex");
			}
			throw new RuntimeException("Wrong args");
		}
	}

	public String getConnect(){
		return i_connect;
	}

	public String getDbFile(){
		return i_dbFile;
	}

	public String getDriver(){
		return i_driver;
	}

	public String getPackage(){
		return i_package;
	}

	public String getUser(){
		return i_user;
	}

	public String getPassword(){
		return i_password;
	}

	String objectPath(){
		return new JPackage(getPackage()).getPath();
	}
}
