package com.db4o.test;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.lib.*;
import java.util.Hashtable;
import java.util.Enumeration;


public class RHashtable implements RTestable{

	public Object newInstance(){
		return new Hashtable();
	}

	public Object set(Object obj, int ver){
		Entry[] arr = new Entry().test(ver);
		Hashtable ht = (Hashtable)obj;
		ht.clear();
		for(int i = 0; i < arr.length; i ++){
			ht.put(arr[i].key, arr[i].value);
		}
		return obj;
	}

	public String compare(ObjectContainer con, Object obj, int ver, String errors){
		Hashtable ht = (Hashtable)obj;
		Entry[] entries = new Entry[ht.size()];
		Enumeration enum = ht.keys();
		int i = 0;
		while(enum.hasMoreElements()){
			entries[i] = new Entry();
			entries[i].key = enum.nextElement();
			i++;
		}
		for(i = 0; i < entries.length; i ++){
			entries[i].value = ht.get(entries[i].key);
		}
		return new Entry().compare(entries, ver, false,errors);
	}

	public String specific(ObjectContainer con, String errors, int step){
		Entry entry = new Entry().firstElement();
		Hashtable ht = (Hashtable)newInstance();
		if(step > 0){
			ht.put(entry.key, entry.value);
			ObjectSet set = con.get(ht);
			Collection col = new Collection();
			while(set.hasNext()){
				Object obj = set.next();
				if(obj.getClass() == ht.getClass()){
					col.add(obj);
				}
			}
			if(col.size() != step){
				errors = errors + "Hashtable member query not found" + Regression.nl;
			}
		}
		entry = new Entry().noElement();
		ht.put(entry.key, entry.value);
		if(con.get(ht).size() != 0){
			errors = errors + "Hashtable member query found too many" + Regression.nl;
		}

		return errors;
	}


	public boolean jdk2(){
		return false;
	}
}
