/*
 * Decompiled with CFR 0.152.
 */
package com.javazine.components;

import com.javazine.components.AppletProperties;
import com.javazine.components.Column;
import com.javazine.components.GridEvent;
import com.javazine.components.GridListener;
import com.javazine.components.Row;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Grid
extends Panel
implements ActionListener,
KeyListener,
TextListener {
    public static final int COLUMN_SPACE_WIDTH = 6;
    public static final int ROW_SPACE_HEIGHT = 4;
    public static final int TOOLTIP_WIDTH = 280;
    public static final int TOOLTIP_HEIGHT = 40;
    private Font fFont = null;
    private Font fToolTipFont = null;
    private FontMetrics fMetrics = null;
    private FontMetrics fToolTipMetrics = null;
    private Graphics gImage = null;
    private Image iImage = null;
    private Image imageCheck = null;
    private Image imageUnCheck = null;
    private Image imageCheckHead = null;
    int iGridWidth = 0;
    int iGridVisibleWidth = 0;
    int iGridHeight = 0;
    int iRowHeadWidth = 0;
    int iRowCheckedWidth = 0;
    int iRowHeight = 0;
    private int iRowVisibleCount = 0;
    private int iGridInitialWidth = 0;
    int iFirstRow = 0;
    int iX = 0;
    int iY = 0;
    public Vector vMainData;
    public Vector vCurrentData;
    public Vector vColumns;
    private Hashtable htIndex;
    private Vector listeners = new Vector();
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iXDrag;
    int iColDrag;
    boolean bOverBasketColumn = false;
    int iOverBasketRow = -1;
    int iCurrentRow = 0;
    int iCurrentColumn = 0;
    private MediaTracker tracker = null;
    private Color colorCurrentRow = null;
    private Color colorCurrentColumn = null;
    private Color colorCurrentCell = null;
    private Color colorBackGround = null;
    private Color colorGridLines = null;
    private Color colorFont = null;
    private Color colorToolTipBg = null;
    long longLastClick = 0L;
    private TextField txtEdit = null;
    private String toolTip = "";
    private boolean bCheckColumn = true;
    private boolean bShowToolTip = true;
    AppletProperties properties = null;

    public void removeGridListener(GridListener gridListener) {
        this.listeners.removeElement(gridListener);
    }

    public void fireEvent(GridEvent gridEvent) {
        Vector vector = (Vector)this.listeners.clone();
        int n = 0;
        while (n < vector.size()) {
            GridListener gridListener = (GridListener)vector.elementAt(n);
            gridListener.gridChanged(gridEvent);
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 40: {
                this.requestFocus();
                this.select(this.iCurrentRow + 1, this.iCurrentColumn);
                return;
            }
            case 38: {
                this.requestFocus();
                this.select(this.iCurrentRow - 1, this.iCurrentColumn);
                return;
            }
            case 39: {
                if (this.getCell(this.iCurrentColumn, this.iCurrentRow).length() > this.txtEdit.getCaretPosition()) break;
                this.requestFocus();
                this.select(this.iCurrentRow, this.iCurrentColumn + 1);
                return;
            }
            case 37: {
                if (this.txtEdit.getCaretPosition() != 0) break;
                this.requestFocus();
                this.select(this.iCurrentRow, this.iCurrentColumn - 1);
                return;
            }
        }
    }

    void select(int n, int n2) {
        int n3 = this.iCurrentRow;
        this.iCurrentRow = n < 0 ? 0 : (n >= this.vCurrentData.size() ? this.vCurrentData.size() - 1 : n);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.vColumns.size()) {
            n2 = this.vColumns.size() - 1;
        }
        int n4 = this.iCurrentColumn;
        while (n2 > this.iCurrentColumn && n4 < this.vColumns.size()) {
            if (!((Column)this.vColumns.elementAt((int)(++n4))).bVisible) continue;
            ++this.iCurrentColumn;
        }
        while (n2 < this.iCurrentColumn && n4 > 0) {
            if (!((Column)this.vColumns.elementAt((int)(--n4))).bVisible) continue;
            this.iCurrentColumn += -1;
        }
        while (this.iCurrentRow < this.iFirstRow && this.iFirstRow > 0) {
            this.iFirstRow += -1;
            this.iY -= this.iRowHeight;
        }
        while (this.iCurrentRow > this.iFirstRow - 2 + this.iGridHeight / this.iRowHeight && this.iFirstRow < this.vCurrentData.size() - 1) {
            ++this.iFirstRow;
            this.iY += this.iRowHeight;
        }
        this.adjustScroll();
        this.updateGrid();
        if (n3 != this.iCurrentRow) {
            this.fireEvent(new GridEvent(this, this.iCurrentColumn, this.iCurrentRow, 0));
        }
    }

    public void addRow(String[] stringArray) {
        int n = 0;
        Row row = new Row(stringArray);
        int n2 = stringArray.length <= this.vColumns.size() ? stringArray.length : this.vColumns.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((Column)this.vColumns.elementAt((int)n3)).bAutoWidth) {
                ((Column)this.vColumns.elementAt((int)n3)).iWidth = ((Column)this.vColumns.elementAt((int)n3)).hasAlias ? Math.max(((Column)this.vColumns.elementAt((int)n3)).iWidth, this.fMetrics.stringWidth(((Column)this.vColumns.elementAt((int)n3)).sAlias) + 6) : (((Column)this.vColumns.elementAt((int)n3)).iType == 5 ? Math.max(((Column)this.vColumns.elementAt((int)n3)).iWidth, this.fMetrics.stringWidth("image") + 6) : Math.max(((Column)this.vColumns.elementAt((int)n3)).iWidth, this.fMetrics.stringWidth(stringArray[n3]) + 6));
            }
            if (((Column)this.vColumns.elementAt((int)n3)).bVisible) {
                n += ((Column)this.vColumns.elementAt((int)n3)).iWidth;
            }
            if (((Column)this.vColumns.elementAt((int)n3)).iType == 7) {
                Vector vector;
                if (this.htIndex.containsKey(stringArray[n3])) {
                    vector = (Vector)this.htIndex.get(stringArray[n3]);
                    if (vector.indexOf(stringArray) == -1) {
                        vector.addElement(row);
                    }
                } else {
                    vector = new Vector();
                    vector.addElement(row);
                    this.htIndex.put(stringArray[n3], vector);
                }
            }
            ++n3;
        }
        this.vMainData.addElement(row);
        this.vCurrentData = this.vMainData;
        this.iRowHeadWidth = Math.max(this.iRowHeadWidth, this.fMetrics.stringWidth(String.valueOf(this.vMainData.size())) + 6);
        this.iGridVisibleWidth = Math.max(this.iGridVisibleWidth, n);
        this.sbVert.setValues(0, this.iGridHeight / this.iRowHeight, 0, this.vCurrentData.size() + 1);
        this.adjustScroll();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.requestFocus();
        this.select(this.iCurrentRow + 1, this.iCurrentColumn);
    }

    public void updateGrid() {
        int n;
        if (this.gImage == null) {
            return;
        }
        this.gImage.setFont(this.fFont);
        this.txtEdit.setBounds(-1000, -1000, 0, 0);
        this.gImage.setColor(this.colorBackGround);
        this.gImage.fillRect(0, 0, this.iGridVisibleWidth, this.iGridHeight);
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, this.iGridVisibleWidth, this.iRowHeight);
        int n2 = -this.iX + this.iRowHeadWidth + this.iRowCheckedWidth;
        int n3 = 0;
        while (n3 < this.vColumns.size()) {
            if (((Column)this.vColumns.elementAt((int)n3)).bVisible) {
                n = ((Column)this.vColumns.elementAt((int)n3)).iWidth;
                this.gImage.setColor(Color.lightGray);
                this.gImage.fillRect(n2 + 1, 0, n - 2, this.iRowHeight);
                this.gImage.setColor(Color.black);
                this.gImage.drawString(((Column)this.vColumns.elementAt((int)n3)).sHeader, n2 + 2, this.iRowHeight - 3);
                this.gImage.setColor(Color.darkGray);
                this.gImage.drawLine(n2 + n - 1, 0, n2 + n - 1, this.iRowHeight - 1);
                this.gImage.setColor(Color.white);
                this.gImage.drawLine(n2 + n, 0, n2 + n, this.iRowHeight - 1);
                n2 += n;
            }
            ++n3;
        }
        if (this.bCheckColumn) {
            this.gImage.setColor(Color.lightGray);
            this.gImage.fillRect(this.iRowHeadWidth, 0, this.iRowCheckedWidth, this.iRowHeight);
            this.gImage.drawImage(this.imageCheckHead, this.iRowHeadWidth, 0, this);
        }
        n3 = this.iY / this.iRowHeight;
        int n4 = this.iRowHeight + 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        this.iFirstRow = n3;
        n2 = -this.iX + this.iRowHeadWidth + this.iRowCheckedWidth;
        int n8 = 0;
        while (n8 < this.vColumns.size()) {
            if (((Column)this.vColumns.elementAt((int)n8)).bVisible) {
                n = ((Column)this.vColumns.elementAt((int)n8)).iWidth;
                this.gImage.setColor(this.colorBackGround);
                this.gImage.fillRect(n2, this.iRowHeight + 1, n - 1, this.iGridHeight);
                this.gImage.setColor(this.colorFont);
                n3 = this.iFirstRow;
                n4 = this.iRowHeight + 1;
                while (n4 < this.iGridHeight) {
                    if (n3 < this.vCurrentData.size()) {
                        if (this.iCurrentRow == n3) {
                            n5 = n4;
                            if (this.iCurrentColumn == n8) {
                                n6 = n2;
                                n7 = n;
                            } else {
                                this.gImage.setColor(this.colorCurrentRow);
                                this.gImage.fillRect(n2, n4, n - 1, this.iRowHeight);
                                this.gImage.setColor(this.colorFont);
                            }
                        }
                        if (((Column)this.vColumns.elementAt((int)n8)).hasAlias && this.getCell(n8, n3).length() > 0) {
                            this.gImage.setColor(Color.blue);
                            this.gImage.drawString(((Column)this.vColumns.elementAt((int)n8)).sAlias, n2 + 2, n4 + this.iRowHeight - 5);
                            this.gImage.setColor(this.colorFont);
                        } else {
                            this.gImage.drawString(this.getCell(n8, n3), n2 + 2, n4 + this.iRowHeight - 5);
                        }
                        if (this.iX == 0 && this.iCurrentColumn == n8 && this.iCurrentRow == n3 && ((Column)this.vColumns.elementAt((int)n8)).bEdit) {
                            this.txtEdit.setBounds(n2, n4, ((Column)this.vColumns.elementAt((int)n8)).iWidth, this.iRowHeight);
                            ((TextComponent)this.txtEdit).setText(this.getCell(n8, n3));
                            this.txtEdit.requestFocus();
                        }
                    }
                    ++n3;
                    n4 += this.iRowHeight;
                }
                this.gImage.setColor(Color.black);
                this.gImage.drawLine(n2 + n - 1, this.iRowHeight + 1, n2 + n - 1, this.iGridHeight);
                n2 += n;
            }
            ++n8;
        }
        String string = "";
        if (n5 > 0) {
            string = this.getCell(this.iCurrentColumn, this.iCurrentRow);
            n = Math.max(n7, this.fMetrics.stringWidth(string) + 6);
            this.gImage.setColor(this.colorCurrentCell);
            this.gImage.fillRect(n6, n5, n - 1, this.iRowHeight);
            this.gImage.setColor(this.colorFont);
            this.gImage.drawString(string, n6 + 2, n5 + this.iRowHeight - 5);
        }
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, this.iRowHeadWidth, this.iGridHeight);
        this.gImage.setColor(this.colorBackGround);
        this.gImage.fillRect(this.iRowHeadWidth, this.iRowHeight + 1, this.iRowCheckedWidth, this.iGridHeight);
        n3 = this.iFirstRow;
        n4 = this.iRowHeight + 1;
        while (n4 < this.iGridHeight) {
            if (n3 < this.vCurrentData.size()) {
                this.gImage.setColor(this.colorFont);
                this.gImage.drawString(String.valueOf(n3 + 1), 2, n4 + this.iRowHeight - 5);
                if (this.bCheckColumn) {
                    if (((Row)this.vCurrentData.elementAt((int)n3)).bChecked) {
                        this.gImage.drawImage(this.imageCheck, this.iRowHeadWidth + 5, n4 + 4, this);
                    } else {
                        this.gImage.drawImage(this.imageUnCheck, this.iRowHeadWidth + 5, n4 + 4, this);
                    }
                }
            }
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(0, n4 + this.iRowHeight - 1, this.iRowHeadWidth, n4 + this.iRowHeight - 1);
            this.gImage.setColor(Color.lightGray);
            this.gImage.drawLine(this.iRowHeadWidth, n4 + this.iRowHeight - 1, this.iGridVisibleWidth, n4 + this.iRowHeight - 1);
            ++n3;
            n4 += this.iRowHeight;
        }
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(this.iRowHeadWidth - 1, 0, this.iRowHeadWidth - 1, this.iGridHeight);
        this.gImage.drawLine(this.iRowHeadWidth + this.iRowCheckedWidth - 1, 0, this.iRowHeadWidth + this.iRowCheckedWidth - 1, this.iGridHeight);
        this.gImage.drawLine(0, this.iRowHeight, this.iGridVisibleWidth, this.iRowHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, 0, this.iGridVisibleWidth, 0);
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(this.iGridVisibleWidth, this.iGridHeight, this.sbVert.getPreferredSize().width, this.sbHoriz.getPreferredSize().height);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawRect(0, 0, this.iGridVisibleWidth + this.sbVert.getPreferredSize().width, this.iGridHeight + this.sbHoriz.getPreferredSize().height);
        this.repaint();
    }

    private boolean compare(String string, String string2, int n) {
        if (((Column)this.vColumns.elementAt((int)n)).iType == 1) {
            try {
                return Double.valueOf(string) < Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return string.compareTo(string2) <= 0;
    }

    public void searchSlow(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[10];
        boolean[] cfr_ignored_0 = new boolean[10];
        Row row = null;
        Vector<Row> vector = new Vector<Row>();
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        this.fireEvent(new GridEvent(this, 0, 0, 3));
        while (stringTokenizer.hasMoreElements() && n < 10) {
            stringArray[n] = (String)stringTokenizer.nextElement();
            ++n;
        }
        this.setCursor(new Cursor(3));
        int n2 = 0;
        while (n2 < this.vMainData.size()) {
            row = (Row)this.vMainData.elementAt(n2);
            bl2 = true;
            int n3 = 0;
            while (n3 < n) {
                bl = false;
                int n4 = 0;
                while (n4 < row.sRow.length) {
                    if (row.sRow[n4].toUpperCase().indexOf(stringArray[n3].toUpperCase()) > -1) {
                        n4 = 10000;
                        bl = true;
                    }
                    ++n4;
                }
                if (!bl) {
                    bl2 = false;
                    n3 = n;
                }
                ++n3;
            }
            if (bl2) {
                vector.addElement(row);
            }
            this.fireEvent(new GridEvent(this, 0, n2, 4));
            ++n2;
        }
        this.vCurrentData = vector;
        this.iCurrentRow = 0;
        this.iFirstRow = 0;
        this.iY = 0;
        this.iCurrentColumn = 0;
        this.sbVert.setMaximum(this.vCurrentData.size() + 1);
        this.resetSelectedRow();
        this.updateGrid();
        this.fireEvent(new GridEvent(this, 0, 0, 0));
        this.fireEvent(new GridEvent(this, 0, 0, 5));
        this.setCursor(new Cursor(0));
    }

    public void moveFirst() {
        this.select(0, this.iCurrentColumn);
    }

    private void siftup(int n, int n2, int n3) {
        Object e = this.vCurrentData.elementAt(n);
        String string = this.getCell(n3, n);
        int n4 = n;
        int n5 = n + n + 1;
        while (n5 < n2) {
            if (this.compare(this.getCell(n3, n5), this.getCell(n3, n5 + 1), n3)) {
                ++n5;
            }
            this.vCurrentData.setElementAt(this.vCurrentData.elementAt(n5), n);
            n = n5;
            n = n5;
            n5 = n + n5 + 1;
        }
        if (n5 == n2) {
            this.vCurrentData.setElementAt(this.vCurrentData.elementAt(n5), n);
            n = n5;
        }
        n5 = n - 1 >> 1;
        while (n5 >= n4 && this.compare(this.getCell(n3, n5), string, n3)) {
            this.vCurrentData.setElementAt(this.vCurrentData.elementAt(n5), n);
            n = n5;
            n5 = n - 1 >> 1;
        }
        this.vCurrentData.setElementAt(e, n);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iGridHeight = n4 - this.sbHoriz.getPreferredSize().height;
        this.iGridVisibleWidth = n3 - this.sbVert.getPreferredSize().width;
        this.sbHoriz.setBounds(0, this.iGridHeight, this.iGridVisibleWidth, this.sbHoriz.getPreferredSize().height);
        this.sbVert.setBounds(this.iGridVisibleWidth, 0, this.sbVert.getPreferredSize().width, this.iGridHeight);
        this.adjustScroll();
        this.iImage = null;
        this.updateGrid();
    }

    public Vector getColumns() {
        return this.vColumns;
    }

    public void textValueChanged(TextEvent textEvent) {
        if (!this.txtEdit.getText().trim().equals(((Row)this.vCurrentData.elementAt((int)this.iCurrentRow)).sRow[this.iCurrentColumn])) {
            ((Row)this.vCurrentData.elementAt((int)this.iCurrentRow)).sRow[this.iCurrentColumn] = this.txtEdit.getText().trim();
            this.fireEvent(new GridEvent(this, this.iCurrentColumn, this.iCurrentRow, 8));
        }
    }

    public void setColumns(Vector vector) {
        this.vColumns = vector;
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            if (((Column)vector.elementAt((int)n2)).bVisible) {
                ++n;
            }
            ++n2;
        }
        this.sbHoriz.setValues(0, 1, 0, n);
        this.adjustScroll();
        this.updateGrid();
    }

    public void setToolTip(String string) {
        if (this.bShowToolTip) {
            this.toolTip = string;
            this.repaint();
        }
    }

    public void enableToolTip(boolean bl) {
        this.bShowToolTip = bl;
    }

    private void resetSelectedRow() {
        int n = 0;
        while (n < this.vCurrentData.size()) {
            ((Row)this.vCurrentData.elementAt((int)n)).bChecked = false;
            ++n;
        }
    }

    public Grid(Image image, Image image2, Image image3, AppletProperties appletProperties) {
        this.properties = appletProperties;
        this.vMainData = new Vector();
        this.vCurrentData = new Vector();
        this.vColumns = new Vector();
        this.htIndex = new Hashtable();
        this.fFont = new Font("Helvetica", 0, 12);
        this.fMetrics = this.getToolkit().getFontMetrics(this.fFont);
        this.fToolTipFont = new Font("Helvetica", 1, 12);
        this.fToolTipMetrics = this.getToolkit().getFontMetrics(this.fToolTipFont);
        this.iRowHeight = this.fMetrics.getHeight() + 4;
        if (image == null || image2 == null || image3 == null) {
            this.iRowCheckedWidth = 0;
            this.bCheckColumn = false;
        } else {
            this.imageCheck = image;
            this.imageUnCheck = image2;
            this.imageCheckHead = image3;
            this.tracker = new MediaTracker(this);
            this.iRowCheckedWidth = 22;
        }
        this.iRowVisibleCount = 20;
        this.iGridInitialWidth = 400;
        this.colorCurrentRow = new Color(192, 255, 255);
        this.colorCurrentColumn = Color.lightGray;
        this.colorCurrentCell = new Color(0, 192, 192);
        this.colorToolTipBg = new Color(255, 255, 128);
        this.colorFont = Color.black;
        this.colorGridLines = Color.black;
        this.colorBackGround = Color.white;
        this.iCurrentRow = 0;
        this.iCurrentColumn = 0;
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
        this.sbHoriz.setValues(0, 1, 0, this.vColumns.size());
        this.sbVert.setValues(0, this.iGridHeight / this.iRowHeight, 0, this.vCurrentData.size() + 1);
        GridMouseListener gridMouseListener = new GridMouseListener();
        GridKeyListener gridKeyListener = new GridKeyListener();
        this.addMouseListener(gridMouseListener);
        this.addMouseMotionListener(gridMouseListener);
        this.sbHoriz.addAdjustmentListener(gridMouseListener);
        this.sbVert.addAdjustmentListener(gridMouseListener);
        this.addKeyListener(gridKeyListener);
        this.longLastClick = System.currentTimeMillis();
        this.txtEdit = new TextField();
        this.add(this.txtEdit);
        this.txtEdit.setVisible(true);
        this.txtEdit.addActionListener(this);
        this.txtEdit.addTextListener(this);
        this.txtEdit.addKeyListener(this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.iGridVisibleWidth <= 0 || this.iGridHeight <= 0) {
            return;
        }
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iGridVisibleWidth, this.iGridHeight);
            this.gImage = this.iImage.getGraphics();
            this.updateGrid();
        }
        graphics.drawImage(this.iImage, 0, 0, this);
        if (this.toolTip.length() > 0) {
            int n = Math.max(0, this.iGridVisibleWidth - 280);
            graphics.setFont(this.fToolTipFont);
            graphics.setColor(this.colorToolTipBg);
            graphics.fillRect(n / 2, 40, 280, 40);
            graphics.setColor(Color.black);
            graphics.drawString(this.toolTip, (this.iGridVisibleWidth - this.fMetrics.stringWidth(this.toolTip)) / 2, 40 + (40 + this.fToolTipMetrics.getHeight()) / 2);
            graphics.drawRect(n / 2, 40, 280, 40);
            this.toolTip = "";
        }
    }

    public Vector getCheckedRows() {
        Vector<Row> vector = new Vector<Row>();
        int n = 0;
        while (n < this.vMainData.size()) {
            Row row = (Row)this.vMainData.elementAt(n);
            if (row.bChecked) {
                vector.addElement(row);
            }
            ++n;
        }
        return vector;
    }

    void sort(int n) {
        int n2 = this.vCurrentData.size();
        int n3 = 1;
        while (n3 < n2 && this.compare(this.getCell(n, n3 - 1), this.getCell(n, n3), n)) {
            ++n3;
        }
        if (n3 == n2) {
            return;
        }
        n3 = (n2 >> 1) - 1;
        while (n3 > 0) {
            this.siftup(n3, n2 - 1, n);
            --n3;
        }
        n3 = n2 - 1;
        while (n3 > 0) {
            this.siftup(0, n3, n);
            Row row = (Row)this.vCurrentData.elementAt(0);
            this.vCurrentData.setElementAt(this.vCurrentData.elementAt(n3), 0);
            this.vCurrentData.setElementAt(row, n3);
            --n3;
        }
        this.updateGrid();
    }

    public void setColumnType(int n, int n2) {
        if (n < 0 || n >= this.vColumns.size() || n2 < 0 || n2 > 5) {
            return;
        }
        ((Column)this.vColumns.elementAt((int)n)).iType = n2;
        this.updateGrid();
    }

    public void addGridListener(GridListener gridListener) {
        this.listeners.addElement(gridListener);
    }

    void adjustScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        this.iX = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.vColumns.size()) {
            if (((Column)this.vColumns.elementAt((int)n3)).bVisible) {
                n += ((Column)this.vColumns.elementAt((int)n3)).iWidth;
                if (n3 < this.iCurrentColumn) {
                    n2 = n;
                    ++n4;
                }
            }
            ++n3;
        }
        n3 = 0;
        this.iGridWidth = n;
        while (n2 - this.iX > this.iGridVisibleWidth) {
            if (!((Column)this.vColumns.elementAt((int)n3)).bVisible) continue;
            this.iX += ((Column)this.vColumns.elementAt((int)n3)).iWidth;
            ++n3;
        }
        this.sbHoriz.setValue(n3);
        int n5 = this.iY / this.iRowHeight;
        this.sbVert.setValue(n5);
    }

    public Vector getCategories() {
        Vector vector = new Vector();
        Enumeration enumeration = this.htIndex.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public void addColumn(Column column) {
        int n;
        if (column.iWidth == 0) {
            column.iWidth = n = this.fMetrics.stringWidth(column.sHeader) + 6;
        } else {
            n = column.iWidth;
        }
        this.vColumns.addElement(column);
        if (column.bVisible) {
            this.iGridWidth += n;
            this.sbHoriz.setValues(0, 1, 0, this.sbHoriz.getMaximum() + 1);
        }
    }

    public void showCategories(String string) {
        if (this.htIndex.containsKey(string)) {
            // empty if block
        }
        this.vCurrentData = (Vector)this.htIndex.get(string);
        this.iCurrentRow = 0;
        this.iFirstRow = 0;
        this.iY = 0;
        this.iCurrentColumn = 0;
        this.sbVert.setMaximum(this.vCurrentData.size() + 1);
        this.resetSelectedRow();
        this.updateGrid();
        this.fireEvent(new GridEvent(this, 0, 0, 0));
    }

    public void moveLast() {
        this.select(this.vCurrentData.size() - 1, this.iCurrentColumn);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setColumnWidth(int n, int n2) {
        if (n < 0 || n >= this.vColumns.size() || n2 < 0 || n2 > 10000) {
            return;
        }
        ((Column)this.vColumns.elementAt((int)n)).iWidth = n2;
        this.adjustScroll();
        this.updateGrid();
    }

    private void calcAutoWidth(int n) {
        int n2 = 10;
        this.iRowHeadWidth = 0;
        n2 = Math.max(n2, ((Column)this.vColumns.elementAt((int)n)).iWidth);
        int n3 = 0;
        while (n3 < this.vCurrentData.size()) {
            String[] stringArray = ((Row)this.vCurrentData.elementAt((int)n3)).sRow;
            n2 = Math.max(n2, this.fMetrics.stringWidth(stringArray[n]));
            this.iRowHeadWidth = Math.max(this.iRowHeadWidth, this.fMetrics.stringWidth(String.valueOf(n3)) + 6);
            ++n3;
        }
        ((Column)this.vColumns.elementAt((int)n)).iWidth = n2 + 6;
    }

    public void moveNext() {
        this.select(this.iCurrentRow + 1, this.iCurrentColumn);
    }

    public void showAll() {
        this.vCurrentData = this.vMainData;
        this.iCurrentRow = 0;
        this.iCurrentColumn = 0;
        this.iY = 0;
        this.sbVert.setMaximum(this.vCurrentData.size() + 1);
        this.adjustScroll();
        this.updateGrid();
    }

    public void movePrevious() {
        this.select(this.iCurrentRow - 1, this.iCurrentColumn);
    }

    public String getCell(int n, int n2) {
        if (n < 0 || n >= this.vColumns.size()) {
            return "";
        }
        if (n2 < 0 || n2 > this.vCurrentData.size() - 1) {
            return "";
        }
        return ((Row)this.vCurrentData.elementAt((int)n2)).sRow[n];
    }

    public String getCell() {
        return ((Row)this.vCurrentData.elementAt((int)this.iCurrentRow)).sRow[this.iCurrentColumn];
    }

    public void setCell(int n, int n2, String string) {
        if (n < 0 || n >= this.vColumns.size()) {
            return;
        }
        if (n2 < 0 || n2 > this.vCurrentData.size() - 1) {
            return;
        }
        ((Row)this.vCurrentData.elementAt((int)n2)).sRow[n] = string;
        this.updateGrid();
    }

    public Row getRow(int n) {
        if (n < 0 || n > this.vCurrentData.size()) {
            return null;
        }
        return (Row)this.vCurrentData.elementAt(n);
    }

    public Row getRow() {
        return (Row)this.vCurrentData.elementAt(this.iCurrentRow);
    }

    public void setRows(Vector vector) {
        this.vMainData.removeAllElements();
        this.vCurrentData = this.vMainData = vector;
        this.sbVert.setValues(0, this.iGridHeight / this.iRowHeight, 0, this.vCurrentData.size() + 1);
        this.iRowHeadWidth = this.fMetrics.stringWidth(String.valueOf(this.vMainData.size())) + 6;
        this.updateGrid();
    }

    public Column getColumn() {
        return (Column)this.vColumns.elementAt(this.iCurrentColumn);
    }

    private final class GridMouseListener
    extends MouseAdapter
    implements AdjustmentListener,
    MouseListener,
    MouseMotionListener {
        boolean bDrag;

        private int getCol(int n) {
            if (n >= 0 && n <= Grid.this.iRowHeadWidth) {
                return -2;
            }
            if (n > Grid.this.iRowHeadWidth && n < Grid.this.iRowHeadWidth + Grid.this.iRowCheckedWidth) {
                return -1;
            }
            n += Grid.this.iX - Grid.this.iRowHeadWidth - Grid.this.iRowCheckedWidth;
            int n2 = 0;
            while (n2 < Grid.this.vColumns.size()) {
                if (((Column)Grid.this.vColumns.elementAt((int)n2)).bVisible) {
                    int n3 = ((Column)Grid.this.vColumns.elementAt((int)n2)).iWidth;
                    if (n >= 0 && n <= n3) {
                        return n2;
                    }
                    n -= n3;
                }
                ++n2;
            }
            return 0;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            switch (adjustmentEvent.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    while (n3 < Grid.this.sbHoriz.getValue() && n3 < Grid.this.vColumns.size()) {
                        if (((Column)Grid.this.vColumns.elementAt((int)n2)).bVisible) {
                            n += ((Column)Grid.this.vColumns.elementAt((int)n2)).iWidth;
                            ++n3;
                        }
                        ++n2;
                    }
                    Grid.this.iX = n;
                    Grid.this.iY = Grid.this.iRowHeight * Grid.this.sbVert.getValue();
                    Grid.this.updateGrid();
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (Grid.this.iRowHeight == 0 || n > Grid.this.iGridVisibleWidth || n2 > Grid.this.iGridHeight) {
                return;
            }
            int n3 = this.getCol(n);
            if (n2 > Grid.this.iRowHeight) {
                int n4 = n2 / Grid.this.iRowHeight - 1 + Grid.this.iFirstRow;
                if (n4 >= Grid.this.vCurrentData.size()) {
                    n4 = Grid.this.vCurrentData.size() - 1;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n3 == -1) {
                    if (((Row)Grid.this.vCurrentData.elementAt((int)n4)).bChecked) {
                        ((Row)Grid.this.vCurrentData.elementAt((int)n4)).bChecked = false;
                        Grid.this.fireEvent(new GridEvent(this, n3, n4, 7));
                    } else {
                        ((Row)Grid.this.vCurrentData.elementAt((int)n4)).bChecked = true;
                        Grid.this.fireEvent(new GridEvent(this, n3, n4, 6));
                    }
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                int n5 = Grid.this.iCurrentRow;
                int n6 = Grid.this.iCurrentColumn;
                int n7 = Grid.this.iCurrentColumn;
                Grid.this.iCurrentRow = n4;
                while (n3 > Grid.this.iCurrentColumn && n7 < Grid.this.vColumns.size()) {
                    if (!((Column)Grid.this.vColumns.elementAt((int)(++n7))).bVisible) continue;
                    ++Grid.this.iCurrentColumn;
                }
                while (n3 < Grid.this.iCurrentColumn && n7 > 0) {
                    if (!((Column)Grid.this.vColumns.elementAt((int)(--n7))).bVisible) continue;
                    Grid.this.iCurrentColumn += -1;
                }
                System.currentTimeMillis();
                if (n4 == n5 && n3 == n6) {
                    if (System.currentTimeMillis() - Grid.this.longLastClick < 1000L) {
                        Grid.this.fireEvent(new GridEvent(this, n3, n4, 2));
                    }
                } else {
                    Grid.this.fireEvent(new GridEvent(this, n3, n4, 0));
                }
                Grid.this.fireEvent(new GridEvent(this, n3, n4, 1));
                Grid.this.updateGrid();
            } else if (!this.bDrag) {
                Grid.this.sort(n3);
            }
            Grid.this.longLastClick = System.currentTimeMillis();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            mouseEvent.getY();
            if (this.bDrag && n < Grid.this.iGridVisibleWidth) {
                int n2 = n - Grid.this.iXDrag;
                if (n2 < 0) {
                    n2 = 0;
                }
                ((Column)Grid.this.vColumns.elementAt((int)Grid.this.iColDrag)).iWidth = n2;
                Grid.this.adjustScroll();
                Grid.this.updateGrid();
            }
        }

        GridMouseListener() {
            Grid.this.getClass();
            this.bDrag = false;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.getCol(n);
            int n4 = Grid.this.iFirstRow + n2 / Grid.this.iRowHeight - 1;
            boolean bl = false;
            this.bDrag = false;
            if (n2 <= Grid.this.iRowHeight) {
                int n5 = n;
                n = n + Grid.this.iX - Grid.this.iGridWidth - Grid.this.iRowHeadWidth - Grid.this.iRowCheckedWidth;
                int n6 = Grid.this.vColumns.size() - 1;
                while (n6 >= 0) {
                    if (n > -7 && n < 7) break;
                    if (((Column)Grid.this.vColumns.elementAt((int)n6)).bVisible) {
                        n += ((Column)Grid.this.vColumns.elementAt((int)n6)).iWidth;
                    }
                    --n6;
                }
                if (n6 >= 0) {
                    Grid.this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    Grid.this.iXDrag = n5 - ((Column)Grid.this.vColumns.elementAt((int)n6)).iWidth;
                    Grid.this.iColDrag = n6;
                    bl = true;
                }
            } else if (n3 > -1 && (((Column)Grid.this.vColumns.elementAt((int)n3)).iType == 5 || ((Column)Grid.this.vColumns.elementAt((int)n3)).iType == 4)) {
                Grid.this.setCursor(new Cursor(12));
                bl = true;
            }
            if (n3 == -1 && Grid.this.iOverBasketRow != n4 && n4 < Grid.this.vCurrentData.size()) {
                Grid.this.bOverBasketColumn = true;
                Grid.this.iOverBasketRow = n4;
                if (((Row)Grid.this.vCurrentData.elementAt((int)n4)).bChecked) {
                    Grid.this.setToolTip(Grid.this.properties.getProperty("ALIAS_REMOVE_ITEM_FROM_BASKER", "Remove item from basket"));
                } else {
                    Grid.this.setToolTip(Grid.this.properties.getProperty("ALIAS_ADD_ITEM_TO_BASKET", "Add item to basket"));
                }
            } else if (Grid.this.bOverBasketColumn && (n3 != -1 || n4 >= Grid.this.vCurrentData.size())) {
                Grid.this.iOverBasketRow = -1;
                Grid.this.bOverBasketColumn = false;
                Grid.this.setToolTip("");
            }
            if (!bl) {
                Grid.this.setCursor(new Cursor(0));
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Grid.this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
    }

    public class GridKeyListener
    extends KeyAdapter
    implements KeyListener {
        public GridKeyListener() {
            Grid.this.getClass();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            int n2 = Grid.this.iCurrentRow;
            int n3 = Grid.this.iCurrentColumn;
            if (n2 < 0 || n2 >= Grid.this.vCurrentData.size()) {
                return;
            }
            switch (n) {
                case 9: {
                    n3 = (keyEvent.getModifiers() & 1) != 0 ? --n3 : ++n3;
                    Grid.this.select(n2, n3);
                    return;
                }
                case 39: {
                    Grid.this.select(n2, ++n3);
                    return;
                }
                case 37: {
                    Grid.this.select(n2, --n3);
                    return;
                }
                case 38: {
                    Grid.this.select(n2 - 1, n3);
                    return;
                }
                case 33: {
                    Grid.this.select(n2 - (Grid.this.iGridHeight / Grid.this.iRowHeight - 1), n3);
                    return;
                }
                case 10: 
                case 40: {
                    Grid.this.select(n2 + 1, n3);
                    return;
                }
                case 34: {
                    Grid.this.select(n2 + (Grid.this.iGridHeight / Grid.this.iRowHeight - 1), n3);
                    return;
                }
                case 36: {
                    Grid.this.select(0, n3);
                    return;
                }
                case 35: {
                    Grid.this.select(Grid.this.vCurrentData.size() - 1, n3);
                    return;
                }
                case 27: {
                    Grid.this.iCurrentRow = -1;
                    Grid.this.select(n2, n3);
                    Grid.this.updateGrid();
                    return;
                }
            }
        }
    }
}

