/*
 * Decompiled with CFR 0.152.
 */
package JDatePickerBean;

import JDatePickerBean.JDatePicker;
import JDatePickerBean.JDatePickerException;
import JDatePickerBean.JDatePickerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;

public class DateEditor
extends PropertyEditorSupport
implements JDatePickerListener {
    private JDatePicker dp;
    private JDatePicker dpmin;
    private JDatePicker dpmax;
    private boolean flag = false;
    private Panel p = new Panel();

    public DateEditor() {
        this.dp = new JDatePicker();
        this.dp.setEditableYearVisible(false);
        this.dp.setCalendar_Modal(true);
        this.dpmin = new JDatePicker();
        this.dpmin.setEditableYearVisible(false);
        this.dpmin.setCalendar_Modal(true);
        this.dpmax = new JDatePicker();
        this.dpmax.setEditableYearVisible(false);
        this.dpmax.setCalendar_Modal(true);
        this.p.setLayout(new GridLayout(3, 3, 15, 15));
        this.p.add(new Label("Select Date : "));
        this.dp.setCalendarTitle("Select Date");
        this.p.add(this.dp);
        this.p.add(new Label("Select MinDate : "));
        this.dpmin.setCalendarTitle("Select MinDate");
        this.dpmin.setCalendarBackground(Color.orange);
        this.dpmin.setBackground(Color.orange);
        this.p.add(this.dpmin);
        this.p.add(new Label("Select MaxDate : "));
        this.dpmax.setCalendarTitle("Select MaxDate");
        this.dpmax.setBackground(Color.yellow);
        this.dpmax.setCalendarBackground(Color.yellow);
        this.p.add(this.dpmax);
        this.dp.addJDatePickerListener(this);
        this.dpmin.addJDatePickerListener(this);
        this.dpmax.addJDatePickerListener(this);
    }

    public void dateChanged(JDatePicker jDatePicker) {
        this.flag = true;
        try {
            if (jDatePicker == this.dpmin) {
                this.dp.setMinDate(this.dpmin.getDate());
                this.dpmax.setMinDate(this.dp.getMinDate());
            } else if (jDatePicker == this.dpmax) {
                this.dp.setMaxDate(this.dpmax.getDate());
                this.dpmin.setMaxDate(this.dp.getMaxDate());
            }
        }
        catch (JDatePickerException jDatePickerException) {}
        this.firePropertyChange();
    }

    public Component getCustomEditor() {
        return this.p;
    }

    public String getJavaInitializationString() {
        String string = this.dp.getYear() + "," + this.dp.getMonth() + "," + this.dp.getDay();
        string = String.valueOf(string) + "," + this.dpmin.getYear() + "," + this.dpmin.getMonth() + "," + this.dpmin.getDay();
        string = String.valueOf(string) + "," + this.dpmax.getYear() + "," + this.dpmax.getMonth() + "," + this.dpmax.getDay();
        return string;
    }

    public Object getValue() {
        return this.dp;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.translate(rectangle.x, rectangle.y);
        graphics.drawString(this.dp.getFormattedDate(this.dp.getDate(), this.dp.getDateFormat()), 2, 14);
    }

    public void setValue(Object object) {
        if (this.flag) {
            return;
        }
        this.dp.removeJDatePickerListener(this);
        this.dpmin.removeJDatePickerListener(this);
        this.dpmax.removeJDatePickerListener(this);
        try {
            JDatePicker jDatePicker = (JDatePicker)object;
            jDatePicker.addJDatePickerListener(new JDatePickerListener(){

                public void dateChanged(JDatePicker jDatePicker) {
                    try {
                        DateEditor.this.dp.setDate(jDatePicker.getDate());
                    }
                    catch (JDatePickerException jDatePickerException) {}
                }
            });
            this.dp.setDate(jDatePicker.getDate());
            this.dp.setMinDate(jDatePicker.getMinDate());
            this.dp.setMaxDate(jDatePicker.getMaxDate());
            this.dpmin.setMinDate(this.dp.getYear() - 200, 1, 1);
            this.dpmin.setDate(jDatePicker.getMinDate());
            this.dpmin.setMaxDate(jDatePicker.getMaxDate());
            this.dpmax.setDate(jDatePicker.getMaxDate());
            this.dpmax.setMinDate(jDatePicker.getMinDate());
            this.dpmax.setMaxDate(this.dp.getYear() + 200, 12, 31);
        }
        catch (JDatePickerException jDatePickerException) {}
        this.dp.addJDatePickerListener(this);
        this.dpmin.addJDatePickerListener(this);
        this.dpmax.addJDatePickerListener(this);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

