package com.kur.ide;

// import java.lang.*;   /* java.lang packages are implicitly imported */
import java.io.*;
import java.awt.*;
import java.awt.event.*;
// import java.util.Vector;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;

/** A class representing the dialog that allows the invocation of user provided functions.
  * This class is currently an empty template. It must be modified by the user.
  * The source code of this template is provided by JadeIDE.
  * <br>
  * @author   Wolfgang Kurz and ___________________  last change: Freitag, 19. Juli 2002 8.56 Uhr CEST
  * @version  template: 3.1    modification x.x
  */
public class UserExit extends JDialog implements WindowListener, ActionListener, MouseListener, FocusListener, ItemListener, ComponentListener
{  /* start of class definition */

//*************************************
//*  Class variables                  *
//*************************************

// the initial dimension of the dialog window
    private static  Dimension    dialogDimension = new Dimension(350,230);
// the copyright constant
    private static  String       theCopyright=" your copyright string with year";
    private static  String       theGenerator="Generated with JadeIDE  Wolfgang Kurz, 2002";
// all colours used within the window
    public  static  Color        colorDARKBLUE   = Control.colorDARKBLUE;
    public  static  Color        colorLIGHTGREY  = Control.colorLIGHTGREY;
    public  static  Color        colorBLACK      = Control.colorBLACK;
    public  static  Color        colorWHITE      = Control.colorWHITE;
    public  static  Color        colorDARKGREY   = Control.colorDARKGREY;
    public  static  Color        colorRED        = Control.colorRED;
// all fonts used within the window
    public  static  Font         textFont        = Control.textFont;
    public  static  Font         dialogFont      = Control.swingDialogFont;
    public  static  Font         buttonFont      = Control.swingButtonFont;

    public  static  String       blQuit = "Quit";
    public  static  String       blHelp = "Help";

//*************************************
//*  Instance variables               *
//*************************************

/* Definition of Labels and Input fields */
/*---------------------------------------*/

    private JLabel               lb00 = new JLabel(" English (englisch): ");
    private JLabel               lb01 = new JLabel(" Invocation of user defined functions. ");
    private JLabel               lb02 = new JLabel(" Modify this dialog to invoke your functions.");
    private JLabel               lb03 = new JLabel(" Deutsch (German): ");
    private JLabel               lb04 = new JLabel(" Aufruf benutzerdefinierter Funktionen. ");
    private JLabel               lb05 = new JLabel(" Modifizieren Sie diesen Dialog um Ihre Funktionen aufzurufen.");
    private JLabel               lb06 = new JLabel(" ");

    private JTextField           tfMessages      = new JTextField(72);

    // Project and SourceFile at the moment of the invocation
    //--------------------------------------------------------
    private String               activeFile      = Control.theControl.getActFile();   // The name of the currently active file
    private String               activePDir      = Control.theControl.buildDirSpec(); // The name of the package directory

    // System properties
    //------------------
    private String               userDir         = Control.userDir;      // user directory
    private String               userHome        = Control.userHome;     // user home directory
    private String               sysClassPath    = Control.sysClassPath; // system class path
    private String               pathSep         = Control.pathSep;      // actual path separator
    private String               fileSep         = Control.fileSep;      // actual file separator
    private String               lineSep         = Control.lineSep;      // actual line separator
    private String               osName          = Control.osName;       // actual operating system name
    private char                 fS              = Control.fS;           // actual file separator as char

/* Definition of Action Buttons  */
/*-------------------------------*/

    private JButton              aButton;
    private JButton              btQuit;
    private JButton              btHelp;

/* Definition of Element Containers  */
/*-----------------------------------*/

/** container to align the action buttons of the frame */
    private JPanel               buttonContainer;

/* Other Definitions     */
/*-----------------------*/

// all borders used within the window
    private Border       buttonBorderRaised  = Control.buttonBorderRaised;
    private Border       buttonBorderLowered = Control.buttonBorderLowered;
    private Border       fieldBorder         = Control.fieldBorder;

/** the layout manager for the window */
    private GridBagLayout      gb           = new GridBagLayout();
/** controls the element positioning */
    private GridBagConstraints gbc;
/** defines the borders around the component top, left, bottom, right */
    private Insets             borders   = new Insets(3,5,3,5);
/** defines the borders around the container top, left, bottom, right */
    private Insets             noborders = new Insets(3,0,3,0);
/** location on screen of the owner of the window */
    private Point              ownerLoc;
/** location of the window on screen */
    private Point              windowLoc;
/** owner component of window */
    private Container          winOwner;
/** Buffer for message texts */
    private StringBuffer       msgTxt;

//*************************************
//*  Class constructor                *
//*************************************
/** Defines the position of the components inside the window frame
  * and initializes the displayed fields
  * <br>
  * @param    title      the title of the Frame
  * @param    mode       type of frame (true = modal or false = not modal)
  * @param    parentLoc  location of the parent component
  */
   public UserExit(final String title,final boolean mode,final Point parentLoc) // do not change this line !!!!
   {  /* start of constructor */
      this.setModal(mode);        // provided mode is true. you can use false, but be carefull !!
      this.setTitle(title);       // to set your own titel replace variable titel with a literal !
      winOwner   = this.getParent();
      ownerLoc   = parentLoc;
      windowLoc  = new Point((ownerLoc.x+40), (ownerLoc.y+65));
      addWindowListener(this);
      addFocusListener(this);
      addComponentListener(this);
      this.setFont(dialogFont);
      this.setForeground(colorDARKBLUE);
      this.setBackground(colorLIGHTGREY);

      this.getContentPane().setLayout(gb);

      tfMessages.setFont(textFont);
      tfMessages.setForeground(colorRED);
      tfMessages.setEditable(false);
      tfMessages.setText(" currently no user function provided ");
      tfMessages.setBorder(fieldBorder);

      buttonContainer = new JPanel();
      buttonContainer.setLayout(new GridLayout(1,2,6,2));

      btQuit  = new JButton(blQuit);        // Quit / Exit button
      btQuit.setFont(buttonFont);
      btQuit.setForeground(colorWHITE);
      btQuit.setBackground(colorDARKGREY);
      btQuit.setBorder(buttonBorderRaised);
      btQuit.addMouseListener(this);
      btQuit.addActionListener(this);

      btHelp  = new JButton(blHelp);        // Quit / Exit button
      btHelp.setFont(buttonFont);
      btHelp.setForeground(colorWHITE);
      btHelp.setBackground(colorDARKGREY);
      btHelp.setBorder(buttonBorderRaised);
      btHelp.addMouseListener(this);
      btHelp.addActionListener(this);

      buttonContainer.add(btHelp);
      buttonContainer.add(btQuit);

// Row Number 0
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 0;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 5;
      this.getContentPane().add(tfMessages,gbc);

// Row Number 1
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 2;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.SOUTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb00,gbc);

// Row Number 2
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 3;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb01,gbc);

// Row Number 3
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 4;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb02,gbc);

// Row Number 4
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 5;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.SOUTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb03,gbc);

// Row Number 5
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 6;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb04,gbc);

// Row Number 6
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 7;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb05,gbc);

// Row Number 7
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 8;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.WEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(lb06,gbc);

// Row Number 8
//
      gbc            = new GridBagConstraints();
      gbc.fill       = GridBagConstraints.HORIZONTAL;
      gbc.insets     = borders;
      gbc.gridx      = 0;
      gbc.gridy      = 9;
      gbc.gridwidth  = GridBagConstraints.REMAINDER;
      gbc.gridheight = 1;
      gbc.anchor     = GridBagConstraints.NORTHWEST;
      gbc.weightx    = 1;
      gbc.weighty    = 1;
      this.getContentPane().add(buttonContainer,gbc);

// end of rows

      this.msgTxt = new StringBuffer(120);
      this.msgTxt.append("");
      this.pack();
      this.setResizable(true);
      this.setSize(dialogDimension);
      this.setLocation(windowLoc);

   }  /* end of constructor */

//   protected void finalize()
//   {  /* start of method */
//      // insert here your code for the finalize method
//   }  /* end of method */

//*************************************
//*  Class methods                    *
//*************************************

   // Static Getters
   //================
      // insert your static getters here

   // Static Setters
   //================
      // insert your static setters here

//*************************************
//*  Instance methods                 *
//*************************************
/** Event handler with default functionality */
   public void windowActivated(final WindowEvent e) { }
   public void windowDeactivated(final WindowEvent e) { }
   public void windowDeiconified(final WindowEvent e) { }
   public void windowClosed(final WindowEvent e) { }

/** Event handler with specific functionality */
   public void windowClosing(final WindowEvent e)
   { /* start of method */
      Window originator = e.getWindow();
      if (originator.equals(this))
      {  /* 001 start if */
         this.handleExit();
      }  else {
         // no operation
      }  /* 001 endif */
   } /* end of windowClosing method */

/** Event handler with default functionality */
   public void mouseClicked(final MouseEvent e) {}
/** Event handler with default functionality */
   public void mouseEntered(final MouseEvent e) {}
/** Event handler with specific functionality */
   public void mouseExited(final MouseEvent e)
   {  /* start method */
      aButton = (JButton) e.getComponent();
      aButton.setBorder(buttonBorderRaised);
   }  /* end method */
/** Event handler with specific functionality */
   public void mousePressed(final MouseEvent e)
   {  /* start method */
      aButton = (JButton) e.getComponent();
      aButton.setBorder(buttonBorderLowered);
   }  /* end method */
/** Event handler with specific functionality */
   public void mouseReleased(final MouseEvent e)
   {  /* start method */
      aButton = (JButton) e.getComponent();
      aButton.setBorder(buttonBorderRaised);
   }  /* end method */

/** Event handler with default functionality */
   public void windowIconified(final WindowEvent e) { }
   public void windowOpened(final WindowEvent e) { }
   public void focusGained(final FocusEvent e) { }
   public void focusLost(final FocusEvent e) { }
   public void componentMoved(final ComponentEvent e) { }
   public void componentShown(final ComponentEvent e) { }
   public void componentHidden(final ComponentEvent e) { }
   public void componentResized(final ComponentEvent e) { }
   public void itemStateChanged(final ItemEvent e) { }

/** Event handler for pushbutton events */
   public void actionPerformed(final ActionEvent event)
   {  /* start of method */
      boolean           oneActionPerformed = false;
      String            actionCommand = event.getActionCommand();
      System.gc();      // force garbage collection
      tfMessages.setText(msgTxt.toString());

      if (actionCommand.equals(blHelp))    // HELP Button
      {  /* 001 start if */
         oneActionPerformed = true;
         Control.theControl.invokeBrowser("HELP","userExit");
      }  /* 001 endif */

      if (actionCommand.equals(blQuit))
      {  /* 001 */
         oneActionPerformed = true;
         this.handleExit();
      }  /* 001 endif */

      if (oneActionPerformed == false)
      {  /* 001 start if */
         // handle here what to do if (by whatever reason)
         // an invalid selection happened
      }  /* 001 endif */

   }  /* end of method */

   // Getter methods
   //================
      // insert here your getter methods

   // Setter methods
   //================
      // insert here your setter methods

   // Processing methods
   //====================

/** Handles activities when closing the window */
   public void handleExit()
   {  /* start of method */
      Control.theControl.theUserExit = null;
      this.dispose();
   }  /* end method */

}  /* end of class definition */
