package com.tolstoy.imagemeister;

import java.awt.*;

/**
Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class AboutBoxButtonPanel extends Panel {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	public void paint( Graphics g ) {
		Dimension		d;

		d = size();
		g.setColor( Color.lightGray );
		g.fillRect( 0, 0, d.width, d.height );

		super.paint( g );
	}
}

/**
Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class AboutBox extends Dialog {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	Panel		down;
	AboutPanel	up;
	Button		okButton;
	WindowOwner	owner;
	boolean		bGray;

	private static final String		kIcon = "imagmstr.gif";

	public AboutBox( VisitURLRecipient vr, WindowOwner onr, String imageBase, Frame parent, boolean bgray ) {
		super( parent, "About ImageMeister", true );
		owner = onr;
		bGray = bgray;
		setResizable( false );
		setLayout( new BorderLayout( 0, 0 ) );

		up = new AboutPanel( vr, imageBase + kIcon, imageBase + "urlu.gif", imageBase + "urld.gif", bGray );
		add( "Center", up );

		okButton = new Button( "OK" );

		if ( bGray )
			down = new AboutBoxButtonPanel();
		else
			down = new Panel();

		down.setLayout( new FlowLayout( FlowLayout.CENTER, 5, 5 ) );
		down.add( okButton );
		okButton.resize( 80, 20 );

		add( "South", down );
		pack();

		move( 300, 100 );
	}

	public boolean handleEvent( Event ev ) {
		if ( ev.id == Event.WINDOW_DESTROY ) {
			owner.closeWindow( this );
			return true;
		}
		else if ( ev.target == okButton && ev.id == Event.ACTION_EVENT ) {
			owner.closeWindow( this );
			return true;
		}
		else
			return false;
	}

	public boolean gotFocus( Event e, Object arg ) {
		okButton.requestFocus();
		return true;
	}
}

/**
Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class AboutPanel extends Panel {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

	private boolean					bGray;
	private Image					iconImage;
	private VisitURLRecipient		visitRecipient;
	private ImageButton				urlBtn, iconBtn;

	private static final int kPanelW = 300;
	private static final int kPanelH = 200;

	private static final int kLeft = 20;

	private static final int kIconX = 10;
	private static final int kIconY = 10;
	private static final int kIconWidth = 32;
	private static final int kIconHeight = 32;

	private static final int kURLButtonW = 136;
	private static final int kURLButtonH = 20;
	private static final int kURLButtonX = ( kPanelW - kURLButtonW ) / 2;
	private static final int kURLButtonY = 100;

	private static final int		kImageMeisterY = 20;
	private static final int		kBySamizdatProductionsY = 40;
	private static final int		kVisitUsY = kIconY + kIconHeight + 40;
	private static final int		kCopyrightY = kVisitUsY + 70;
	private static final int		kReservedY = kCopyrightY + 15;
	private static final int		kTrademark1Y = kReservedY + 15;
	private static final int		kTrademark2Y = kTrademark1Y + 15;

	private static final String kLines[] = {
		"ImageMeister",
		"by Samizdat Productions",
		"Visit us on the Web at",
		"(c) 1998-2002 Samizdat Productions",
		"All Rights Reserved.",
		"ImageMeister is a Trademark",
		"of Samizdat Productions."
	};

	public AboutPanel( VisitURLRecipient vr, String imageFile, String urlFileU, String urlFileD, boolean bgray ) {
		visitRecipient = vr;
		iconImage = Toolkit.getDefaultToolkit().getImage( imageFile );
		bGray = bgray;

		setLayout( null );

		iconBtn = new ImageButton( imageFile, imageFile, kIconWidth, kIconHeight );
		add( iconBtn );
		iconBtn.reshape( kIconX, kIconY, kIconWidth, kIconHeight );

		urlBtn = new ImageButton( urlFileU, urlFileD, kURLButtonW, kURLButtonH );
		add( urlBtn );
		urlBtn.reshape( kURLButtonX, kURLButtonY, kURLButtonW, kURLButtonH );
	}

	public boolean handleEvent( Event e ) {
		if ( e.id == Event.ACTION_EVENT ) {
			if ( e.target == urlBtn ) {
				visitRecipient.visitURLButtonClicked();
				return true;
			}
		}
		
		return super.handleEvent( e );
	}

	public Dimension preferredSize() {
		return new Dimension( kPanelW, kPanelH );
	}

	public void paint( Graphics g ) {
		Graphics		iconG;
		Dimension		d;
		int				i, y, width;

		if ( bGray ) {
			d = size();
			g.setColor( Color.lightGray );
			g.fillRect( 0, 0, d.width, d.height );
		}

//		if ( iconImage != null )
//			g.drawImage( iconImage, kIconX, kIconY, this );


		g.setColor( Color.black );
		g.setFont( new Font( "ARIAL", 1, 16 ) );

		g.drawString( kLines[ 0 ], kIconX + kIconWidth + 10, kImageMeisterY );
		g.drawString( kLines[ 1 ], kIconX + kIconWidth + 10, kBySamizdatProductionsY );


		g.setFont( new Font( "ARIAL", 0, 14 ) );

		width = ( g.getFontMetrics() ).stringWidth( kLines[ 2 ] );
		g.drawString( kLines[ 2 ], ( kPanelW - width ) / 2, kVisitUsY );


		g.setFont( new Font( "ARIAL", 0, 12 ) );

		width = ( g.getFontMetrics() ).stringWidth( kLines[ 3 ] );
		g.drawString( kLines[ 3 ], ( kPanelW - width ) / 2, kCopyrightY );

		width = ( g.getFontMetrics() ).stringWidth( kLines[ 4 ] );
		g.drawString( kLines[ 4 ], ( kPanelW - width ) / 2, kReservedY );

		width = ( g.getFontMetrics() ).stringWidth( kLines[ 5 ] );
		g.drawString( kLines[ 5 ], ( kPanelW - width ) / 2, kTrademark1Y );

		width = ( g.getFontMetrics() ).stringWidth( kLines[ 6 ] );
		g.drawString( kLines[ 6 ], ( kPanelW - width ) / 2, kTrademark2Y );
	}
}


