package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
Interface for objects which display files. For a given plugin, objects which implement this
interface will be returned from the plugin's createImageViewer() method.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public interface ImageViewerI {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Returns the FileSpecifier which specifies the file shown by this viewer.
*/

	FileSpecifier getFileSpecifier();

/*
Sets the FileSpecifier which specifies the file shown by this viewer.

	boolean setFileSpecifier( FileSpecifier fs );
*/

/**
Returns the OwnedFrame containing this viewer.
*/

	OwnedFrame getFrame();

/**
Show or hide this viewer.
@param bState if false, hide; if true, show
*/

	void setVisible( boolean bState );
}

/*
Returns the DiskObject shown by this viewer. May return null if this viewer was not created
using a DiskObject, but was created using a java.io.File instead.

	DiskObject getDiskObject();

Set the DiskObject shown by this viewer. The viewer should refresh its display.

	void setDiskObject( DiskObject dob );

Returns the java.io.File shown by this viewer. May return null if this viewer was not created
using a File, but was created using a DiskObject instead.

	File getJFile();

Set the java.io.File shown by this viewer. The viewer should refresh its display.

	void setJFile( File fl );

*/
