package com.tolstoy.imagemeister;

import java.awt.Window;

/**
Interface supported by objects which own objects implementing the ImageViewerI interface. For a
given plugin, an object implementing this interface is passed to the plugin's createImageViewer()
method.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public interface ImageViewerOwner {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Tells the owner of an ImageViewerI to close the image viewer. For instance, the image viewer
should call this method when the user clicks in the image viewer's close box. The owner will
then dispose of the image viewer.
*/

	void closeImageViewer( ImageViewerI w );
}

