package com.tolstoy.imagemeister;

import java.awt.*;
import java.awt.image.*;
import java.io.File;
import java.io.PrintStream;
import java.util.Date;
import com.jconfig.*;

/**
Displays information on a folder.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

class SInfoVFolder extends SInfoViewer {
	DiskFile		file;

	public SInfoVFolder( DiskFile df, OwnedFrame oldFrame, InfoViewerOwner onr,
							FileSpecifier spec, Rectangle rect ) {
		super( oldFrame, onr, spec, rect );
		file = df;
	}

	void showInformation( Graphics g, int x, int y ) {
		VersionInfo			versionInfo;
		File				jFile;
		String				s1, s2, s3, s4, dateString;
		int					theErr, flags;
		
		flags = file.getFlags();
		versionInfo = file.getVersion();
		jFile = file.getFile();
		dateString = getDateString( file );

		s1 = "FOLDER ";

		s1 += "@" + Integer.toHexString( file.hashCode() ) + ": " +  file.getName();

		s2 = "flags=" + file.diskFileFlagsToString( flags ) +
				" ( 0x" + Integer.toHexString( flags ) + " )" +
				", dates=" + dateString;
	
		if ( versionInfo == null )
			s2 += ", no version info";
		else
			s2 += ", version string: " + versionInfo.getVersionString();

		if ( jFile == null )
			s3 = "java.io.File is null";
		else
			s3 = "java.io.File=" + jFile.getPath();

		if ( !jFile.exists() )
			s3 += "** java.io.File.exists() == false **";

		s4 = "FinderInfo: " + getFinderInfoString( file ) +
				", color coding=" + file.getColorCoding() +
				", file size=" + file.getFileSize() +
				", res fork size=" + file.getResourceForkSize();
		
		g.setColor( Color.red );
		g.drawString( s1, x, y );
		g.drawString( s2, x, y + 15 );
		g.drawString( s3, x, y + 30 );
		g.drawString( s4, x, y + 45 );
	}

	private String getDateString( DiskFile df ) {
		try {
			return df.getDateBundle().toString();
		}
		catch ( UnimplementedException ue ) {
			return "getDateBundle not implemented";
		}
		catch ( Exception e ) {
			return e.toString();
		}
	}

	private String getFinderInfoString( DiskFile df ) {
		try {
			return df.getFinderInfo().toString();
		}
		catch ( UnimplementedException ue ) {
			return "FinderInfo not implemented";
		}
		catch ( Exception e ) {
			return e.toString();
		}
	}
}
