/*
 * Decompiled with CFR 0.152.
 */
package jdbees.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import jdbees.JBeesConfInfo;
import jdbees.JBeesNetworkIO;
import jdbees.http.TooManyRedirectionException;
import jdbees.security.JBeesBase64;

public class JBeesHttpRemoteInfo {
    private boolean debug = false;
    private long remoteFileLength = 0L;
    private boolean supportRange = false;
    private String lastModifiedDate;
    private String cookieStr;
    private JBeesNetworkIO jnio;
    private PrintWriter pw;
    private BufferedReader br;
    private URL url;
    private boolean success = false;
    private String reason;
    private int respCode;
    private int rdCount = 0;
    private boolean isRedirection = false;
    private boolean viaProxy;
    private boolean isChunked;
    private boolean htmlTxt;
    private String proxyHost;
    private int proxyPort;
    private int timeout;
    private String proxyUser;
    private String proxyPasswd;
    private String user;
    private String passwd;

    public JBeesHttpRemoteInfo(URL url, int timeout, String user, String passwd) throws IOException, TooManyRedirectionException {
        this.url = url;
        this.viaProxy = false;
        this.timeout = timeout;
        this.user = user;
        this.passwd = passwd;
        this.getStreams();
        this.getInfo();
    }

    public JBeesHttpRemoteInfo(URL url, String proxyHost, int proxyPort, int timeout, String user, String passwd) throws IOException, TooManyRedirectionException {
        this.url = url;
        this.viaProxy = true;
        this.timeout = timeout;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.user = user;
        this.passwd = passwd;
        this.getStreams();
        this.getInfo();
    }

    public JBeesHttpRemoteInfo(URL url, JBeesConfInfo jbconf) throws IOException, TooManyRedirectionException {
        this.getRemoteInfo(url, jbconf);
    }

    public JBeesHttpRemoteInfo(URL url, String user, String passwd, JBeesConfInfo jbconf) throws IOException, TooManyRedirectionException {
        this.user = user;
        this.passwd = passwd;
        this.getRemoteInfo(url, jbconf);
    }

    private void getRemoteInfo(URL url, JBeesConfInfo jbconf) throws IOException, TooManyRedirectionException {
        if (this.debug) {
            System.out.println("JBeesHttpRemoteInfo");
        }
        this.url = url;
        if (jbconf.getProxyHost() != null) {
            this.viaProxy = true;
            this.proxyHost = jbconf.getProxyHost();
            this.proxyPort = jbconf.getProxyPort();
        }
        if (jbconf.getHttpAuthUser() != null) {
            this.proxyUser = jbconf.getHttpAuthUser();
            this.proxyPasswd = jbconf.getHttpAuthPasswd();
        }
        this.timeout = jbconf.getSocketTimeout();
        this.getStreams();
        this.getInfo();
    }

    private void getStreams() throws IOException {
        this.jnio = this.viaProxy ? new JBeesNetworkIO(this.proxyHost, this.proxyPort) : new JBeesNetworkIO(this.url);
        if (this.timeout > 0) {
            this.jnio.setTimeout(this.timeout);
        }
        this.pw = this.jnio.getPrintWriter();
        this.br = this.jnio.getBufferedReader();
    }

    public long getRemoteFileLength() {
        return this.remoteFileLength;
    }

    public boolean isHtmlTxt() {
        return this.htmlTxt;
    }

    public boolean isSupportRange() {
        return this.supportRange;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getCookieStr() {
        return this.cookieStr;
    }

    public String getReason() {
        return this.reason;
    }

    public int getRespCode() {
        return this.respCode;
    }

    public boolean getChunked() {
        return this.isChunked;
    }

    public URL getURL() {
        return this.url;
    }

    private void getInfo() throws IOException, TooManyRedirectionException {
        this.sendHeadRequest();
        this.recvHeadResponse();
        if (this.isRedirection) {
            ++this.rdCount;
            if (this.rdCount > 5) {
                throw new TooManyRedirectionException();
            }
            this.getStreams();
            this.isRedirection = false;
            this.getInfo();
        }
    }

    private void sendHeadRequest() throws IOException {
        String enc;
        JBeesBase64 jb64;
        String headRequest = "GET " + this.url.toString() + " HTTP/1.1";
        String host = "Host: " + this.url.getHost();
        String rangeRequest = "Range: bytes=0-0";
        String connectionRequest = "Connection: close";
        String refererRequest = "Referer: http://" + this.url.getHost() + (this.url.getPort() != -1 ? ":" + this.url.getPort() : "");
        String acceptRequest = "Accept: */*";
        String useragent = "User-Agent: JBees/1.0";
        String authRequest = null;
        String proxyAuthRequest = null;
        if (this.user != null) {
            jb64 = new JBeesBase64();
            enc = new String(jb64.encode((String.valueOf(this.user) + ":" + this.passwd).getBytes()));
            authRequest = "Authorization: Basic " + enc;
        }
        if (this.proxyUser != null) {
            jb64 = new JBeesBase64();
            enc = new String(jb64.encode((String.valueOf(this.proxyUser) + ":" + this.proxyPasswd).getBytes()));
            proxyAuthRequest = "Proxy-Authorization: Basic " + enc;
        }
        if (this.debug) {
            System.out.println(headRequest);
            System.out.println(host);
            System.out.println(rangeRequest);
            System.out.println(connectionRequest);
            System.out.println(refererRequest);
            System.out.println(acceptRequest);
            System.out.println(useragent);
            System.out.println(authRequest);
            System.out.println(proxyAuthRequest);
        }
        this.pw.println(headRequest);
        this.pw.println(host);
        this.pw.println(rangeRequest);
        this.pw.println(connectionRequest);
        this.pw.println(refererRequest);
        this.pw.println(acceptRequest);
        if (authRequest != null) {
            this.pw.println(authRequest);
        }
        if (proxyAuthRequest != null && this.viaProxy) {
            this.pw.println(proxyAuthRequest);
        }
        this.pw.println(useragent);
        this.pw.println();
        this.pw.println();
        this.pw.flush();
    }

    private void recvHeadResponse() throws IOException {
        this.readStatus();
        if (this.success) {
            if (this.respCode < 300) {
                this.succHeadResponse();
            } else {
                this.redirHeadResponse();
            }
        }
    }

    private void redirHeadResponse() throws IOException {
        block9: {
            if (this.respCode >= 200) {
                String str;
                do {
                    str = this.br.readLine();
                    if (this.debug) {
                        System.out.println(str);
                    }
                    if (str.length() == 0) break block9;
                } while (str.trim().toLowerCase().indexOf("content-location:") != -1 || str.trim().toLowerCase().indexOf("location:") == -1);
                int index = str.indexOf(":");
                try {
                    String str1 = str.substring(index + 2).trim();
                    if (this.debug) {
                        System.out.println("Befor String str1 = " + str1);
                    }
                    if (str1.indexOf("http") > 0) {
                        String str2 = str1;
                        int index0 = str1.toLowerCase().indexOf("http");
                        if (index0 != -1) {
                            str2 = str1.substring(0, index0);
                            int index2 = str1.toLowerCase().indexOf("http", index0 + 4);
                            str2 = index2 != -1 ? String.valueOf(str2) + str1.substring(index2) : str1;
                        }
                        str1 = this.url.getPort() != -1 ? "http://" + this.url.getHost() + ":" + this.url.getPort() + str2 : "http://" + this.url.getHost() + str2;
                    }
                    if (this.debug) {
                        System.out.println("After String str1 = " + str1);
                    }
                    this.url = new URL(str1);
                }
                catch (Exception exception) {}
            }
        }
        this.pw.close();
        this.br.close();
        this.jnio.close();
    }

    private void succHeadResponse() throws IOException {
        while (true) {
            int beginIndex;
            int index;
            String str = this.br.readLine();
            if (this.debug) {
                System.out.println(str);
            }
            if (str.length() == 0) break;
            if (!this.supportRange) {
                if (str.indexOf("Content-Length:") != -1 || str.indexOf("Content-length:") != -1) {
                    index = str.indexOf(":");
                    this.remoteFileLength = Long.parseLong(str.substring(index + 2));
                }
            } else if (str.indexOf("Content-Range:") != -1 || str.indexOf("Content-range:") != -1) {
                index = str.indexOf("/");
                this.remoteFileLength = Long.parseLong(str.substring(index + 1));
            }
            if (str.toLowerCase().indexOf("chunked") != -1) {
                this.isChunked = true;
                continue;
            }
            if (str.toLowerCase().indexOf("last-modified:") != -1) {
                beginIndex = str.toLowerCase().indexOf(":") + 1;
                this.lastModifiedDate = str.substring(beginIndex).trim().toLowerCase();
                if (!this.debug) continue;
                System.out.println("last modified date " + this.lastModifiedDate);
                continue;
            }
            if (str.toLowerCase().indexOf("set-cookie:") != -1) {
                beginIndex = str.toLowerCase().indexOf(":") + 1;
                this.cookieStr = str.substring(beginIndex).trim().toLowerCase();
                continue;
            }
            if (str.toLowerCase().indexOf("html/text") == -1) continue;
            this.htmlTxt = true;
        }
        this.pw.close();
        this.br.close();
        this.jnio.close();
    }

    private void readStatus() throws IOException {
        String str;
        this.success = false;
        while ((str = this.br.readLine()) == null || str.length() <= 0) {
        }
        if (this.debug) {
            System.out.println(str);
        }
        int index = str.indexOf("HTTP");
        try {
            this.respCode = Integer.parseInt(str.substring(index + 9, index + 12));
        }
        catch (Exception exception) {}
        this.reason = str.substring(index + 12);
        if (this.respCode < 300) {
            if (this.respCode == 206) {
                this.supportRange = true;
            }
            this.success = true;
        } else if (this.respCode >= 300 && this.respCode < 400) {
            this.success = true;
            this.isRedirection = true;
        } else {
            this.success = false;
        }
    }
}

