/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Structure;
import com.jniwrapper.UInt32;
import com.jniwrapper.ZeroTerminatedString;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.VersionInfo;
import com.jniwrapper.win32.gdi.Icon;

class NotifyIconData
extends Structure {
    private UInt32 _cbSize = new UInt32();
    private Pointer.Void _hWnd = new Pointer.Void();
    private UInt32 _uID = new UInt32();
    private UInt32 _uFlags = new UInt32();
    private UInt32 _uCallbackMessage = new UInt32();
    private Icon _hIcon = new Icon();
    private ZeroTerminatedString _szTip;
    private UInt32 _dwState = new UInt32();
    private UInt32 _dwStateMask = new UInt32();
    private ZeroTerminatedString _szInfo;
    private UInt32 _uTimeout = new UInt32();
    private ZeroTerminatedString _szInfoTitle;
    private UInt32 _dwInfoFlags = new UInt32();

    public NotifyIconData(long hwnd, int id) {
        this.initStringParameters();
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin2k() | versionInfo.isWinMe()) {
            this.init(new Parameter[]{this._cbSize, this._hWnd, this._uID, this._uFlags, this._uCallbackMessage, this._hIcon, this._szTip, this._dwState, this._dwStateMask, this._szInfo, this._uTimeout, this._szInfoTitle, this._dwInfoFlags});
        } else {
            this.init(new Parameter[]{this._cbSize, this._hWnd, this._uID, this._uFlags, this._uCallbackMessage, this._hIcon, this._szTip});
        }
        this._cbSize.setValue((long)this.getLength());
        this._hWnd.setValue(hwnd);
        this._uID.setValue((long)id);
    }

    private void initStringParameters() {
        Kernel32 kernel32 = Kernel32.getInstance();
        this._szTip = kernel32.stringParam("", 128);
        this._szInfo = kernel32.stringParam("", 256);
        this._szInfoTitle = kernel32.stringParam("", 64);
    }

    public void setCallbackMessage(int callbackMessage) {
        this._uCallbackMessage.setValue((long)callbackMessage);
    }

    public void setFlags(long flags) {
        this._uFlags.setValue(flags);
    }

    public void setIcon(Icon icon) {
        this._hIcon.setValue(icon.getValue());
    }

    public void setToolTip(String tip) {
        this._szTip.setValue(tip);
    }

    public void setState(long value) {
        this._dwState.setValue(value);
    }

    public void setStateMask(long value) {
        this._dwStateMask.setValue(value);
    }

    public void setInfo(String value) {
        this._szInfo.setValue(value);
    }

    public void setTimeout(long value) {
        this._uTimeout.setValue(value);
    }

    public void setInfoTitle(String value) {
        this._szInfoTitle.setValue(value);
    }

    public void setInfoFlags(long value) {
        this._dwInfoFlags.setValue(value);
    }
}

