/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;
import com.jniwrapper.win32.ui.TrackMouseEvent;

public class User32
extends WinFunctionCache {
    static final FunctionName FUNCTION_GET_MESSAGE = new FunctionName("GetMessage");
    static final String FUNCTION_TRANSLATE_MESSAGE = "TranslateMessage";
    static final FunctionName FUNCTION_DISPATCH_MESSAGE;
    static final String FUNCTION_POST_QUIT_MESSAGE = "PostQuitMessage";
    static final String FUNCTION_CREATE_ELLIPRIC_RGN = "CreateEllipticRgn";
    static final FunctionName FUNCTION_LOAD_IMAGE;
    static final String FUNCTION_TRACK_MOUSE_EVENT = "TrackMouseEvent";
    private static User32 _instance;

    private User32() {
        super("user32");
        this.setUnicode(Kernel32.getInstance().isUnicode());
    }

    public static User32 getInstance() {
        if (_instance == null) {
            _instance = new User32();
        }
        return _instance;
    }

    public static void postQuitMessage(int exitCode) {
        Function function = User32.getInstance().getFunction(FUNCTION_POST_QUIT_MESSAGE);
        function.invoke(null, (Parameter)new Int((long)exitCode));
    }

    public static Handle loadResourceFromFile(String fileName, int resourceType) {
        return User32.loadResourceFromFile(fileName, resourceType, 0, 0);
    }

    public static Handle loadResourceFromFile(String fileName, int resourceType, int width, int height) {
        Function function = User32.getInstance().getFunction(FUNCTION_LOAD_IMAGE.toString());
        Handle result = new Handle();
        function.invoke((Parameter)result, new Parameter[]{new Pointer(null, true), User32.getInstance().stringParam(fileName), new UInt((long)resourceType), new Int((long)width), new Int((long)height), new UInt(32784L)});
        if (result.isNull()) {
            throw new LastErrorException("Failed to load resource.", true);
        }
        return result;
    }

    public static boolean trackMouseEvent(TrackMouseEvent event) {
        Function function = User32.getInstance().getFunction(FUNCTION_TRACK_MOUSE_EVENT);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)event));
        return result.getValue();
    }

    static {
        FUNCTION_TRANSLATE_MESSAGE = FUNCTION_TRANSLATE_MESSAGE;
        FUNCTION_DISPATCH_MESSAGE = new FunctionName("DispatchMessage");
        FUNCTION_POST_QUIT_MESSAGE = FUNCTION_POST_QUIT_MESSAGE;
        FUNCTION_CREATE_ELLIPRIC_RGN = FUNCTION_CREATE_ELLIPRIC_RGN;
        FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
        FUNCTION_TRACK_MOUSE_EVENT = FUNCTION_TRACK_MOUSE_EVENT;
    }
}

