/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DataBuffer;
import com.jniwrapper.Function;
import com.jniwrapper.Library;
import com.jniwrapper.MemoryAccessViolationException;
import com.jniwrapper.Parameter;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.Pointer;
import com.jniwrapper.g;
import com.jniwrapper.u;

public abstract class Callback
extends Parameter {
    private static final String STRING_REPRESENTATION = "Callback function";
    private byte _callingConvention = Function.DEF_CALLING_CONVENTION;
    private Parameter[] _parameters;
    private Parameter _returnValue;
    private long _callbackThunk = 0L;
    private long _resultFlags = 0L;

    protected Callback() {
        super(null, 0);
        Library.ensureNativeCode();
    }

    public Callback(Parameter[] parameterArray, Parameter parameter) {
        this();
        this.init(parameterArray, parameter);
    }

    protected void init(Parameter[] parameterArray, Parameter parameter) {
        this._parameters = parameterArray;
        this._returnValue = parameter;
        if (this._returnValue != null) {
            this._resultFlags = parameter.getResultFlags();
        }
    }

    protected Parameter[] getParameters() {
        return this._parameters;
    }

    protected Parameter getReturnValue() {
        return this._returnValue;
    }

    public abstract void callback();

    private long enterPoint(long l2, int n2) {
        long l3 = 0L;
        g g2 = u.a().a(l2, n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < this._parameters.length) {
            this._parameters[n4].pop(g2, n3, true);
            n3 += PlatformContext.getAlignedParameterLength(this._parameters[n4]);
            ++n4;
        }
        try {
            this.callback();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        n3 = 0;
        int n5 = 0;
        while (n5 < this._parameters.length) {
            this._parameters[n5].push(g2, n3, true);
            n3 += PlatformContext.getAlignedParameterLength(this._parameters[n5]);
            ++n5;
        }
        if (this._returnValue != null) {
            g g3 = u.a().a(this._returnValue.getLength());
            this._returnValue.write(g3, 0, false);
            l3 = g3.if();
        }
        return l3;
    }

    private int getReturnValueLength() {
        if (this._returnValue == null) {
            return 0;
        }
        return this._returnValue.getLength();
    }

    private int getParametersLength() {
        int n2 = 0;
        short s2 = PlatformContext.getParameterAlignment();
        int n3 = 0;
        while (n3 < this._parameters.length) {
            n2 += (this._parameters[n3].getLength() + s2 - 1) / s2 * s2;
            ++n3;
        }
        return n2;
    }

    private native long createNativeFunctionInstance() throws MemoryAccessViolationException;

    private static native void releaseNativeFunctionInstance(long var0);

    public int getLength() {
        return Pointer.POINTER_LENGTH;
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return STRING_REPRESENTATION;
    }

    public void dispose() {
        if (this._callbackThunk != 0L) {
            Callback.releaseNativeFunctionInstance(this._callbackThunk);
        }
    }

    public void write(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
        if (this._callbackThunk == 0L) {
            this._callbackThunk = this.createNativeFunctionInstance();
        }
        dataBuffer.writeCallbackReference(n2, this._callbackThunk);
    }

    public void read(DataBuffer dataBuffer, int n2, boolean bl) throws MemoryAccessViolationException {
    }

    public void setCallingConvention(byte by) {
        this._callingConvention = by == 0 ? Function.DEF_CALLING_CONVENTION : by;
    }

    public byte getCallingConvention() {
        return this._callingConvention;
    }

    static {
        STRING_REPRESENTATION = STRING_REPRESENTATION;
    }
}

