/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Region;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * @author Serge Piletsky
 */
class CustomShapeWindowSample extends LazyPanel implements ActionListener
{
    private JLabel lblAdvisoryText;
    private JButton btnShowWindow;

    private CustomShapeWindow _customShapeWindow;
    private Region _windowShape;

    public CustomShapeWindowSample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page demonstrates a non-rectangular window built based on image region.<br><br><b>NOTE:</b> Use pop-up menu to close the Custom Shape Window");
        btnShowWindow = new JButton("Show Window");

        _customShapeWindow = new CustomShapeWindow(getParentWindow());
        final PopupMenu menu = new PopupMenu();
        menu.add("Close");
        menu.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _customShapeWindow.setVisible(false);
            }
        });
        _customShapeWindow.add(menu);
        _customShapeWindow.addMouseListener(new MouseAdapter()
        {
            public void mouseClicked(MouseEvent e)
            {
                menu.show(_customShapeWindow, e.getX(), e.getY());
            }
        });
        _customShapeWindow.setCursor(Cursor.getPredefinedCursor(Cursor.MOVE_CURSOR));

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        add(btnShowWindow, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                  GridBagConstraints.CENTER, GridBagConstraints.NONE, new Insets(20, 0, 0, 0), 0, 0));

        add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(0, 0, 0, 0), 0, 0));

        btnShowWindow.addActionListener(this);
        super.initialize();
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getSource().equals(btnShowWindow))
        {
            if (_windowShape == null)
            {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("res/cup.gif"));
                _windowShape = Region.createFromImage(imageIcon.getImage(), Color.green);
                _customShapeWindow.setImage(imageIcon);
                _customShapeWindow.setWindowShape(_windowShape);
            }
            _customShapeWindow.setVisible(true);
        }
    }
}


