/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.registry.ui.RegistryKeyValuesTableModel;
import com.jniwrapper.win32.registry.ui.RegistryTreeModel;
import com.jniwrapper.win32.registry.RegistryKey;

import javax.swing.*;
import javax.swing.table.TableColumnModel;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import java.awt.*;

/**
 * @author Serge Piletsky
 */
class RegistryKeySample extends LazyPanel implements TreeSelectionListener
{
    private JLabel lblAdvisoryText;
    private JTree _registry;
    private JTable _registryKeyValues;
    private RegistryKeyValuesTableModel _registryKeyValuesTableModel;
    private RegistryTreeModel _registryTreeModel;

    public RegistryKeySample(Window parent)
    {
        super(parent);
    }

    public void initialize() throws Exception
    {
        lblAdvisoryText = new HTMLText("This page demonstrates simple registry viewer created using the RegistryKey abilities.");
        _registryTreeModel = new RegistryTreeModel();
        _registry = new JTree(_registryTreeModel);
        _registry.setRootVisible(false);
        _registry.addTreeSelectionListener(this);
        BasicTreeUI basicTreeUI = ((BasicTreeUI)_registry.getUI());
        basicTreeUI.setCollapsedIcon(new ImageIcon(this.getClass().getResource("res/Closed.gif")));
        basicTreeUI.setExpandedIcon(new ImageIcon(this.getClass().getResource("res/Opened.gif")));
        _registry.putClientProperty("JTree.lineStyle", "None");
        _registry.setCellRenderer(new TreeCellRenderer());
        _registry.setToggleClickCount(1);

        _registryKeyValuesTableModel = new RegistryKeyValuesTableModel();
        _registryKeyValues = new JTable(_registryKeyValuesTableModel);
        _registryKeyValues.setRowSelectionAllowed(true);
        _registryKeyValues.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        _registryKeyValues.setShowHorizontalLines(false);
        _registryKeyValues.setShowVerticalLines(false);
		final TableColumnModel columnModel = _registryKeyValues.getColumnModel();
		columnModel.getColumn(0).setPreferredWidth(80);
        columnModel.getColumn(1).setPreferredWidth(70);
        columnModel.getColumn(2).setPreferredWidth(110);

        setLayout(new GridBagLayout());

        add(lblAdvisoryText, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0
                , GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL, new Insets(10, 10, 10, 10), 0, 0));

        final JSplitPane splitter = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true);
        splitter.setBorder(null);
        splitter.setDividerSize(2);
        splitter.setDividerLocation(150);

        JScrollPane registry = new JScrollPane(_registry);
        JScrollPane values = new JScrollPane(_registryKeyValues);

        splitter.add(registry, JSplitPane.LEFT);
        splitter.add(values, JSplitPane.RIGHT);

        add(splitter, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0
                , GridBagConstraints.WEST, GridBagConstraints.BOTH, new Insets(10, 10, 10, 10), 0, 0));

        super.initialize();
    }

    public void valueChanged(TreeSelectionEvent e)
    {
        TreePath path = e.getPath();
        RegistryTreeModel.RegistryKeyNode node = (RegistryTreeModel.RegistryKeyNode)path.getPathComponent(path.getPathCount() - 1);
        RegistryKey key = node.getRegistryKey();
        _registryKeyValuesTableModel.setRegistryKey(key);
        _registryKeyValues.updateUI();
    }
}
