/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Parameter;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Structure;

/**
 * This class represents BITMAPINFO structure.
 *
 * @author Serge Piletsky
 */
public class BitmapInfo extends Structure
{
    private BitmapInfoHeader _header = new BitmapInfoHeader();
    private PrimitiveArray _colors;

    public BitmapInfo()
    {
        this(1);
    }

    public BitmapInfo(int colors)
    {
        _colors = new PrimitiveArray(RGBQuad.class, colors);
        init(new Parameter[]{_header, _colors});
    }

    public BitmapInfoHeader getBitmapInfoHeader()
    {
        return _header;
    }

    public PrimitiveArray getColors()
    {
        return _colors;
    }
}
