/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui.dialogs;

import com.jniwrapper.Function;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.WinFunctionCache;

/**
 * This class provides functions from comdlg32 library.
 *
 * @author Serge Piletsky
 */
public class ComDlg32 extends WinFunctionCache
{
    public static final int CDERR_GENERALCODES      = 0x0000;
    public static final int CDERR_STRUCTSIZE        = 0x0001;
    public static final int CDERR_INITIALIZATION    = 0x0002;
    public static final int CDERR_NOTEMPLATE        = 0x0003;
    public static final int CDERR_NOHINSTANCE       = 0x0004;
    public static final int CDERR_LOADSTRFAILURE    = 0x0005;
    public static final int CDERR_FINDRESFAILURE    = 0x0006;
    public static final int CDERR_LOADRESFAILURE    = 0x0007;
    public static final int CDERR_LOCKRESFAILURE    = 0x0008;
    public static final int CDERR_MEMALLOCFAILURE   = 0x0009;
    public static final int CDERR_MEMLOCKFAILURE    = 0x000A;
    public static final int CDERR_NOHOOK            = 0x000B;
    public static final int CDERR_REGISTERMSGFAIL   = 0x000C;

    static final String FUNCTION_COMMON_DLG_EXTENDED_ERROR = "CommDlgExtendedError";

    private static ComDlg32 _instance;

    public static ComDlg32 getInstance()
    {
        if (_instance == null)
        {
            _instance = new ComDlg32();
        }

        return _instance;
    }

    ComDlg32()
    {
        super("comdlg32");
        setUnicode(Kernel32.getInstance().isUnicode());
    }

    public static long getCommDlgExtendedError()
    {
        final Function function = getInstance().getFunction(FUNCTION_COMMON_DLG_EXTENDED_ERROR);
        UInt32 result = new UInt32();
        function.invoke(result);
        return result.getValue();
    }
}
