/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.Vector;

public class MenuTreePanel
extends Panel
implements MouseListener,
AdjustmentListener,
KeyListener {
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    Image doc;
    Image dir;
    Image open;
    Image iImage = null;
    Graphics gImage = null;
    MenuTreeElement root;
    MenuTreeElement selected;
    MenuTreeElement top;
    Vector tree = new Vector();
    int treeDepth = 0;
    int docW;
    int docH;
    int dirW;
    int dirH;
    int openW;
    int openH;
    int textH;
    int textA;
    int maxVisibleElements;
    int maxElements;
    int iHeight;
    int iVisibleWidth;
    int iWidth;
    int iTop;
    int iSelected;
    public Color colorSelected;
    MenuTreeApplet parent = null;

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.root != null) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            boolean bl = false;
            Point point = new Point(25, 0);
            PreviousElement previousElement = this.root.locate(n + this.sbHoriz.getValue(), n2, point, this.iTop, new PreviousElement());
            MenuTreeElement menuTreeElement = previousElement.mte;
            if (menuTreeElement != null && menuTreeElement.offspring != null && n < point.x + this.openW) {
                menuTreeElement.open = !menuTreeElement.open;
                bl = true;
            }
            if (this.selected != menuTreeElement) {
                if (this.selected != null) {
                    this.selected.selected = false;
                }
                this.selected = menuTreeElement;
                this.iSelected = previousElement.count - 1;
                if (this.selected != null) {
                    this.selected.selected = true;
                }
                bl = true;
                this.parent.status.setText(this.selected.comment);
            } else if (this.selected != null && mouseEvent.getClickCount() == 2 && (this.selected.offspring == null || n >= point.x + this.openW)) {
                this.parent.loadUrl(this.selected.url);
            }
            if (bl) {
                this.selected.next = null;
                this.drawTree();
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        switch (adjustmentEvent.getAdjustmentType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (adjustmentEvent.getSource() == this.sbVert) {
                    this.iTop = this.sbVert.getValue();
                    this.drawTree();
                    return;
                }
                this.repaint();
            }
        }
    }

    public MenuTreePanel(MenuTreeApplet menuTreeApplet, Image image, Image image2, Image image3) {
        this.parent = menuTreeApplet;
        this.setLayout(null);
        this.doc = image;
        this.dir = image2;
        this.open = image3;
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
        this.addMouseListener(this);
        this.sbHoriz.addAdjustmentListener(this);
        this.sbVert.addAdjustmentListener(this);
        this.colorSelected = new Color(0, 64, 128);
        this.addKeyListener(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 40: {
                if (this.selected != null) {
                    if (this.selected.next != null) {
                        this.selected.selected = false;
                        this.selected = this.selected.next;
                        ++this.iSelected;
                        if (this.iSelected > this.iTop + this.maxVisibleElements - 1) {
                            ++this.iTop;
                        }
                    }
                } else {
                    this.selected = (MenuTreeElement)this.tree.firstElement();
                }
                this.selected.selected = true;
                this.parent.status.setText(this.selected.comment);
                this.drawTree();
                return;
            }
            case 38: {
                if (this.selected != null) {
                    if (this.selected.previous != null) {
                        this.selected.selected = false;
                        this.selected = this.selected.previous;
                        this.iSelected += -1;
                        if (this.iSelected < this.iTop) {
                            this.iTop += -1;
                        }
                    }
                } else {
                    this.selected = (MenuTreeElement)this.tree.firstElement();
                }
                this.selected.selected = true;
                this.parent.status.setText(this.selected.comment);
                this.drawTree();
                return;
            }
            case 39: {
                if (this.selected.open || this.selected.offspring == null) break;
                this.selected.open = true;
                this.drawTree();
                return;
            }
            case 37: {
                if (!this.selected.open) break;
                this.selected.open = false;
                this.selected.next = null;
                this.drawTree();
                return;
            }
            case 10: {
                if (this.selected == null) break;
                this.parent.loadUrl(this.selected.url);
                return;
            }
            case 33: {
                if (this.selected != null) {
                    if (this.selected.previous != null) {
                        int n2 = 0;
                        this.selected.selected = false;
                        while (this.selected.previous != null && this.iSelected > 0 && n2 < this.maxVisibleElements) {
                            this.iSelected += -1;
                            ++n2;
                            this.selected = this.selected.previous;
                        }
                        while (this.iSelected < this.iTop) {
                            this.iTop += -1;
                        }
                    }
                } else {
                    this.selected = (MenuTreeElement)this.tree.firstElement();
                }
                this.selected.selected = true;
                this.parent.status.setText(this.selected.comment);
                this.drawTree();
                return;
            }
            case 34: {
                if (this.selected != null) {
                    if (this.selected.next != null) {
                        int n3 = 0;
                        this.selected.selected = false;
                        while (this.selected.next != null && n3 < this.maxVisibleElements) {
                            ++this.iSelected;
                            ++n3;
                            this.selected = this.selected.next;
                        }
                        while (this.iSelected > this.iTop + this.maxVisibleElements) {
                            ++this.iTop;
                        }
                    }
                } else {
                    this.selected = (MenuTreeElement)this.tree.firstElement();
                }
                this.selected.selected = true;
                this.parent.status.setText(this.selected.comment);
                this.drawTree();
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.iImage == null && this.root != null && this.getSize().height != 0 && this.getSize().width != 0) {
            this.getDimensions();
            int n = this.getSize().height;
            int n2 = this.getSize().width;
            this.iWidth = this.root.getMaxWidth(0) + 20;
            if (this.iWidth < n2) {
                this.remove(this.sbHoriz);
                this.iHeight = n;
            } else {
                this.sbHoriz.setValues(0, n2, 0, this.iWidth);
                this.iHeight = n - this.sbHoriz.getPreferredSize().height;
            }
            this.iVisibleWidth = n2 - this.sbVert.getPreferredSize().width;
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.drawTree();
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(0, this.iHeight, this.getSize().width, this.sbHoriz.getPreferredSize().height);
        graphics.drawImage(this.iImage, -this.sbHoriz.getValue(), 0, this);
        graphics.setColor(Color.black);
        graphics.drawLine(0, this.iHeight, this.getSize().width, this.iHeight);
    }

    public URL currentURL() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.url;
    }

    public void addLine(int n, URL uRL, String string, String string2) {
        MenuTreeElement menuTreeElement = new MenuTreeElement(n, uRL, string, string2, this);
        if (this.root == null) {
            if (n != 0) {
                throw new RuntimeException("Initial depth non-zero.");
            }
            this.top = this.root = menuTreeElement;
            this.tree.addElement(menuTreeElement);
            return;
        }
        if (n == this.treeDepth) {
            ((MenuTreeElement)this.tree.lastElement()).sibling = menuTreeElement;
            menuTreeElement.parent = (MenuTreeElement)this.tree.lastElement();
            this.tree.addElement(menuTreeElement);
        } else if (n > this.treeDepth) {
            if (n > this.treeDepth + 1) {
                throw new RuntimeException("Depth change error: " + string);
            }
            ((MenuTreeElement)this.tree.lastElement()).offspring = menuTreeElement;
            menuTreeElement.parent = (MenuTreeElement)this.tree.lastElement();
            this.tree.addElement(menuTreeElement);
        } else if (n < this.treeDepth) {
            int n2 = this.tree.size() - 1;
            while (((MenuTreeElement)this.tree.elementAt((int)n2)).depth != n || (MenuTreeElement)this.tree.elementAt(n2) == this.root) {
                --n2;
            }
            ((MenuTreeElement)this.tree.elementAt((int)n2)).sibling = menuTreeElement;
            menuTreeElement.parent = (MenuTreeElement)this.tree.lastElement();
            this.tree.addElement(menuTreeElement);
        }
        this.treeDepth = n;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void drawTree() {
        if (this.root != null && this.gImage != null) {
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
            this.gImage.setColor(Color.black);
            this.sbVert.setValues(this.iTop, this.maxVisibleElements, 0, this.root.getCount() + 10);
            this.root.paint(this.gImage, 10, 0, new Point(25, 0), this.iTop, new PreviousElement());
        }
        this.repaint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    void getDimensions() {
        this.docW = this.doc.getWidth(this);
        this.docH = this.doc.getHeight(this);
        this.dirW = this.dir.getWidth(this);
        this.dirH = this.dir.getHeight(this);
        this.openW = this.open.getWidth(this);
        this.openH = this.open.getHeight(this);
        this.textH = this.getFontMetrics(this.getFont()).getHeight();
        this.textA = this.getFontMetrics(this.getFont()).getAscent();
        int n = this.docH;
        if (n < this.dirH) {
            n = this.dirH;
        }
        if (n < this.openH) {
            n = this.openH;
        }
        if (n < this.textH) {
            n = this.textH;
        }
        this.maxVisibleElements = this.getSize().height / (n + 1);
        this.maxElements = this.root.getCount();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iHeight = n4 - this.sbHoriz.getPreferredSize().height;
        this.iVisibleWidth = n3 - this.sbVert.getPreferredSize().width;
        this.sbHoriz.setBounds(0, this.iHeight, this.iVisibleWidth, this.sbHoriz.getPreferredSize().height);
        this.sbVert.setBounds(this.iVisibleWidth, 0, this.sbVert.getPreferredSize().width, this.iHeight);
    }
}

