// Author: Philip Morgan, philip@imageviewer.co.uk, www.imageviewer.co.uk. May, 2001.

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.Math;

public class Nimatron extends Applet implements ActionListener, WindowListener, ItemListener {

  // These fields are declared static because they are used by static methods

  static TextField tfield1 = new TextField(5);
  static TextField tfield2 = new TextField(5);
  static TextField tfield3 = new TextField(5);
  static TextField tfield4 = new TextField(5);
  static TextField tfield5 = new TextField(5);
  static TextField tfield6 = new TextField(5);
  static TextField tfield7 = new TextField(20);

  static Button btn1 = new Button("One");
  static Button btn2 = new Button("Two");
  static Button btn3 = new Button("Three");
  static Button btn4 = new Button("Play again");


  static Checkbox player, Nim;
  static Label lab1 = new Label("Number of Nim's attempts: ");
  static TextField tfield8 = new TextField(5);

  static int nimMaxAttempts=500;
  static int nimAttempts=0;


  String tfield="tfield";
  int rand=0;
  int takeaway;
  int newValue;
  int oldValue;
  static boolean debug=false;
  static boolean forceNimToPlay=false;
  boolean started=false;
  static AudioClip playSound=null;
  static AudioClip winSound=null;
  static AudioClip playerSound=null;
  static AudioClip nimSound=null;
  static int attempt=0;

  String Copyright = "Nimatron V 1.1\nAuthor: Philip Morgan, Copyright  2001, All rights reserved.\nwww.imageviewer.co.uk\nphilip@imageviewer.co.uk.";  
  // Construct the applet version of Nim

  public void init() {

    String param = getParameter("debug");
    debug = (param != null) ? Boolean.valueOf(param).booleanValue() : false;
    setFont(new Font("SansSerif", 1, 12));
    setForeground(Color.black);
    add(tfield1);
    add(tfield2);
    add(tfield3);
    add(tfield4);
    tfield4.addActionListener(this);
    add(tfield5);
    tfield5.addActionListener(this);
    add(tfield6);
    tfield6.addActionListener(this);
    add(btn1);
    btn1.addActionListener(this);
    add(btn2);
    btn2.addActionListener(this);
    add(btn3);
    btn3.addActionListener(this);
    add(tfield7);
    tfield7.addActionListener(this);
    add(btn4);
    btn4.addActionListener(this);

    CheckboxGroup RadioGroup = new CheckboxGroup();

    add(player=new Checkbox("Player",RadioGroup,false));
    add(Nim=new Checkbox("Nim",RadioGroup,false));
    
    player.addItemListener(this); 
    Nim.addItemListener(this);

    add(lab1);
    add(tfield8);
    tfield8.addActionListener(this); 

    Color c = new Color(153,255,204);
    setBackground(c);

    String audio = getParameter("playAudio");
      if (audio != null) 
        playSound = getAudioClip(getCodeBase(), audio);

    audio = getParameter("winAudio");
      if (audio != null) 
        winSound = getAudioClip(getCodeBase(), audio);

    audio = getParameter("playerAudio");
      if (audio != null) 
        playerSound = getAudioClip(getCodeBase(), audio);

    audio = getParameter("nimAudio");
      if (audio != null) 
        nimSound = getAudioClip(getCodeBase(), audio);

    String nMaxAttempts = getParameter("nimMaxAttempts");
    if (nMaxAttempts != null) nimMaxAttempts = Integer.parseInt(nMaxAttempts); 

    play();

  }

  public void itemStateChanged(ItemEvent event) {
    Object obj;
    obj=event.getItem();

    if (obj.equals("Nim")) {
      nimsMove();
    }
  }

  public String getAppletInfo() {
    return Copyright; 
  }

  public String[][] getParameterInfo() {
    String[][] info = {
      {"debug", "boolean", "Turns on debug display. Default is false."},
      {"nimMaxAttempts", "integer", "Max no. of attempts by Nim for safe result. Default is 500."},
      {"playAudio", "AudioClip", "Plays when <Play again> button pressed."},
      {"winAudio", "AudioClip", "Plays when the game is over."},
      {"playerAudio", "AudioClip", "Plays when <player> makes a move."},
      {"nimAudio", "AudioClip", "Plays when <Nim> makes a move."}
    };
    return info;
  }

  // Construct the application version of Nim

  public static void main(String[] args) {

    Nimatron app = new Nimatron();
    Frame f = new Frame("NIMATRON APPLICATION");
    f.setBounds(300,100, 200, 325);
    f.add(app);
    app.add(tfield1);
    app.add(tfield2);
    app.add(tfield3);
    app.add(tfield4);
    app.tfield4.addActionListener(app);
    app.add(tfield5);
    app.tfield5.addActionListener(app);
    app.add(tfield6);
    app.tfield6.addActionListener(app);
    app.add(btn1);
    app.btn1.addActionListener(app);
    app.add(btn2);
    app.btn2.addActionListener(app);
    app.add(btn3);
    app.btn3.addActionListener(app);
    app.add(tfield7);
    app.tfield7.addActionListener(app);
    app.add(btn4);
    app.btn4.addActionListener(app);

    CheckboxGroup RadioGroup = new CheckboxGroup();

    app.add(player=new Checkbox("Player",RadioGroup,true));
    app.add(Nim=new Checkbox("Nim",RadioGroup,false));

    player.addItemListener(app); 
    Nim.addItemListener(app);  

    app.add(lab1);
    app.add(tfield8);
    app.tfield8.addActionListener(app);

    f.addWindowListener(app);
    f.setFont(new Font("Serif", 1, 14));
    Color c = new Color(153,255,204);
    f.setBackground(c);
    f.setForeground(Color.black);
    f.setVisible(true);
    if (args.length == 1)
      if (args[0].toLowerCase().equals("d")) debug = true; 
    play();
  }

  public static void play() {

    // Set up Nim's initial match piles, up to 200 in each pile

    player.setState(true);
    if (playSound != null)
      playSound.play();
    tfield1.setText(Integer.toString((int)(Math.random()*200)+1));
    tfield2.setText(Integer.toString((int)(Math.random()*200)+1));
    tfield3.setText(Integer.toString((int)(Math.random()*200)+1));
    tfield4.setText("");
    tfield5.setText("");
    tfield6.setText("");
    tfield7.setText("");
    tfield8.setText("");
  }
  
  public void actionPerformed(ActionEvent evt) {
    String str;
    str=evt.getActionCommand(); 

    // When player presses a button update the match pile

    if (str.equals("One")) 
      update(tfield4, tfield1, 1);
    if (str.equals("Two"))
      update(tfield5, tfield2, 2);
    if (str.equals("Three"))
      update(tfield6, tfield3, 3);

    if (str.equals("Play again"))
      play();
  }
    
  public void windowClosing(WindowEvent ev) {

   // Application only - check when user tries to close Frame window

    Frame f = (Frame)ev.getSource();

    // This closes the window

    f.dispose();

    // This releases the MSDOS (or other) shell

    System.exit(0);

  }

  // Interfaces must have all their methods declared, even those not used

  public void windowOpened(WindowEvent ev) {};

  public void windowIconified(WindowEvent ev) {};

  public void windowDeiconified(WindowEvent ev) {};

  public void windowActivated(WindowEvent ev) {};

  public void windowDeactivated(WindowEvent ev) {};

  public void windowClosed(WindowEvent ev) {};


 
  public void update(TextField take, TextField match, int matchNumber ) {

      //if (!NimStart) {

      /****** Player code *******/

      // Subtract player value from match pile

      takeaway = Integer.parseInt(take.getText());
      oldValue = Integer.parseInt(match.getText());
      newValue = oldValue - takeaway;
 
      // If existing match pile is empty, ignore player request

      if (oldValue == 0) {
        return;
      }

      else

      // Check for too high, or zero value from player

      if (newValue < 0) {
        tfield7.setText("Value too large");
        return;
      }

      else

      if (takeaway == 0) {
         tfield7.setText("Value can't be 0!");
         return;
      }
      
      // Update the match pile      

      match.setText(Integer.toString(newValue));
      
      take.setText("");
      tfield7.setText("Player takes: "+takeaway + " from: " + matchNumber); 
      if (playerSound != null)
        playerSound.play();
     
      // If player has taken the last match (in his dreams!), tell him!

      if ((Integer.parseInt(tfield1.getText()) + Integer.parseInt(tfield2.getText()) + Integer.parseInt(tfield3.getText())) == 0) {
        tfield7.setText("Player wins");
        if (winSound != null)
          winSound.play();
        return;
      }

      //} // End if (!take.equals("NimStart")

      // Display player's move for 2 seconds before Nim plays 

      try {Thread.sleep(2000);}catch(InterruptedException exp) {}
   
      nimsMove();
      /****** END Player code *******/
   } // End update()
      
   public static void nimsMove() {
      /****** NIM code *******/

      // Nim will play now
      
      String s1=null,s2=null,s3=null;

      int rndMatch=0;
      TextField match=tfield1;
      int oldValue, newValue;
      int takeaway;

      nimAttempts=0;
      forceNimToPlay=false;

      do { // while Nim's move is unsafe, keep making new moves
      
        while(true)  {  

          // Select a match pile at random

          rndMatch = (int)(Math.random()*3) + 1;
          if (rndMatch == 1) 
            match = tfield1;
          if (rndMatch == 2) 
            match = tfield2;
          if (rndMatch == 3) 
            match = tfield3;
      
          // If we get a match pile, check it has matches

          if (rndMatch > 0) {
            oldValue = Integer.parseInt(match.getText());  
            if (oldValue > 0) break;
          }
        }

        takeaway = 0; newValue=0;
        while (true) { // Get a value from 1-200 to take from match pile
          takeaway = (int)(Math.random()*200)+1;
          if (takeaway > 0) {
            newValue = oldValue - takeaway;	
          if (newValue >= 0) break;
        }
      } 
      
      // Set up parameters to be passed to Nim's safe checker method - doNim()

      if (rndMatch == 1) {
        s1 = Integer.toString(newValue);
        s2 = tfield2.getText();
        s3 = tfield3.getText();
      }
      if (rndMatch == 2) {
        s1 = tfield1.getText();
        s2 = Integer.toString(newValue);
        s3 = tfield3.getText();
      }
      if (rndMatch == 3) {
        s1 = tfield1.getText();
        s2 = tfield2.getText();
        s3 = Integer.toString(newValue);
      }
      if (forceNimToPlay) break;
      } while (doNim(s1, s2, s3).equals("Unsafe") && nimAttempts < nimMaxAttempts);

      
      if (debug) System.out.println("\nNimatron: Safe"); 
            
      // Update match pile with safe value

      match.setText(Integer.toString(newValue)); 
      if (nimSound != null)
        nimSound.play();

     
      // Check if Nim has taken last match

      if ((Integer.parseInt(tfield1.getText()) + Integer.parseInt(tfield2.getText()) + Integer.parseInt(tfield3.getText())) == 0){
        tfield7.setText("Nim takes: "+takeaway+ " - Nim wins");
        if (winSound != null)
          winSound.play();
      }
      else
        tfield7.setText("Nim takes: "+takeaway + " from: "+rndMatch);
    
  } // End nimsMove()

  // This method does the mathematics for Nim - ie, adds up the binary values of match piles
  // and divides each sum by 2 to check for odd/even results

  public static String doNim(String s1, String s2, String s3) {

    String str=null, result="No result";

    // This array holds the binary strings for each match pile

    int binStore[][] = new int[3][8];

    int sum[] = new int[8];
    int length=8, offset=0; 

    int value, remainder, quotient;

    if (debug) System.out.println("NimBin: " + s1 + " " + s2 + " "+ s3);

    for (int i = 0; i<3; i++) {

      if (i == 0) str = s1;
      if (i == 1) str = s2;
      if (i == 2) str = s3;

      value = Integer.parseInt(str);  

      // Convert the decimal value of each pile into its binary equivalent

      while (value > 0) {
        remainder = value % 2;
        quotient = value / 2;
    
        // Store the remainder in the array from right to left

        binStore[i][length - ++offset] = remainder;
        
        value = quotient;     
      }
      offset = 0;

    } // End   for (int i = 0; i<3; i++) 

    // Display the binary representation of the match pile values (in debug mode)

    for (int j=0; j<3;j++){
      for (int k=0; k<8; k++)
        if (debug) System.out.print(binStore[j][k]);
      if (debug) System.out.println("\n");
    }

    // Add the 3 binary numbers

    for (int l=0; l<8;l++)
      for (int m=0; m<3; m++)
        sum[l] += binStore[m][l];

    // Check results of addition - if any row has an odd value, the move is unsafe

    for (int n=0; n<8; n++) {
      if  (sum[n] % 2 != 0) {
        if (debug) System.out.println("\nUnsafe at position: " + (n+1));
        result = "Unsafe";
        break;
      }
      if (debug) System.out.print(sum[n]);
    }
      
    // Display Nim's number of searches for a safe result so far
    
    if (debug) tfield8.setText(Integer.toString(++nimAttempts));

    // Inform calling method if the the result was safe or unsafe

    if (!result.equals("Unsafe"))
      result = "Safe";

    return result;
  } // End doNim()

} // End class Nimatron