
import java.awt.*;
import java.io.*;
import java.net.*;

				/**
   * This abstract class simplifies (somewhat) the task of writing a 
   * filter pipe--i.e. one that reads data from one Pipe thread, filters
   * it somehow, and writes the results to some other Pipe.
   **/
	public abstract class PipeFilter extends Pipe {
  
	public PipeFilter(Pipe sink) throws IOException { super(sink); }
	/** The method that subclasses must implement to do the filtering */
	abstract public void filter(Reader in, Writer out) throws IOException;
	public void run() {
	  try { filter(in, out); } 
	  catch (IOException e) {}
	  finally { try { in.close(); out.close(); } catch (IOException e) {} }
	}
}            