/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import jclass.chart.BarPoint;
import jclass.chart.ChartDraw;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.MinMax;
import jclass.chart.SBarVal;

class SBarChartDraw
extends ChartDraw {
    public static final int OUTLINE_SENSITIVITY = 3;
    Point firstLast;
    Color outlineColor = Color.black;
    int x_reversed;
    int y_reversed;
    int delta_x;
    int delta_y;
    boolean is_3d = false;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList;
    JCLineStyle gridLineStyle;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin;
    BarPoint[][] pts;
    double bar_base;
    int left;
    int right;
    int top;
    int bottom;
    int height;
    MinMax x;
    MinMax y;
    MinMax datax;
    MinMax datay;
    boolean is_100_percent;
    boolean drawOutline = true;
    SBarVal[][] set_pos;
    SBarVal[][] set_neg;
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    int opp_x;
    int opp_y;
    Rectangle r;
    boolean editInverted = false;
    Point start;
    Point end;

    public void recalc() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        int n5;
        double d2;
        double d3;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        block67: {
            super.recalc();
            JCBarChartFormat jCBarChartFormat = this.dataObject.getBarChartFormat();
            this.is_100_percent = jCBarChartFormat.get100Percent();
            if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
                return;
            }
            this.outlineColor = this.dataObject.getOutlineColor();
            this.holeValue = this.dataObject.holeValue;
            this.datax = new MinMax();
            this.datay = new MinMax();
            this.dataObject.getDataBounds(this.datax, this.datay);
            this.xaxis = this.dataObject.xaxis;
            this.yaxis = this.dataObject.yaxis;
            this.bar_base = this.xaxis.step * (double)jCBarChartFormat.clusterWidth / 100.0;
            this.inverted = this.xaxis.isVertical;
            this.x = new MinMax();
            this.y = new MinMax();
            this.x.min = this.datax.min - this.bar_base / 2.0;
            this.x.max = this.datax.max + this.bar_base / 2.0;
            this.xaxis.setLimits(this.x);
            this.xaxis.calcTransformation();
            this.xaxis.layoutAnnotations();
            this.xaxis.checkAnnotations();
            this.x = this.xaxis.dataLimits;
            this.y = this.yaxis.dataLimits;
            int n13 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
            int n14 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
            this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
            this.right = this.left + n13 - 1;
            int n15 = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
            this.yOrigin = this.yaxis.origin.value;
            n12 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
            this.firstLast = this.dataObject.getFirstLast();
            this.x_reversed = this.xaxis.isReversed ? 1 : 0;
            this.y_reversed = this.yaxis.isReversed ? 1 : 0;
            this.delta_x = this.chartArea.deltaX;
            this.delta_y = this.chartArea.deltaY;
            this.is_3d = this.delta_x != 0 || this.delta_y != 0;
            this.seriesList = this.dataObject.getSeries();
            int n16 = this.seriesList.length;
            if (n16 == 0 || this.firstLast == null) {
                return;
            }
            int n17 = this.firstLast.y - this.firstLast.x + 1;
            this.fastAction = this.chartArea.fastAction;
            this.inAction = this.chartArea.inAction;
            if (!this.fastAction || !this.inAction) {
                this.xAxisPos = this.xaxis.getRealPlacementLocation();
                this.xGridLineList = this.xaxis.getGridLineList();
                if (this.xGridLineList == null) {
                    this.xGridLineList = new double[0];
                }
                this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
            }
            this.set_pos = new SBarVal[n17][n16];
            this.set_neg = new SBarVal[n17][n16];
            this.ytotal = new double[n17];
            this.ysum = new double[n17];
            this.ysum_neg = new double[n17];
            Point[] pointArray = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            Point[] pointArray2 = new Point[]{new Point(0, 0), new Point(this.delta_x, this.delta_y), new Point(0, 0), new Point(-this.delta_x, -this.delta_y)};
            n11 = 0;
            n10 = 0;
            int n18 = 0;
            int n19 = 0;
            n9 = 0;
            n8 = 0;
            this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n16];
            if (!this.is_3d && !this.is_100_percent) break block67;
            if (this.inverted) {
                this.opp_x = (this.delta_y > 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_x <= 0 ? 1 : 0) ^ this.y_reversed;
            } else {
                this.opp_x = (this.delta_x <= 0 ? 1 : 0) ^ this.x_reversed;
                this.opp_y = (this.delta_y > 0 ? 1 : 0) ^ this.y_reversed;
            }
            n7 = this.firstLast.x;
            while (n7 <= this.firstLast.y) {
                block68: {
                    int n20;
                    int n21;
                    int n22;
                    SBarVal sBarVal;
                    n6 = n7 - this.firstLast.x;
                    d3 = this.seriesList[0].getX(n7) - this.bar_base / 2.0;
                    d2 = d3 + this.bar_base;
                    if (d2 < this.datax.min || d3 > this.datax.max) break block68;
                    if (d3 < this.x.min) {
                        d3 = this.x.min;
                    }
                    if (d2 > this.x.max) {
                        d2 = this.x.max;
                    }
                    n5 = 0;
                    n4 = 0;
                    if (this.is_100_percent) {
                        this.ytotal[n6] = 0.0;
                    }
                    n3 = 0;
                    while (n3 < n16) {
                        d = this.seriesList[n3].getY(n7);
                        if (!(d == this.holeValue || d <= 0.0 && this.yaxis.isLogarithmic)) {
                            if (this.is_100_percent && this.seriesList[n3].isIncluded) {
                                int n23 = n6;
                                this.ytotal[n23] = this.ytotal[n23] + Math.abs(d);
                            }
                            if (this.seriesList[n3].isShowing) {
                                if (d < 0.0) {
                                    n4 = 1;
                                } else {
                                    n5 = 1;
                                }
                            }
                        }
                        ++n3;
                    }
                    if (this.is_100_percent && this.ytotal[n6] == 0.0) {
                        this.ytotal[n6] = 1.0;
                    }
                    if (!this.is_3d) break block68;
                    if (this.inverted) {
                        n10 = this.xaxis.toPixel(d3, this.drawFront);
                        n8 = n10 - this.xaxis.toPixel(d2, this.drawFront);
                        pointArray[0].y = n18 = this.opp_x != 0 ? n10 : n10 - n8;
                        pointArray2[0].y = n10 - n8;
                        pointArray2[2].y = n8;
                    } else {
                        n11 = this.xaxis.toPixel(d3, this.drawFront);
                        n9 = this.xaxis.toPixel(d2, this.drawFront) - n11;
                        pointArray2[0].x = n19 = this.opp_x != 0 ? n11 : n11 + n9;
                        pointArray[0].x = n11;
                        pointArray[2].x = n9;
                    }
                    n2 = 0;
                    n = 0;
                    double d4 = 0.0;
                    double d5 = 0.0;
                    int n24 = n12;
                    int n25 = n12;
                    int n26 = 0;
                    int n27 = 0;
                    boolean bl = false;
                    int n28 = 0;
                    while (n28 < n16) {
                        block69: {
                            block73: {
                                double d6;
                                block75: {
                                    block74: {
                                        block70: {
                                            block72: {
                                                block71: {
                                                    if (!this.seriesList[n28].isIncluded || !this.seriesList[n28].isShowing) break block69;
                                                    d = this.seriesList[n28].getY(n7);
                                                    d6 = 0.0;
                                                    if (d == this.holeValue || d <= 0.0 && this.yaxis.isLogarithmic) break block69;
                                                    boolean bl2 = bl = d < 0.0;
                                                    if (!bl) break block70;
                                                    double d7 = d6 = this.is_100_percent ? d5 / this.ytotal[n6] * 100.0 : d5;
                                                    if (d6 != this.y.min) break block71;
                                                    d5 += Math.min(0.0, d);
                                                    if (!(d6 < this.y.min)) break block72;
                                                    break block69;
                                                }
                                                d5 += Math.min(0.0, d);
                                            }
                                            double d8 = d6 = this.is_100_percent ? d5 / this.ytotal[n7] * 100.0 : d5;
                                            if (d6 > this.y.max) break block69;
                                            n26 = this.yaxis.toPixel(Math.max(d6, this.y.min), this.drawFront);
                                            n27 = n25;
                                            break block73;
                                        }
                                        double d9 = d6 = this.is_100_percent ? d4 / this.ytotal[n6] * 100.0 : d4;
                                        if (d6 != this.y.max) break block74;
                                        d4 += Math.max(0.0, d);
                                        if (!(d6 > this.y.max)) break block75;
                                        break block69;
                                    }
                                    d4 += Math.max(0.0, d);
                                }
                                double d10 = d6 = this.is_100_percent ? d4 / this.ytotal[n6] * 100.0 : d4;
                                if (d6 < this.y.min) break block69;
                                n26 = this.yaxis.toPixel(Math.min(d6, this.y.max), this.drawFront);
                                n27 = n24;
                            }
                            if (this.inverted) {
                                if (bl) {
                                    SBarVal sBarVal2 = new SBarVal();
                                    this.set_neg[n6][n] = sBarVal2;
                                    sBarVal = sBarVal2;
                                    ++n;
                                } else {
                                    SBarVal sBarVal3 = new SBarVal();
                                    this.set_pos[n6][n2] = sBarVal3;
                                    sBarVal = sBarVal3;
                                    ++n2;
                                }
                                sBarVal.nset_index = n28;
                                sBarVal.side_point0.x = n26;
                                sBarVal.side_point2.x = n27 - n26;
                                sBarVal.top_point.x = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n26 : n27;
                            } else {
                                if (bl) {
                                    SBarVal sBarVal4 = new SBarVal();
                                    this.set_neg[n6][n] = sBarVal4;
                                    sBarVal = sBarVal4;
                                    ++n;
                                } else {
                                    SBarVal sBarVal5 = new SBarVal();
                                    this.set_pos[n6][n2] = sBarVal5;
                                    sBarVal = sBarVal5;
                                    ++n2;
                                }
                                sBarVal.nset_index = n28;
                                sBarVal.side_point0.y = n27;
                                sBarVal.side_point2.y = n26 - n27;
                                sBarVal.top_point.y = this.opp_y == 0 && !bl || this.opp_y != 0 && bl ? n26 : n27;
                            }
                            if (bl) {
                                n25 = n26;
                            } else {
                                n24 = n26;
                            }
                        }
                        ++n28;
                    }
                    if (this.opp_y != 0) {
                        n22 = n2 - 1;
                        n21 = n;
                    } else {
                        n22 = n - 1;
                        n21 = n2;
                    }
                    BarPoint[] barPointArray = this.pts[n6];
                    int n29 = n22;
                    while (n29 >= 0) {
                        sBarVal = this.opp_y != 0 ? this.set_pos[n6][n29] : this.set_neg[n6][n29];
                        n20 = sBarVal.nset_index;
                        if (barPointArray[n20] == null) {
                            barPointArray[n20] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n20];
                        if (this.inverted) {
                            pointArray[0].x = sBarVal.side_point0.x;
                            pointArray[2].x = sBarVal.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = sBarVal.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = sBarVal.side_point0.y;
                            pointArray2[2].y = sBarVal.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = sBarVal.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        --n29;
                    }
                    n20 = 0;
                    while (n20 < n21) {
                        sBarVal = this.opp_y != 0 ? this.set_neg[n6][n20] : this.set_pos[n6][n20];
                        int n30 = sBarVal.nset_index;
                        if (barPointArray[n30] == null) {
                            barPointArray[n30] = new BarPoint();
                        }
                        BarPoint barPoint = barPointArray[n30];
                        if (this.inverted) {
                            pointArray[0].x = sBarVal.side_point0.x;
                            pointArray[2].x = sBarVal.side_point2.x;
                            barPoint.top = this.copyPointArray(pointArray);
                            pointArray2[0].x = sBarVal.top_point.x;
                            barPoint.side = this.copyPointArray(pointArray2);
                        } else {
                            pointArray2[0].y = sBarVal.side_point0.y;
                            pointArray2[2].y = sBarVal.side_point2.y;
                            barPoint.side = this.copyPointArray(pointArray2);
                            pointArray[0].y = sBarVal.top_point.y;
                            barPoint.top = this.copyPointArray(pointArray);
                        }
                        ++n20;
                    }
                }
                ++n7;
            }
            if (this.is_3d) {
                if (this.inverted) {
                    n10 = this.delta_y > 0 ? n15 + n14 - 1 : n15;
                } else {
                    n11 = this.delta_x <= 0 ? this.left : this.right;
                }
            }
        }
        n7 = 1;
        n6 = this.firstLast.x;
        while (n6 <= this.firstLast.y) {
            block76: {
                if (this.seriesList.length == 0) break;
                n5 = n6 - this.firstLast.x;
                d3 = this.seriesList[0].getX(n6) - this.bar_base / 2.0;
                d2 = d3 + this.bar_base;
                if (d2 < this.x.min || d3 > this.x.max) break block76;
                if (d3 < this.x.min) {
                    d3 = this.x.min;
                }
                if (d2 > this.x.max) {
                    d2 = this.x.max;
                }
                if (this.inverted) {
                    n10 = this.xaxis.toPixel(d3, this.drawFront);
                    n8 = Math.abs(this.xaxis.toPixel(d2, this.drawFront) - n10);
                    if (this.x_reversed == 0) {
                        n10 -= n8;
                    }
                } else {
                    n11 = this.xaxis.toPixel(d3, this.drawFront);
                    n9 = Math.abs(this.xaxis.toPixel(d2, this.drawFront) - n11);
                    if (this.x_reversed != 0) {
                        n11 -= n9;
                    }
                }
                this.ysum[n5] = 0.0;
                this.ysum_neg[n5] = 0.0;
                n4 = n12;
                n3 = n12;
                n2 = 0;
                n = 0;
                BarPoint[] barPointArray = this.pts[n5];
                int n31 = 0;
                while (n31 < this.seriesList.length) {
                    block77: {
                        boolean bl;
                        block79: {
                            double d11;
                            block78: {
                                if (!this.seriesList[n31].isIncluded || !this.seriesList[n31].isShowing) break block77;
                                if (barPointArray[n31] == null) {
                                    barPointArray[n31] = new BarPoint();
                                }
                                BarPoint barPoint = barPointArray[n31];
                                d = this.seriesList[n31].getY(n6);
                                barPoint.x = d3;
                                barPoint.y = d;
                                if (d == this.holeValue || d <= 0.0 && this.yaxis.isLogarithmic) break block77;
                                bl = d < 0.0;
                                d11 = 0.0;
                                if (!bl) break block78;
                                int n32 = n5;
                                this.ysum_neg[n32] = this.ysum_neg[n32] + Math.min(0.0, d);
                                double d12 = d11 = this.is_100_percent ? this.ysum_neg[n5] / this.ytotal[n5] * 100.0 : this.ysum_neg[n5];
                                if (d11 > this.y.max) break block77;
                                n2 = this.yaxis.toPixel(Math.max(d11, this.y.min), this.drawFront);
                                n = n3;
                                break block79;
                            }
                            int n33 = n5;
                            this.ysum[n33] = this.ysum[n33] + Math.max(0.0, d);
                            double d13 = d11 = this.is_100_percent ? this.ysum[n5] / this.ytotal[n5] * 100.0 : this.ysum[n5];
                            if (d11 < this.y.min) break block77;
                            n2 = this.yaxis.toPixel(Math.min(d11, this.y.max), this.drawFront);
                            n = n4;
                        }
                        if (this.inverted) {
                            if ((this.y_reversed ^ (bl ? 1 : 0)) != 0) {
                                n9 = n - n2;
                                n11 = n2;
                            } else {
                                n11 = n;
                                n9 = n2 - n;
                            }
                        } else if ((this.y_reversed ^ (bl ? 1 : 0)) != 0) {
                            n10 = n;
                            n8 = n2 - n;
                        } else {
                            n10 = n2;
                            n8 = n - n2;
                        }
                        if (n7 != 0) {
                            this.drawOutline = this.inverted ? n8 > 3 : n9 > 3;
                            n7 = 0;
                        }
                        barPoint.front = new Rectangle(n11, n10, n9, n8);
                        if (bl) {
                            n3 = n2;
                        } else {
                            n4 = n2;
                        }
                    }
                    ++n31;
                }
            }
            ++n6;
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.pts == null) {
            return;
        }
        int n4 = this.seriesList.length;
        if (n4 == 0 || this.firstLast == null) {
            return;
        }
        if (this.is_3d || this.is_100_percent) {
            boolean bl = false;
            boolean bl2 = false;
            int n5 = 0;
            if (this.opp_x != 0) {
                n3 = this.firstLast.y;
                n2 = -1;
                n = n3 < this.firstLast.x ? 0 : 1;
                n5 = this.xGridLineList.length - 1;
            } else {
                n3 = this.firstLast.x;
                n2 = 1;
                n = n3 > this.firstLast.y ? 0 : 1;
                n5 = 0;
            }
            int n6 = n3;
            while (n != 0) {
                int n7;
                int n8;
                SBarVal[][] sBarValArray;
                n = this.opp_x != 0 ? (n6 <= this.firstLast.x ? 0 : 1) : (n6 >= this.firstLast.y ? 0 : 1);
                int n9 = n6 - this.firstLast.x;
                if (!this.fastAction || !this.inAction) {
                    sBarValArray = null;
                    n8 = this.set_neg[n9].length - 1;
                    while (n8 >= 0) {
                        if (this.set_neg[n9][n8] != null) {
                            n7 = this.set_neg[n9][n8].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n9][n7];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                                break;
                            }
                        }
                        --n8;
                    }
                    if (sBarValArray == null) {
                        n7 = 0;
                        while (n7 < this.set_pos[n9].length && this.set_pos[n9][n7] != null) {
                            int n10 = this.set_pos[n9][n7].nset_index;
                            BarPoint barPoint = null;
                            try {
                                barPoint = this.pts[n9][n10];
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            if (barPoint != null) {
                                sBarValArray = barPoint;
                            }
                            ++n7;
                        }
                    }
                    if (sBarValArray != null) {
                        n7 = 0;
                        int n11 = 0;
                        if (this.inverted) {
                            n11 = sBarValArray.front.y + sBarValArray.front.height;
                            n7 = sBarValArray.front.y;
                        } else {
                            n7 = sBarValArray.front.x;
                            n11 = sBarValArray.front.x + sBarValArray.front.width;
                        }
                        if (!bl) {
                            int n12 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n7, n11);
                            if (n12 == 1) {
                                bl = true;
                            } else if (n12 == 2) {
                                bl2 = true;
                                bl = true;
                            }
                        }
                        if (this.xaxis.gridIsShowing) {
                            n5 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n7, n11, this.ysum[n9], this.ysum_neg[n9], this.xGridLineList, n5, n2, this.gridLineStyle);
                        }
                    }
                }
                sBarValArray = this.opp_y != 0 ? this.set_pos : this.set_neg;
                n8 = sBarValArray[n9].length - 1;
                while (n8 >= 0) {
                    if (sBarValArray[n9][n8] != null) {
                        n7 = sBarValArray[n9][n8].nset_index;
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n9][n7];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null) {
                            if (this.inverted) {
                                this.DrawBarFace(graphics, barPoint.top, n7, true, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.side, n7, false, this.drawOutline);
                            } else {
                                this.DrawBarFace(graphics, barPoint.side, n7, false, this.drawOutline);
                                this.DrawBarFace(graphics, barPoint.top, n7, true, this.drawOutline);
                            }
                        }
                    }
                    --n8;
                }
                sBarValArray = this.opp_y != 0 ? this.set_neg : this.set_pos;
                n7 = 0;
                while (n7 < sBarValArray[n9].length && sBarValArray[n9][n7] != null) {
                    int n13 = sBarValArray[n9][n7].nset_index;
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n9][n13];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null) {
                        if (this.inverted) {
                            this.DrawBarFace(graphics, barPoint.top, n13, true, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.side, n13, false, this.drawOutline);
                        } else {
                            this.DrawBarFace(graphics, barPoint.side, n13, false, this.drawOutline);
                            this.DrawBarFace(graphics, barPoint.top, n13, true, this.drawOutline);
                        }
                    }
                    ++n7;
                }
                if (bl2) {
                    this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, this.ysum_neg[n9], this.ysum[n9]);
                    bl2 = false;
                }
                n6 += n2;
            }
            if (!this.fastAction || !this.inAction) {
                this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, this.opp_x, bl, this.xGridLineList, n5, n2, this.gridLineStyle);
            }
        }
        n3 = this.firstLast.x;
        while (n3 <= this.firstLast.y) {
            if (this.seriesList.length == 0) break;
            n2 = n3 - this.firstLast.x;
            n = 0;
            while (n < this.seriesList.length) {
                if (this.seriesList[n].isShowing && this.seriesList[n].isIncluded) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n2][n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    JCChartStyle jCChartStyle = this.seriesList[n].getStyle();
                    if (barPoint != null && barPoint.front != null) {
                        if (this.drawOutline) {
                            jCChartStyle.getFillStyle().fillOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineColor);
                        } else {
                            jCChartStyle.getFillStyle().fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                        }
                    }
                }
                ++n;
            }
            ++n3;
        }
    }

    private Point[] copyPointArray(Point[] pointArray) {
        int n = pointArray.length;
        Point[] pointArray2 = new Point[n];
        int n2 = 0;
        while (n2 < n) {
            pointArray2[n2] = new Point(pointArray[n2].x, pointArray[n2].y);
            ++n2;
        }
        return pointArray2;
    }

    void DrawBarFace(Graphics graphics, Point[] pointArray, int n, boolean bl, boolean bl2) {
        JCFillStyle jCFillStyle = this.seriesList[n].getStyle().getFillStyle();
        int n2 = this.chartArea.deltaX;
        int n3 = this.chartArea.deltaY;
        boolean bl3 = bl && n3 <= 0 || !bl && n2 <= 0;
        Polygon polygon = new Polygon();
        int n4 = 0;
        while (n4 < pointArray.length) {
            if (n4 == 0) {
                polygon.addPoint(pointArray[n4].x, pointArray[n4].y);
            } else {
                polygon.addPoint(polygon.xpoints[n4 - 1] + pointArray[n4].x, polygon.ypoints[n4 - 1] + pointArray[n4].y);
            }
            ++n4;
        }
        if (bl3) {
            if (bl2) {
                jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                return;
            }
            jCFillStyle.fillPolygonHighlight(graphics, polygon);
            return;
        }
        if (bl2) {
            jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
            return;
        }
        jCFillStyle.fillPolygonShadow(graphics, polygon);
    }

    JCDataIndex pick(Point point, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        point.x -= rectangle.x;
        point.y -= rectangle.y;
        int n6 = -1;
        int n7 = -1;
        JCDataIndex jCDataIndex = null;
        int n8 = Integer.MAX_VALUE;
        int n9 = this.chartArea.deltaX;
        int n10 = this.chartArea.deltaY;
        boolean bl = n9 != 0 || n10 != 0;
        int n11 = this.seriesList.length;
        if (n11 == 0 || this.firstLast == null || this.pts == null) {
            return null;
        }
        if (bl || this.is_100_percent) {
            if (this.opp_x != 0) {
                n5 = this.firstLast.y;
                n4 = -1;
                n3 = n5 < this.firstLast.x ? 0 : 1;
            } else {
                n5 = this.firstLast.x;
                n4 = 1;
                n3 = n5 > this.firstLast.y ? 0 : 1;
            }
            int n12 = n5;
            while (n3 != 0) {
                n3 = this.opp_x != 0 ? (n12 <= this.firstLast.x ? 0 : 1) : (n12 >= this.firstLast.y ? 0 : 1);
                n2 = n12 - this.firstLast.x;
                BarPoint[] barPointArray = this.pts[n2];
                int n13 = 0;
                while (n13 < this.seriesList.length) {
                    if (barPointArray[n13] != null) {
                        int n14 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n13].top, this.inverted, n);
                        int n15 = JCChartUtil.distanceTo3dPolygon(point.x, point.y, barPointArray[n13].side, this.inverted, n);
                        if (n14 <= n8 || n15 <= n8) {
                            n6 = n13;
                            n7 = n12;
                            n8 = Math.min(n15, n14);
                        }
                    }
                    ++n13;
                }
                n12 += n4;
            }
        }
        n5 = this.firstLast.x;
        while (n5 <= this.firstLast.y) {
            n4 = n5 - this.firstLast.x;
            if (this.pts[n4] != null) {
                n3 = 0;
                while (n3 < this.pts[n4].length) {
                    if (this.seriesList[n3].isShowing) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n4][n3];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue && barPoint.front != null && (n2 = JCChartUtil.distance(point.x, point.y, barPoint.front)) <= n8) {
                            n6 = n3;
                            n7 = n5;
                            n8 = n2;
                        }
                    }
                    ++n3;
                }
            }
            ++n5;
        }
        if (n6 >= 0 && n7 >= 0) {
            jCDataIndex = new JCDataIndex(n7, this.seriesList[n6], n6);
            jCDataIndex.distance = n8;
        }
        return jCDataIndex;
    }

    Point unpick(int n, int n2) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n - this.firstLast.x][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return null;
        }
        double d = barPoint.y;
        double d2 = barPoint.x;
        int n3 = -1;
        int n4 = -1;
        if (d != this.holeValue && d2 != this.holeValue) {
            n4 = barPoint.front.y + barPoint.front.height / 2;
            n3 = barPoint.front.x + barPoint.front.width / 2;
            return new Point(n3, n4);
        }
        return null;
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.xaxis.isVertical;
        this.end = null;
        this.start = null;
    }

    void showEdit(JCDataIndex jCDataIndex, int n, int n2) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.drawingOrder];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n2;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    /*
     * Unable to fully structure code
     */
    int endEdit(JCDataIndex var1_1, int var2_2, int var3_3) {
        block4: {
            block3: {
                if (var1_1 == null || var1_1.dataView != this.dataObject) {
                    return -1;
                }
                this.chartArea.drawRubberBand(this.end, this.start);
                var4_4 = this.pts[var1_1.point - this.firstLast.x][var1_1.series.drawingOrder];
                var5_5 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
                if (!this.editInverted) break block3;
                if (var4_4.front.x >= var5_5) ** GOTO lbl-1000
                v0 = false;
                break block4;
            }
            if (var4_4.front.y < var5_5) ** GOTO lbl-1000
            v0 = false;
        }
        if (v0) lbl-1000:
        // 3 sources

        {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - var4_4.front.x : var4_4.front.y + var4_4.front.height - (var3_3 - this.r.y);
        } else {
            var6_6 = this.editInverted != false ? var2_2 - this.r.x - (var4_4.front.x + var4_4.front.width) : var4_4.front.y - (var3_3 - this.r.y);
        }
        var7_7 = this.editInverted != false ? var5_5 + var6_6 : var5_5 - var6_6;
        return var7_7;
    }
}

