/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.TagsView;

import cern.lhcias.csgui.Events.AlarmAdapter;
import cern.lhcias.csgui.Events.OpenViewAdapter;
import cern.lhcias.csgui.Events.TagChangeAdapter;
import cern.lhcias.csgui.Events.TagChangeEvent;
import cern.lhcias.csgui.Events.TagClickedAdapter;
import cern.lhcias.csgui.Events.TagClickedEvent;
import cern.lhcias.csgui.Services.configurationMgr;
import cern.lhcias.csgui.WinMgr.CentralManager;
import cern.lhcias.csgui.WinMgr.LimitsDialog;
import cern.lhcias.csgui.WinMgr.TextDialog;
import cern.lhcias.csgui.interfaces.AlarmListener;
import cern.lhcias.csgui.interfaces.OpenViewListener;
import cern.lhcias.csgui.interfaces.TagArrays;
import cern.lhcias.csgui.interfaces.TagClickedListener;
import cern.lhcias.csgui.interfaces.TagsView;
import cern.lhcias.csgui.rtdb.Tag;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.net.MalformedURLException;
import java.util.Vector;
import symantec.itools.awt.ImageButton;
import symantec.itools.awt.MultiList;
import symantec.itools.net.RelativeURL;

public class FrameDBView
extends Frame
implements TagsView,
TagClickedListener {
    CentralManager gStatus;
    configurationMgr cM;
    boolean fComponentsAdjusted = false;
    MultiList multiListDBView;
    TextField textFieldTagName;
    ImageButton imageButtonNew;
    ImageButton imageButtonCut;
    ImageButton imageButtonListValues;
    ImageButton imageButtonSetLimits;
    ImageButton imageButtonClean;
    ImageButton imageButtonSave;
    Button buttonOK;
    TagArrays tc;
    TagChangeAdapter tadapter;
    TagClickedAdapter tcadapter;
    Vector myListeners = new Vector();

    public FrameDBView(CentralManager centralManager) {
        Object object;
        this.gStatus = centralManager;
        this.setLayout(null);
        ((Component)this).setVisible(false);
        ((Component)this).setSize(379, 447);
        ((Component)this).setFont(new Font("Dialog", 0, 12));
        this.setForeground(new Color(0));
        ((Component)this).setBackground(new Color(0xFFFFFF));
        this.multiListDBView = new MultiList();
        try {
            object = new String[]{new String("Name"), new String("Value")};
            this.multiListDBView.setHeadings((String[])object);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.multiListDBView.setBounds(2, 36, 370, 401);
        this.multiListDBView.setBackground(new Color(0xFFFFFF));
        this.add(this.multiListDBView);
        this.textFieldTagName = new TextField();
        this.textFieldTagName.setBounds(1, 1, 123, 32);
        this.add(this.textFieldTagName);
        this.imageButtonNew = new ImageButton();
        try {
            this.imageButtonNew.setImageURL(RelativeURL.getURL("images/new.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonNew.setBounds(126, 4, 33, 26);
        this.add(this.imageButtonNew);
        this.imageButtonCut = new ImageButton();
        try {
            this.imageButtonCut.setImageURL(RelativeURL.getURL("images/cut.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonCut.setBounds(162, 4, 33, 26);
        this.add(this.imageButtonCut);
        this.imageButtonListValues = new ImageButton();
        try {
            this.imageButtonListValues.setImageURL(RelativeURL.getURL("images/list.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonListValues.setBounds(198, 4, 33, 26);
        this.add(this.imageButtonListValues);
        this.imageButtonSetLimits = new ImageButton();
        try {
            this.imageButtonSetLimits.setImageURL(RelativeURL.getURL("images/limits.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonSetLimits.setBounds(234, 4, 33, 26);
        this.add(this.imageButtonSetLimits);
        this.imageButtonClean = new ImageButton();
        try {
            this.imageButtonClean.setImageURL(RelativeURL.getURL("images/clean.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonClean.setBounds(270, 4, 33, 26);
        this.add(this.imageButtonClean);
        this.imageButtonSave = new ImageButton();
        try {
            this.imageButtonSave.setImageURL(RelativeURL.getURL("images/save.gif"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.imageButtonSave.setBounds(306, 4, 33, 26);
        this.add(this.imageButtonSave);
        this.buttonOK = new Button();
        this.buttonOK.setActionCommand("button");
        this.buttonOK.setLabel("OK");
        this.buttonOK.setBounds(342, 4, 33, 26);
        this.buttonOK.setBackground(new Color(0xC0C0C0));
        this.add(this.buttonOK);
        this.setTitle("RView: DataBase Viewer");
        this.setResizable(false);
        object = new SymWindow();
        this.addWindowListener((WindowListener)object);
        SymAction symAction = new SymAction();
        this.imageButtonNew.addActionListener(symAction);
        this.imageButtonCut.addActionListener(symAction);
        this.imageButtonListValues.addActionListener(symAction);
        this.imageButtonSetLimits.addActionListener(symAction);
        this.imageButtonClean.addActionListener(symAction);
        SymMouse symMouse = new SymMouse();
        this.multiListDBView.addMouseListener(symMouse);
        this.imageButtonSave.addActionListener(symAction);
        this.buttonOK.addActionListener(symAction);
    }

    public FrameDBView(String string, CentralManager centralManager) {
        this(centralManager);
        this.setTitle(string);
    }

    public synchronized void show() {
        this.move(50, 50);
        super.show();
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        ((Component)this).setSize(this.insets().left + this.insets().right + dimension.width, this.insets().top + this.insets().bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(this.insets().left, this.insets().top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public void hide() {
        if (this.tadapter != null) {
            this.tadapter.removeTagChangeListener(this);
        }
        if (this.tcadapter != null) {
            this.tcadapter.removeTagClickedListener(this);
        }
        super.hide();
    }

    public void instantiate(TagArrays tagArrays, String string, TagChangeAdapter tagChangeAdapter, TagClickedAdapter tagClickedAdapter, OpenViewAdapter openViewAdapter, configurationMgr configurationMgr2, AlarmAdapter alarmAdapter) {
        this.tc = tagArrays;
        this.tadapter = tagChangeAdapter;
        this.tcadapter = tagClickedAdapter;
        this.cM = configurationMgr2;
        this.show();
        this.tcadapter.addTagClickedListener(this);
        if (string != null && string.length() > 0) {
            this.setConfig(string);
        }
    }

    public String toString() {
        Vector vector = this.tc.getTags();
        String[] stringArray = new String[vector.size() + 1];
        stringArray[0] = "#ViewType " + this.getType();
        int n = 0;
        while (n < vector.size()) {
            stringArray[n + 1] = "#TagDef " + ((Tag)vector.elementAt(n)).toString() + ",";
            ++n;
        }
        return this.cM.saveConfigurationFile(null, stringArray);
    }

    public void setConfig(String string) {
        if (string == null) {
            return;
        }
        if (string.length() < 1) {
            return;
        }
        this.cM.initDataServers(string);
        this.cM.initDataBase(string);
    }

    public void remove() {
        this.hide();
    }

    public void addTag(String string) {
        this.tc.addTag(string);
    }

    public void addTag(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                this.addTag(string);
            }
            ++n;
        }
    }

    public void addTag(TagsView tagsView) {
        this.addTag(tagsView.getTagNames());
    }

    public void removeTag(String string) {
        this.tc.deleteTag(string);
    }

    public void removeTag(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (string != null) {
                this.removeTag(string);
            }
            ++n;
        }
    }

    public void removeTag(TagsView tagsView) {
        this.removeTag(tagsView.getTagNames());
    }

    public void setProperty(String string, String string2, String string3) {
    }

    public boolean doYouImplement(String string) {
        return string.equalsIgnoreCase("DBView");
    }

    public Vector getPossibleTypes() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("DBView");
        return vector;
    }

    public int getComponentNb() {
        return 0;
    }

    public Vector getComponentsList() {
        return null;
    }

    public Vector getLocalTagNames() {
        return this.getTagNames();
    }

    public String getType() {
        return "DBConfig";
    }

    public Vector getTagNames() {
        return this.tc.getTagNames();
    }

    public synchronized void repaint() {
        try {
            int n = this.tc.getNumberOfTags();
            if (n > 0) {
                Object object;
                Vector vector = this.tc.getTags();
                String[] stringArray = new String[n];
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    object = String.valueOf(((Tag)vector.elementAt(n3)).getTagName()) + ";" + ((Tag)vector.elementAt(n3)).stringValue();
                    if (((String)object).length() > 1) {
                        stringArray[n2] = new String((String)object);
                        ++n2;
                    }
                    ++n3;
                }
                if (n2 == n) {
                    object = stringArray;
                } else {
                    object = new String[n2];
                    int n4 = 0;
                    while (n4 < n2) {
                        object[n4] = stringArray[n4];
                        ++n4;
                    }
                }
                if (((String[])object).length > 0) {
                    this.multiListDBView.setListItems(stringArray);
                    return;
                }
            } else {
                this.multiListDBView.setListItems(new String[0]);
            }
            return;
        }
        catch (PropertyVetoException propertyVetoException) {
            return;
        }
    }

    public synchronized void addTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.addElement(tagClickedListener);
    }

    public synchronized void removeTagClickedListener(TagClickedListener tagClickedListener) {
        this.myListeners.removeElement(tagClickedListener);
    }

    void fireTagClickedEvent(String string) {
        TagClickedEvent tagClickedEvent = new TagClickedEvent(this);
        tagClickedEvent.setTagName(string);
        int n = 0;
        while (n < this.myListeners.size()) {
            ((TagClickedListener)this.myListeners.elementAt(n)).receiveTagClicked(tagClickedEvent);
            ++n;
        }
    }

    public void receiveTagClicked(TagClickedEvent tagClickedEvent) {
        ((TextComponent)this.textFieldTagName).setText(tagClickedEvent.TagName);
    }

    public void receiveTagChange(TagChangeEvent tagChangeEvent) {
        this.repaint();
    }

    public void addOpenViewListener(OpenViewListener openViewListener) {
    }

    public void removeOpenViewListener(OpenViewListener openViewListener) {
    }

    public void addAlarmListener(AlarmListener alarmListener) {
    }

    public void removeAlarmListener(AlarmListener alarmListener) {
    }

    void Frame1_WindowClosing(WindowEvent windowEvent) {
        if (this.tadapter != null) {
            this.tadapter.removeTagChangeListener(this);
        }
        if (this.tcadapter != null) {
            this.tcadapter.removeTagClickedListener(this);
        }
        this.dispose();
    }

    void buttonOK_Action(ActionEvent actionEvent) {
        if (this.tadapter != null) {
            this.tadapter.removeTagChangeListener(this);
        }
        if (this.tcadapter != null) {
            this.tcadapter.removeTagClickedListener(this);
        }
        this.dispose();
    }

    void imageButtonNew_actionPerformed(ActionEvent actionEvent) {
        String string = this.textFieldTagName.getText();
        if (string != null && string.length() > 0) {
            this.addTag(string);
        }
    }

    void imageButtonCut_actionPerformed(ActionEvent actionEvent) {
        String string = this.textFieldTagName.getText();
        if (string != null && string.length() > 0) {
            this.removeTag(string);
        }
    }

    void imageButtonListValues_actionPerformed(ActionEvent actionEvent) {
        String string = this.textFieldTagName.getText();
        if (string != null && string.length() > 0) {
            String string2 = this.tc.getTag(string).getTagHistory().toString();
            new TextDialog((Frame)this, "List of Values", string2);
        }
    }

    void imageButtonSetLimits_actionPerformed(ActionEvent actionEvent) {
        String string = this.textFieldTagName.getText();
        if (string != null && string.length() > 0) {
            LimitsDialog limitsDialog = new LimitsDialog(this.tc, string, this, true);
            limitsDialog.setTitle("Enter Limits for :" + string);
            limitsDialog.set_value(this.tc, string);
            limitsDialog.show();
        }
    }

    void imageButtonClean_actionPerformed(ActionEvent actionEvent) {
        this.tc.cleanDataBase(this.tadapter.getSubscribedTags());
    }

    void multiListDBView_mouseClicked(MouseEvent mouseEvent) {
        try {
            String string;
            int n = this.multiListDBView.getSelectedRow();
            if (n < this.tc.getNumberOfTags() && n >= 0 && (string = this.multiListDBView.getCellText(n, 0)) != null) {
                ((TextComponent)this.textFieldTagName).setText(string);
                this.fireTagClickedEvent(string);
                return;
            }
        }
        catch (Exception exception) {}
    }

    void imageButtonSave_actionPerformed(ActionEvent actionEvent) {
        this.gStatus.Save(this);
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == FrameDBView.this) {
                FrameDBView.this.Frame1_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
            FrameDBView.this = FrameDBView.this;
        }
    }

    class SymAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FrameDBView.this.imageButtonNew) {
                FrameDBView.this.imageButtonNew_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.imageButtonCut) {
                FrameDBView.this.imageButtonCut_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.imageButtonListValues) {
                FrameDBView.this.imageButtonListValues_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.imageButtonSetLimits) {
                FrameDBView.this.imageButtonSetLimits_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.imageButtonClean) {
                FrameDBView.this.imageButtonClean_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.imageButtonSave) {
                FrameDBView.this.imageButtonSave_actionPerformed(actionEvent);
                return;
            }
            if (object == FrameDBView.this.buttonOK) {
                FrameDBView.this.buttonOK_Action(actionEvent);
            }
        }

        SymAction() {
            FrameDBView.this = FrameDBView.this;
        }
    }

    class SymMouse
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == FrameDBView.this.multiListDBView) {
                FrameDBView.this.multiListDBView_mouseClicked(mouseEvent);
            }
        }

        SymMouse() {
            FrameDBView.this = FrameDBView.this;
        }
    }
}

