/*
 * Decompiled with CFR 0.152.
 */
package cern.lhcias.csgui.rtdb;

import cern.lhcias.csgui.interfaces.DataServer;
import cern.lhcias.csgui.interfaces.tagHistory;
import cern.lhcias.csgui.rtdb.Trend;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;

public class Tag {
    public static final int TYPE_VALUE = 0;
    public static final int TYPE_STRING = 1;
    public static final boolean REMOTE = true;
    public static final boolean LOCAL = false;
    private String tagName = "";
    private double minimum;
    private double maximum;
    private double higherLimit;
    private double lowerLimit;
    private boolean isLimited = false;
    private int type = 0;
    private String stringValue = "";
    private int intValue;
    private double doubleValue;
    private long date;
    private boolean validity = false;
    private boolean acquisitionError = true;
    private Trend trend = new Trend();
    private boolean remoteStatus = true;
    private double increment;
    private String unit;
    private DataServer DataServer;
    private String processName;
    PropertyChangeSupport changeListeners;

    public Tag() {
        this.init();
    }

    public Tag(String string) {
        this.init();
        this.setTagName(string);
    }

    public void init() {
        this.changeListeners = new PropertyChangeSupport(this);
    }

    public void setDataServer(DataServer dataServer) {
        DataServer dataServer2 = this.DataServer;
        this.DataServer = dataServer;
        if (dataServer2 != dataServer) {
            this.changeListeners.firePropertyChange("DataServer", dataServer2, dataServer);
        }
    }

    public DataServer getDataServer() {
        return this.DataServer;
    }

    public void setProcessName(String string) {
        String string2 = this.processName;
        this.processName = string;
        if (string2 != string) {
            this.changeListeners.firePropertyChange("processName", string2, string);
        }
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setIncrement(double d) {
        double d2 = this.increment;
        this.increment = d;
        if (d2 != d) {
            this.changeListeners.firePropertyChange("increment", new Double(d2).toString(), new Double(d).toString());
        }
    }

    public double getIncrement() {
        return this.increment;
    }

    public void setUnit(String string) {
        String string2 = this.unit;
        this.unit = string;
        if (string2 != string) {
            this.changeListeners.firePropertyChange("unit", string2, string);
        }
    }

    public String getUnit() {
        return this.unit;
    }

    public void setLimits(double d, double d2, double d3, double d4) {
        this.setLimits(d, d2, d3, d4, true);
    }

    public void setLimits(double d, double d2, double d3, double d4, boolean bl) {
        if (this.minimum != d || this.maximum != d2 || this.higherLimit != d4 || this.lowerLimit != d3 || this.isLimited != bl) {
            this.minimum = d;
            this.maximum = d2;
            this.higherLimit = d4;
            this.lowerLimit = d3;
            this.isLimited = bl;
            this.changeListeners.firePropertyChange("limits", "", "");
        }
    }

    public void setLimits(double d, double d2) {
        this.setLimits(d, d2, d, d2);
    }

    public double[] getLimits() {
        double[] dArray = new double[]{this.minimum, this.maximum, this.lowerLimit, this.higherLimit};
        return dArray;
    }

    public void setLocal() {
        if (this.remoteStatus) {
            this.remoteStatus = false;
            this.changeListeners.firePropertyChange("remoteStatus", "REMOTE", "LOCAL");
        }
    }

    public void setRemote() {
        if (!this.remoteStatus) {
            this.remoteStatus = true;
            this.changeListeners.firePropertyChange("remoteStatus", "LOCAL", "REMOTE");
        }
    }

    public void setRemoteStatus(boolean bl) {
        if (this.remoteStatus != bl) {
            this.remoteStatus = bl;
            if (this.remoteStatus) {
                this.changeListeners.firePropertyChange("remoteStatus", "LOCAL", "REMOTE");
                return;
            }
            this.changeListeners.firePropertyChange("remoteStatus", "REMOTE", "LOCAL");
        }
    }

    public boolean getRemoteStatus() {
        return this.remoteStatus;
    }

    public boolean isRemote() {
        return this.remoteStatus;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public double doubleValue() {
        return this.doubleValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public boolean getAcquisitionError() {
        return this.acquisitionError;
    }

    public String getDateAsString() {
        return new Date(this.date).toGMTString();
    }

    public long getDate() {
        return this.date;
    }

    public void setTagName(String string) {
        if (this.tagName != string) {
            String string2 = this.tagName;
            this.tagName = string;
            this.trend.initHistory();
            this.changeListeners.firePropertyChange("name", string2, string);
        }
    }

    public void setType(int n) {
        if (this.type != n) {
            int n2 = this.type;
            this.type = n;
            this.changeListeners.firePropertyChange("type", new Integer(n2).toString(), new Integer(n).toString());
        }
    }

    public int getType() {
        return this.type;
    }

    public void setAcquisitionError() {
        this.acquisitionError = true;
    }

    public void setAcquisitionError(boolean bl) {
        this.acquisitionError = bl;
    }

    public void clearAcquisitionError() {
        this.acquisitionError = false;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String toString() {
        return String.valueOf(this.tagName) + ";" + this.stringValue + ";" + String.valueOf(this.minimum) + ";" + String.valueOf(this.maximum) + ";" + String.valueOf(this.lowerLimit) + ";" + String.valueOf(this.higherLimit) + ";" + String.valueOf(this.isLimited) + ";" + String.valueOf(this.validity) + ";" + String.valueOf(this.processName) + ";" + String.valueOf(this.remoteStatus) + ";" + String.valueOf(this.increment) + ";" + String.valueOf(this.unit);
    }

    public void setConfig(String string) {
        string = string.trim();
        try {
            this.setTagName(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            String string2 = string.substring(0, string.indexOf(59));
            string = string.substring(string.indexOf(59) + 1);
            Double d = new Double(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            Double d2 = new Double(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            Double d3 = new Double(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            Double d4 = new Double(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            Boolean bl = new Boolean(string.substring(0, string.indexOf(59)));
            this.setLimits(d, d2, d3, d4, bl);
            string = string.substring(string.indexOf(59) + 1);
            bl = new Boolean(string.substring(0, string.indexOf(59)));
            this.setValidity(bl);
            string = string.substring(string.indexOf(59) + 1);
            this.setProcessName(string.substring(0, string.indexOf(59)));
            string = string.substring(string.indexOf(59) + 1);
            bl = new Boolean(string.substring(0, string.indexOf(59)));
            this.setRemoteStatus(bl);
            string = string.substring(string.indexOf(59) + 1);
            Double d5 = new Double(string.substring(0, string.indexOf(59)));
            this.setIncrement(d5);
            string = string.substring(string.indexOf(59) + 1);
            this.setUnit(string);
            this.setValue(string2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setInvalidValue() {
        this.validity = false;
        this.trend.insertInvalidValue();
    }

    public void setInvalidValue(long l) {
        this.validity = false;
        this.trend.insertInvalidValue(l);
    }

    public void setValue(String string) {
        this.setValue(string, new Date().getTime());
    }

    public void setValue(String string, long l) {
        this.clearAcquisitionError();
        this.stringValue = string;
        this.date = l;
        this.type = 0;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < '+' || c > '9') {
                this.type = 1;
            }
            ++n;
        }
        if (this.type == 0) {
            Double d = new Double(string);
            Integer n2 = new Integer(d.intValue());
            this.intValue = n2;
            this.doubleValue = d;
            this.validity = true;
            if (!this.isLimited) {
                if (this.minimum > this.doubleValue) {
                    this.minimum = this.doubleValue;
                }
                if (this.maximum < this.doubleValue) {
                    this.maximum = this.doubleValue;
                }
                if (this.lowerLimit > this.doubleValue) {
                    this.lowerLimit = this.doubleValue;
                }
                if (this.higherLimit < this.doubleValue) {
                    this.higherLimit = this.doubleValue;
                }
            }
            this.trend.insertValue(this.doubleValue, this.date);
        }
    }

    public boolean isValid() {
        return this.validity;
    }

    public tagHistory getTagHistory() {
        return this.trend;
    }

    public void setProperty(String string, String string2) {
        if (string.equalsIgnoreCase("ProcessName")) {
            this.setProcessName(string2);
        }
        if (string.equalsIgnoreCase("Increment")) {
            this.setIncrement(new Double(string2));
        }
        if (string.equalsIgnoreCase("Unit")) {
            this.setUnit(string2);
        }
        if (string.equalsIgnoreCase("minimum")) {
            this.setMinimum(new Double(string2));
        }
        if (string.equalsIgnoreCase("maximum")) {
            this.setMaximum(new Double(string2));
        }
        if (string.equalsIgnoreCase("higherLimit")) {
            this.setHigherLimit(new Double(string2));
        }
        if (string.equalsIgnoreCase("lowerLimit")) {
            this.setLowerLimit(new Double(string2));
        }
        if (string.equalsIgnoreCase("remoteStatus")) {
            if (string2.equalsIgnoreCase("REMOTE")) {
                this.setRemote();
            }
            if (string2.equalsIgnoreCase("LOCAL")) {
                this.setLocal();
            }
        }
        if (string.equalsIgnoreCase("Value")) {
            this.setValue(string2);
        }
        if (string.equalsIgnoreCase("TagName")) {
            this.setTagName(string2);
        }
        if (string.equalsIgnoreCase("type")) {
            if (string2.equalsIgnoreCase("VALUE")) {
                this.setType(0);
            }
            if (string2.equalsIgnoreCase("STRING")) {
                this.setType(1);
            }
        }
        if (string.equalsIgnoreCase("Validity")) {
            if (string2.equalsIgnoreCase("VALID")) {
                this.setValidity(true);
            }
            if (string2.equalsIgnoreCase("INVALID")) {
                this.setValidity(false);
            }
        }
        if (string.equalsIgnoreCase("date")) {
            this.setDate(string2);
        }
    }

    public String getProperty(String string) {
        if (string.equalsIgnoreCase("ProcessName")) {
            return this.getProcessName();
        }
        if (string.equalsIgnoreCase("Increment")) {
            return String.valueOf(this.getIncrement());
        }
        if (string.equalsIgnoreCase("Unit")) {
            return String.valueOf(this.getUnit());
        }
        if (string.equalsIgnoreCase("minimum")) {
            return String.valueOf(this.getMinimum());
        }
        if (string.equalsIgnoreCase("maximum")) {
            return String.valueOf(this.getMaximum());
        }
        if (string.equalsIgnoreCase("higherLimit")) {
            return String.valueOf(this.getHigherLimit());
        }
        if (string.equalsIgnoreCase("lowerLimit")) {
            return String.valueOf(this.getLowerLimit());
        }
        if (string.equalsIgnoreCase("remoteStatus")) {
            return String.valueOf(this.getRemoteStatus());
        }
        if (string.equalsIgnoreCase("Value")) {
            return this.stringValue();
        }
        if (string.equalsIgnoreCase("TagName")) {
            return this.getTagName();
        }
        if (string.equalsIgnoreCase("type")) {
            if (this.getType() == 0) {
                return "VALUE";
            }
            if (this.getType() == 1) {
                return "STRING";
            }
        }
        if (string.equalsIgnoreCase("Validity")) {
            if (this.getValidity()) {
                return "VALID";
            }
            return "INVALID";
        }
        if (string.equalsIgnoreCase("date")) {
            return this.getDateAsString();
        }
        return "";
    }

    public void setValidity(boolean bl) {
        this.validity = bl;
    }

    public boolean getValidity() {
        return this.validity;
    }

    public void setMinimum(double d) {
        this.minimum = d;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setLowerLimit(double d) {
        this.lowerLimit = d;
    }

    public double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setHigherLimit(double d) {
        this.higherLimit = d;
    }

    public double getHigherLimit() {
        return this.higherLimit;
    }

    public void setDate(String string) {
        this.date = new Date(string).getTime();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListeners.removePropertyChangeListener(propertyChangeListener);
    }
}

