/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.io.InputStream;
import java.util.Vector;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import symantec.itools.multimedia.SoundViewerItem;

class SoundViewerThread
extends Thread {
    private Vector clips;
    private boolean doEnd = false;
    private AudioDataStream curStream;
    private int repeatCt;
    private boolean sync = true;

    SoundViewerThread(Vector clips, boolean sync, int rct) {
        this.clips = clips;
        this.sync = sync;
        this.repeatCt = rct;
    }

    public void run() {
        while (this.repeatCt == -1 || this.repeatCt-- > 0) {
            int nClips = this.clips.size();
            int index = 0;
            while (index < nClips && !this.doEnd) {
                SoundViewerItem spi = (SoundViewerItem)this.clips.elementAt(index);
                this.curStream = new AudioDataStream(spi.data);
                AudioPlayer.player.start((InputStream)this.curStream);
                if (this.sync) {
                    try {
                        Thread.sleep(spi.delay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++index;
            }
            this.curStream = null;
        }
        this.doEnd = false;
    }

    void doSync(boolean f) {
        this.sync = f;
    }

    void doStop() {
        if (this.curStream != null) {
            AudioPlayer.player.stop((InputStream)this.curStream);
        }
        this.doEnd = true;
    }
}

