package cern.lhcias.csgui.Events;

import java.util.*;
import cern.lhcias.csgui.interfaces.*;
/**
This class is an event adapter which centrally manages the TagChange events. 
Each listener may ask for a specific tag list. In that case, they will receive an event
only if one of the tags belonging to their task list has changed.
If there is no task list (default) then the listener receive an event when any
of the tags change.
* @see cern.lhcias.csgui.Events.TagChangeEvent
*/
public class TagChangeAdapter implements TagChangeListener
{
    Vector myListeners;
    Vector listenerTagList;

    public TagChangeAdapter() {
        myListeners = new Vector();
        listenerTagList = new Vector();
    }
    
    public synchronized void addTagChangeListener( TagChangeListener listener) {
        int index = myListeners.indexOf(listener);
        if (index < 0) {
            myListeners.addElement(listener);
            listenerTagList.addElement(null); // initialised to a null tag list
        }
    }
    
    public synchronized void removeTagChangeListener(TagChangeListener listener) {
        int index = myListeners.indexOf(listener);
        if (index > -1) {
            myListeners.removeElement(listener);
            listenerTagList.removeElementAt(index);
        }
    }
    
    /**
    Used by the listeners to subscribe to a specific tag list. 
    If tagList is not null, then its content is added to the list of tags already 
    subscribed by this listener. If tagList is null, all the subscriptions for 
    this listener are canceled.
    */
    public void subscribeTagList(TagChangeListener listener, Vector tagList){
        Vector newTagList = new Vector();;
        if (tagList != null) {
            for (int i=0; i<tagList.size();i++)
                if (!newTagList.contains(tagList.elementAt(i)))
                    newTagList.addElement(tagList.elementAt(i));
        }
        else
            newTagList = null;
        int index = myListeners.indexOf(listener);
        if (index < 0) {
            myListeners.addElement(listener);
            listenerTagList.addElement(newTagList);
        }
        else {
            listenerTagList.setElementAt(newTagList, index) ;
        }
    }
    
     public void receiveTagChange(TagChangeEvent tagevent)
    {
        for (int i=0; i<myListeners.size(); i++) {
            if (listenerTagList.elementAt(i) == null)
              ((TagChangeListener) myListeners.elementAt(i)).receiveTagChange(tagevent);
            else {
               TagChangeEvent new_tagevent = new TagChangeEvent(this);
               Vector TagList = (Vector) listenerTagList.elementAt(i); 
               for (int j=0; j<TagList.size();j++) {
                   if (tagevent.contains((String) TagList.elementAt(j))) {
                      new_tagevent.addTag((String) TagList.elementAt(j));
                   }
               }
               if (new_tagevent.size() > 0)
                  ((TagChangeListener) myListeners.elementAt(i)).receiveTagChange(new_tagevent);
            }
        }
     }
     
     /** Returns a Vector containing the names of all the subscribed Tags
     */
     public Vector getSubscribedTags() {
        Vector SubscribedTags = new Vector();
        for (int i=0; i<listenerTagList.size(); i++) {
            Vector TagList = (Vector) listenerTagList.elementAt(i);
            if (TagList != null) {
                for (int j=0; j<TagList.size();j++) {
                    if (!SubscribedTags.contains(TagList.elementAt(j)))
                        SubscribedTags.addElement(TagList.elementAt(j));
                }
            }
        }
        return SubscribedTags;
     }
}