package cern.lhcias.csgui.Events;

import java.util.*;
/**
This event is used to broadcast the fact that the operator has clicked on the 
representation of a tag in some TagsViews. 
Menu bars that show the name of the clicked tag and tree representation 
of TagsViews subscribe to this event.
*/
public class TagClickedEvent extends java.util.EventObject
{
    /** The name of the Tag on which the user has clicked
    */
    public String TagName;
    /** true if the event has been set by a component (TagsView)
    */
    public boolean SentbyComponent = true;
    
    public TagClickedEvent( Object sourceObject) {
        super(sourceObject);
    }

    public void setTagName(String name) {
        TagName = name;
    }
    
    public void setSentbyComponent(boolean flag){
        SentbyComponent = flag;
    }
}