package tester;

/**
 * @(#)Grade.java	03/19/02
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 */
import java.text.DateFormat;
import java.text.ParseException;
import java.util.*;
import java.io.*;

/**
 * Grade is the object that calculates and returns the test grade.
 * It also updates a log file with all taken tests.
 *
 * @version 1.2
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class Grade {

	private int c = 0;
	private Calendar calendar;
	private Date now;
	private DateFormat localFormat;
	private TestLoader load;
	private List listWrong;
	private StringBuffer bf;
	private BufferedReader buf;
	private BufferedWriter bw;
	private Answers ans;

    /**
     * Creates a new Grade object.
     */
	public Grade() {
	listWrong = new ArrayList();
	load = new TestLoader();
	calendar = new GregorianCalendar();
	now = calendar.getTime();
	localFormat = DateFormat.getDateInstance();
	bf = new StringBuffer();
	ans = new Answers();
	}

    /**
	 * Compares the user's answers with the answer key
	 * and calculates the grade.
     */
	public void calculateGrade() {
	int i=0;
		while (i < ans.getAnswerKeyLength()) {
			if (ans.getUserAnswer(i).equalsIgnoreCase(ans.getCorrectAnswer(i))) {
				c++;
			}
			else {
				collectWrong("" + (i+1));
	    		displayWrong(i+1);
	    	}
	i++;
	}
	}

    /**
	 * Returns the number of correct answers.
     */
	public int getCorrect() {
		return c;
	}

    /**
	 * Returns the score as a percentage.
     */
	public int getScore() {
		return getCorrect() * 100 / load.files.length;
	}

    /**
	 * Creates and returns a summary list of all incorrectly
	 * answered questions and their correct answers.
     */
	public String getWrong() {
	StringBuffer bf = new StringBuffer();
	Iterator it = listWrong.iterator();
		while (it.hasNext()) {
			String s = (String)it.next();
			if (s.length() == 1) {
    			bf.append("   " + s + " was incorrect. The correct answer is : " +
    	          		   ans.getCorrectAnswer((Integer.parseInt(s))-1) + "\n");
		    }
    		else {
    			bf.append("  " + s + " was incorrect. The correct answer is : " +
                           ans.getCorrectAnswer((Integer.parseInt(s))-1) + "\n");
		    }
	    }
	bf.append("\n  Click \"View Incorrect\" to check the questions.");
    return bf.toString();
	}

    /* Creates a list with the full text of all incorrectl answered
       questions for revision. It is called from calculateGrade */
	private void displayWrong(int i) {
	try {
		StringBuffer buffer = new StringBuffer();
		buf = new BufferedReader(new FileReader(TestLoader.files[i-1]));
		String s = "";
			while((s = buf.readLine()) != null) {
				buffer.append(s +"\n");
		    }
		buffer.append("CORRECT ANSWER(S) : " + ans.getCorrectAnswer(i-1) + "\n");
		buffer.append("--------------------------------------" +
		              "--------------------------------------\n");
	bf.append(buffer.toString());
	} catch (IOException e) {
	System.out.println(e.getMessage());
    }
	finally {
		try {
			if (buf!= null) {
				buf.close();
				buf = null;
				System.gc();
			}
		} catch (IOException ex) {
		System.out.println(ex.getMessage());
		}
	}
	}

    /**
  	 * Returns a list with all the questions
  	 * that were answered incorrectly
     */
	public String wrongList() {
		return bf.toString();
	}

    /* Stores in an ArrayList object the question number of each incorrectly
       answered question. It is called from calculateGrade */
	private void collectWrong(String wrong) {
		listWrong.add(wrong);
	}

    /**
  	 * Updates the testlog file.
     */
	public void saveScore() {
	String th = "";
	String tm = "";
	String ts = "";
	String cr = "";
	String sc = "";
	try {
		if (getCorrect() < 10) {
			cr = "0" + getCorrect();
		}
		else {
			cr = "" + getCorrect();
		}
		if (getScore() < 10) {
			sc = "0" + getScore();
		}
		else {
			sc = "" + getScore();
	    }
		if (ExamFrame.h == 0) {
			th = "00";
		}
		else {
			th = "01";
		}
		if (ExamFrame.m == 60) {
			tm = "00";
		}
		else {
			tm = (ExamFrame.m < 10 && ExamFrame.m > 0)?"0" + ExamFrame.m:"" + ExamFrame.m;
		}
		if (ExamFrame.s == 60) {
			ts = "00";
		}
		else {
			ts = (ExamFrame.s < 10 && ExamFrame.s > 0)?"0" + ExamFrame.s:"" + ExamFrame.s;
	    }

	File log = new File("testlog.txt");
	bw = new BufferedWriter(new FileWriter("testlog.txt",true));
	StringBuffer sb1 = new StringBuffer(localFormat.format(now));
		if (sb1.length() == 11) {
			sb1.insert(4,"0");
		}
	bw.write(sb1.toString()+ "  " + cr + " of " +
             load.files.length + "  " + sc + "%  The test was completed in  " +
             th + ":" + tm + ":" + ts +"\n");
	} catch (IOException e) {
	System.out.println(e.getMessage());
	}
	finally {
		try {
			if (bw!= null) {
				bw.close();
				bw = null;
				System.gc();
			}
		} catch (IOException ex) {
		System.out.println(ex.getMessage());
		}
	}
	} //end saveScore
} //end class