package tester;

/**
 * @(#)StartEngine.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * StartEngine is the main entry point of the application that
 * loads and starts the test engine.
 *
 * @author	Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://anzwers.org/free/plevrakis/
 */
public class StartEngine {
    public static void main(String[]args) {
        final JFrame exam = new ExamFrame("Java 2 Certification Test Engine v 1.2  " +
                "by P.Plevrakis   @2002");
        String icon = "neb2.jpg";

        new SplashScreen(icon, exam, 5000);
        exam.setLocation(1, 1);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();

        exam.setSize(dim.width, 580);
        exam.setResizable(false);
        exam.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent evt) {
                    exam.setVisible(false);
                    exam.dispose();
                    System.exit(0);
                }
            }
        );
        exam.show();
    }
}
