package tester;

/**
 * @(#)ExamFrame.java	03/19/02
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as published
 *   by the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details.
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import calpa.html.*;
import java.net.*;
import java.io.*;
import com.incors.plaf.*;
import com.incors.plaf.kunststoff.*;
import com.incors.plaf.kunststoff.themes.*;
import java.text.DateFormat;
import java.text.ParseException;

/**
 * ExamFrame.
 * This class creates the main exam frame and interacts with the
 * classes that produce the logic of the test engine.
 *
 * @author Panagiotis Plevrakis
 *
 * Email: pplevrakis@hotmail.com
 * URL:   http://www30.brinkster.com/panos69/JProjects.aspx
 */
public class ExamFrame extends JFrame implements ActionListener {

    private String title;
    private JPanel eastPanel, answerPanel;
    private JLabel command, dummy1, dummy2, dummy3, dummy4,
                            dummy5, dummy6, dummy8, dummy9, dummy10;
    private JTextField answerField, time;
    protected final JButton start, next, grade, hidden;
    private JScrollPane scroll;
    private TestLoader load;
    private Answers ans;
    private Grade gr;
    private Font mainFont, answerFont;
    private int nextq, hrs, min, sec;
    public static int h, m, s;
    private TimePanel timePanel;
    private boolean ended = false;
    public float timePerQues = (60 * 60 * 2) / 59;
    private int secondsCounter = (int)(timePerQues * 59);
    private int initTimerVal = secondsCounter;
    private int warningCounterLimit = (int)(secondsCounter / 4);
    protected CalHTMLPane qpane;
    protected String dir = null;

    /**
     * Creates the main test frame.
     *
     * @param  title   The title String of the test frame.
     */
    public ExamFrame(String title, TestLoader load) {
		try {
		    UIManager.setLookAndFeel(new KunststoffLookAndFeel());
		} catch (Throwable e) {
		    System.out.println(e.getMessage());
        }
        this.title = title;
        qpane = new CalHTMLPane();
        this.load = load;
        ans = new Answers();
        gr = new Grade();
        answerFont = new Font("Arial", Font.BOLD, 16);
        mainFont = new Font("Courier", Font.PLAIN, 14);

        Container pane = getContentPane();

        setTitle(title);

        start = new JButton("Start Exam");
        start.addActionListener(this);

        next = new JButton("Next");
        next.addActionListener(this);

        command = new JLabel("Type your answers here: ", JLabel.CENTER);

        answerPanel = new JPanel();
        answerField = new JTextField(11);
        answerField.setFont(answerFont);
        answerField.addKeyListener(new KeyAdapter() {
                public void keyTyped(KeyEvent ke) {
                    ke.setKeyChar(((String.valueOf(ke.getKeyChar())).toUpperCase()).charAt(0));
                }
            }
        );
        answerPanel.add(answerField);

        grade = new JButton("Grade Test");
        grade.addActionListener(this);
        grade.setEnabled(false);

        hidden = new JButton("Review");
        hidden.addActionListener(this);
        hidden.setVisible(false);

        timePanel = new TimePanel(this);

        dummy1 = new JLabel("");
        dummy2 = new JLabel("");
        dummy3 = new JLabel("");
        dummy4 = new JLabel("");
        dummy5 = new JLabel("");
        dummy6 = new JLabel("");
        dummy8 = new JLabel(" ");
        dummy9 = new JLabel(" ");
        dummy10 = new JLabel("");

        eastPanel = new JPanel();
        eastPanel.setLayout(new GridLayout(0, 1));
        eastPanel.add(start);
        eastPanel.add(next);
        eastPanel.add(grade);
        eastPanel.add(command);
        eastPanel.add(answerPanel);
        eastPanel.add(timePanel);
        eastPanel.add(hidden);
        eastPanel.add(dummy10);
        eastPanel.add(dummy1);
        eastPanel.add(dummy2);
        eastPanel.add(dummy3);
        eastPanel.add(dummy4);
        eastPanel.add(dummy5);
        eastPanel.add(dummy6);
        eastPanel.add(dummy9);

        qpane.showHTMLDocument(load.INTRO);

        pane.add(dummy8, BorderLayout.WEST);
        pane.add(eastPanel, BorderLayout.EAST);
        pane.add(qpane, BorderLayout.CENTER);
    }

    public void showMessage(String s) {
        JOptionPane.showMessageDialog(this, s);
    }

    /**
     * Method to handle events for the ActionListener interface.
     * @param e java.awt.event.ActionEvent
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == start) {
            startTest();
        }
        if (e.getSource() == next) {
            getNextQuestion();
        }
        if (e.getSource() == grade) {
            gradeTest();
        }
        if (e.getSource() == hidden) {
			if (!(timePanel.time.getText().equals("           0 : 00 : 00")))
			    timePanel.time.setText("           0 : 00 : 00");
			if (TestLoader.flag == true) {
				hidden.setVisible(false);
			}
            if (hidden.getText().equals("Review"))
            	hidden.setText("Next");
            qpane.showHTMLDocument(load.review());
        }
    }

    /**
     * Starts the test loading the first question.
     */
    private void startTest() {
        Thread t1 = new Thread() {
                public void run() {
					start.setEnabled(false);
					if (next.getText().equals("Press Grade")) {
						next.setEnabled(true);
						next.setText("Next");
					}
					if (load.fcounter != 0)
					    load.fcounter = 0;
					if (nextq != 0)
					    nextq = 0;
					if (Answers.counter != 0)
					    Answers.counter = 0;
					for (int i=0;i < Answers.answers.length;i++)
					    Answers.answers[i] = null;
                    qpane.showHTMLDocument(load.nextQuestion());
                    timePanel.startTimer();
                    answerField.requestFocus();
                    nextq++;
                }
            };

        new Thread(t1).start();
    }

    /**
     * Loads the next question.
     */
    private void getNextQuestion() {
        if (nextq < load.files.length) {
            ans.collectAnswers(answerField.getText().trim());
            answerField.setText("");
            answerField.requestFocus();
            qpane.showHTMLDocument(load.nextQuestion());
        }
        nextq++;
        if (nextq == load.files.length) {
            next.setEnabled(false);
            next.setText("Press Grade");
            grade.setEnabled(true);
        }
    }

    /**
     * Grading method 1.
     * Grading is broken into 3 methods to make GUI responsive.
     */
    private void gradeTest() {
		grade.setEnabled(false);
		if ((hidden.getText().equals("Test Again")) ||
		    (hidden.getText().equals("Review"))) {
			hidden.setText("Review");
		    hidden.setVisible(true);
		}
		startGrading();
    }

    /**
	 * Grading method 2.
     */
    private void startGrading() {
        calculateGrade();
	}

	/**
	 * Grading method 3.
     */
	private void calculateGrade() {
         Thread grade = new Thread() {
	     public void run() {
	     timePanel.stopTimer();
		 ans.collectAnswers(answerField.getText().trim());
		 answerField.setText("");
		 answerField.setEnabled(false);
		 gr.calculateGrade();
		 qpane.showHTMLDocument(gr.getGradeData());}};
	     new Thread(grade).start();
	}
}// end class