/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.broker;

import java.io.FileInputStream;
import java.io.InputStream;
import java.rmi.dgc.VMID;
import java.util.Hashtable;
import java.util.Properties;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.util.Base64;
import org.webmacro.util.Log;

public class Config
implements ResourceProvider {
    public static final String TYPE = "config";
    static final Log log;
    private static final String vmId;
    private static int configCounter;
    private static long uniqueNumber;
    static final boolean debug = false;
    private static final String CONFIG_FILE = "/WebMacro.properties";
    public static final String lineSeparator;
    public static final String PROVIDERS = "Providers";
    public static final String TEMPLATE_DIR = "TemplatePath";
    public static final String TEMPLATE_CACHE = "TemplateExpireTime";
    public static final String USER_DB_FILE = "UserFile";
    public static final String ERROR_TEMPLATE = "ErrorTemplate";
    public static final String ERROR_VARIABLE = "ErrorVariable";
    public static final String LOG_FILE = "LogFile";
    public static final String LOG_TRACE_EXCEPTIONS = "LogTraceExceptions";
    public static final String LOG_LEVEL = "LogLevel";
    private static /* synthetic */ Class class$Lorg$webmacro$broker$Config;
    private static /* synthetic */ Class class$Ljava$lang$Class;
    private final String[] _types = new String[]{"config"};
    private final int myId = Config.nextId();
    private Properties myProps;

    public final int resourceThreads() {
        return 0;
    }

    public final String[] getTypes() {
        return this._types;
    }

    public final int resourceExpireTime() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void resourceRequest(RequestResourceEvent requestResourceEvent) {
        try {
            requestResourceEvent.set(this.get(requestResourceEvent.getName()));
            return;
        }
        catch (Exception exception) {
        }
    }

    public final void destroy() {
    }

    public final void init(ResourceBroker resourceBroker) {
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    private static final synchronized int nextId() {
        return configCounter++;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final InputStream getStream(String string) {
        Class clazz = class$Lorg$webmacro$broker$Config != null ? class$Lorg$webmacro$broker$Config : (class$Lorg$webmacro$broker$Config = Config.class$("org.webmacro.broker.Config"));
        InputStream inputStream = clazz.getResourceAsStream(string);
        if (inputStream == null) {
            clazz = class$Ljava$lang$Class != null ? class$Ljava$lang$Class : (class$Ljava$lang$Class = Config.class$("java.lang.Class"));
            inputStream = clazz.getResourceAsStream(string);
        }
        if (inputStream != null) return inputStream;
        try {
            return new FileInputStream(string);
        }
        catch (Exception exception) {
        }
        return inputStream;
    }

    public final String get(String string) {
        return this.myProps.getProperty(string);
    }

    public final Properties getProperties() {
        return this.myProps;
    }

    public final String getServerId() {
        return vmId + "-" + this.myId;
    }

    public static final synchronized String getUniqueString() {
        return vmId + "-" + ++uniqueNumber;
    }

    public static void main(String[] stringArray) {
        ResourceBroker resourceBroker = new ResourceBroker();
        Config config = new Config();
        resourceBroker.join(config);
        System.out.println("Fetching args as config variables:");
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n] + ":" + config.get(stringArray[n]));
            ++n;
        }
        System.out.println("Done.");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Config() {
        this(CONFIG_FILE);
    }

    public Config(String string) {
        this(Config.getStream(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Config(InputStream inputStream) {
        Properties properties;
        Properties properties2 = new Properties();
        ((Hashtable)properties2).put(TEMPLATE_DIR, "template");
        ((Hashtable)properties2).put(ERROR_TEMPLATE, "error.wm");
        ((Hashtable)properties2).put(ERROR_VARIABLE, "error");
        ((Hashtable)properties2).put(LOG_LEVEL, "WARNING");
        ((Hashtable)properties2).put(USER_DB_FILE, "user.db");
        try {
            properties = new Properties(properties2);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            log.exception(exception);
            log.error("Config: UNABLE TO LOAD CONFIG FILE: " + CONFIG_FILE + "\n" + "The webmacro.properties file is typically loaded by a \n" + "call to Class.getResourceAsStream()--this means it must\n" + "be locatable on your classpath; the same classpath from\n" + "which the core WebMacro classes were loaded (webmacro.jar)");
            properties = properties2;
        }
        this.myProps = properties;
        try {
            Log.setTarget(this.get(LOG_FILE));
            Log.setLevel(Log.getConstant(this.get(LOG_LEVEL)));
            boolean bl = Boolean.valueOf(this.get(LOG_TRACE_EXCEPTIONS));
            Log.traceExceptions(bl);
            return;
        }
        catch (Exception exception) {
            log.exception(exception);
            exception.printStackTrace();
            log.error("Config: could not correctly initialize logging!");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        String string;
        log = new Log(TYPE, "resource broker configuration");
        vmId = Base64.encode(new VMID().toString());
        configCounter = 0;
        uniqueNumber = 0L;
        try {
            string = System.getProperty("line.separator");
        }
        catch (Exception exception) {
            log.error("Config: could not determine lineSeparator");
            string = "\n";
        }
        lineSeparator = string;
    }
}

