/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.webmacro.engine.Macro;
import org.webmacro.engine.ParseException;
import org.webmacro.engine.ParseTool;
import org.webmacro.engine.Term;
import org.webmacro.util.InvalidContextException;

abstract class ParamDirective
implements Macro {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Object parse(ParseTool parseTool) throws IOException, ParseException {
        String string = null;
        Hashtable hashtable = parseTool.getParamContext();
        if (parseTool.ttype != -3 && !parseTool.sval.equals("param")) {
            return null;
        }
        parseTool.nextToken();
        if (!parseTool.parseSpaces()) {
            throw new ParseException(parseTool, "(1) expected spaces after keyword, got: " + (char)parseTool.ttype);
        }
        parseTool.parseChar('$');
        string = parseTool.parseString();
        if (string == null) {
            throw new ParseException(parseTool, "Parameter name (left hand side) expected");
        }
        parseTool.parseSpaces();
        if (!parseTool.parseChar('=')) {
            throw new ParseException(parseTool, "(2) expected spaces or = after keyword, got: " + (char)parseTool.ttype);
        }
        parseTool.parseSpaces();
        Object object = Term.parse(parseTool);
        if (object == null) {
            throw new ParseException(parseTool, "expected in after foreach key word, got: " + (char)parseTool.ttype);
        }
        try {
            if (object instanceof Macro) {
                object = ((Macro)object).evaluate(hashtable);
            }
        }
        catch (Exception exception) {
            throw new ParseException(parseTool, "Static evaluation of parameter " + string + " failed: " + exception + " -- parameters must be statically resolvable based on a context containing other parameters only.");
        }
        parseTool.parseSpaces();
        if (parseTool.parseToEOL()) {
            throw new ParseException(parseTool, "extraneous text after Term in Parameter Directive");
        }
        hashtable.put(string, object);
        return "";
    }

    public abstract void write(Writer var1, Object var2) throws InvalidContextException, IOException;

    public abstract Object evaluate(Object var1) throws InvalidContextException;

    ParamDirective() {
    }
}

