/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.resource;

import java.io.File;
import java.util.StringTokenizer;
import org.webmacro.broker.CreateResourceEvent;
import org.webmacro.broker.RequestResourceEvent;
import org.webmacro.broker.ResourceBroker;
import org.webmacro.broker.ResourceEvent;
import org.webmacro.broker.ResourceProvider;
import org.webmacro.broker.ResourceUnavailableException;
import org.webmacro.engine.FileTemplate;
import org.webmacro.engine.Template;
import org.webmacro.util.InitException;
import org.webmacro.util.Log;

public final class TemplateProvider
implements ResourceProvider {
    private static String pathSeparator_ = ";";
    public static final String TYPE = "template";
    private static final boolean _debug = false;
    public static final Log _log;
    private static final String[] _types;
    private String[] templateDirectory_ = null;
    private int cacheDuration = 600000;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void init(ResourceBroker resourceBroker) throws InitException {
        try {
            String string;
            try {
                string = (String)resourceBroker.getValue("config", "TemplateExpireTime");
                this.cacheDuration = Integer.valueOf(string);
            }
            catch (Exception exception) {
            }
            string = (String)resourceBroker.getValue("config", "TemplatePath");
            StringTokenizer stringTokenizer = new StringTokenizer(string, pathSeparator_);
            this.templateDirectory_ = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (true) {
                String string2;
                if (n >= this.templateDirectory_.length) {
                    return;
                }
                this.templateDirectory_[n] = string2 = stringTokenizer.nextToken();
                ++n;
            }
        }
        catch (Exception exception) {
            _log.exception(exception);
            throw new InitException("Could not initialize");
        }
    }

    public final String[] getTypes() {
        return _types;
    }

    public final int resourceExpireTime() {
        return this.cacheDuration;
    }

    public final int resourceThreads() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void resourceRequest(RequestResourceEvent requestResourceEvent) throws ResourceUnavailableException, InterruptedException {
        Template template = this.get(requestResourceEvent.getName());
        if (template == null) {
            return;
        }
        try {
            requestResourceEvent.set(template);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void resourceCreate(CreateResourceEvent createResourceEvent) {
    }

    public final boolean resourceSave(ResourceEvent resourceEvent) {
        return false;
    }

    public final boolean resourceDelete(ResourceEvent resourceEvent) {
        return false;
    }

    public final void destroy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Template get(String string) {
        int n = 0;
        while (n < this.templateDirectory_.length) {
            String string2 = this.templateDirectory_[n];
            File file = new File(string2, string);
            if (file.canRead()) {
                try {
                    FileTemplate fileTemplate = new FileTemplate(file);
                    fileTemplate.parse();
                    return fileTemplate;
                }
                catch (Exception exception) {
                    _log.exception(exception);
                    _log.warning("TemplateProvider: Could not load template: " + file);
                }
            }
            ++n;
        }
        return null;
    }

    public final String toString() {
        return "TemplateProvider(" + this.getPath() + ")";
    }

    public final String getPath() {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < this.templateDirectory_.length) {
            if (n != 0) {
                stringBuffer.append(pathSeparator_);
            }
            stringBuffer.append(this.templateDirectory_[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            pathSeparator_ = System.getProperty("path.separator");
        }
        catch (Exception exception) {
        }
        _log = new Log(TYPE, "Template storage resource");
        _types = new String[]{TYPE};
    }
}

