
/*
 * Copyright (c) 1998, 1999 Semiotek Inc. All Rights Reserved.
 *
 * This software is the confidential intellectual property of
 * of Semiotek Inc.; it is copyrighted and licensed, not sold.
 * You may use it under the terms of the GNU General Public License,
 * version 2, as published by the Free Software Foundation. If you 
 * do not want to use the GPL, you may still use the software after
 * purchasing a proprietary developers license from Semiotek Inc.
 *
 * This software is provided "as is", with NO WARRANTY, not even the 
 * implied warranties of fitness to purpose, or merchantability. You
 * assume all risks and liabilities associated with its use.
 *
 * See the attached License.html file for details, or contact us
 * by e-mail at info@semiotek.com to get a copy.
 */


package org.webmacro.broker;
import org.webmacro.util.*;
import java.util.*;


/**
  * This class is a type of ResourceListener that is interested in 
  * hearing about new events (all ResourceListeners have a list of types,
  * see ResourceListener for details.)
  * <p>
  * If you want to be notified when a resource is made available by 
  * the Broker, you can implement this interface and register. If you 
  * just want to have the Broker fill your orders, you don't need to
  * implement this--you only need this if you want to be spontaneously
  * notified when something happens.
  * <p>
  * Note that many consumers may be accessing a ResourceEvent at 
  * the same time you are. Ensure (in conjunction with the ResourceProvider)
  * that all operations involving resources are thread safe.
  * <p>
  * @see ResourceBroker
  * @see ResourceProvider
  * @see ResourceEvent
  * @see ResourceListener
  */
public interface ResourceConsumer extends ResourceListener
{

   /**
     * Called whenever a resource matching one of the types you 
     * subscribed to becomes available.
     * <p>
     * <b>Thread Policy</b>: The event you have been passed may be 
     * revoked at any time; it may already have been revoked by the
     * time you look at it. But it was available at the time you were 
     * called, which implies that calls to get its value will never 
     * block (though if it has been revoked, may return null.). You
     * MAY call the broker, and you MAY lock this or other ResourceEvents,
     * providing you obey the thread policies of those classes. 
     * <p>
     * Note that other consumers may already be accessing the resource,
     * or may start accessing it while you are.
     */
   public void resourceAvailable(ResourceEvent availableResource);

}
