/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueItem;
import X10Gimli.Value.ValueType;

public final class AssignCommand
extends Command {
    private ValueType vtIdent;
    private ValueType vcAssign;

    public AssignCommand() {
    }

    public AssignCommand(ValueType ident, ValueType assign) {
        this.setIdent(ident);
        this.setAssign(assign);
    }

    public void setIdent(ValueType ident) {
        this.vtIdent = ident;
    }

    public void setAssign(ValueType assign) {
        this.vcAssign = assign;
    }

    public ValueType getIdent() {
        return this.vtIdent;
    }

    public ValueType getAssign() {
        return this.vcAssign;
    }

    public ValueType execute(EnvironmentSmall env) {
        if (env != null) {
            if (this.vtIdent instanceof ValueIdent) {
                String s = ((ValueIdent)this.vtIdent).getValueString();
                Definition def = new Definition(s, this.vcAssign.getValue(env));
                env.setDefinition(def);
            } else if (this.vtIdent instanceof ValueItem) {
                ((ValueItem)this.vtIdent).setValue(this.vcAssign.getValue(env), env);
            } else {
                Debug.error(105, String.valueOf(String.valueOf(new StringBuffer("(Runtime) ").append(this.toString()).append(" requires variable identifier or list item identifier to do assignment."))));
            }
        }
        return null;
    }

    protected void executionOutput() {
        this.sBuf.append(this.vtIdent.string);
        this.sBuf.append(" = ");
        this.sBuf.append(this.vcAssign.string);
    }

    public String toX10GIMLI(int depth) {
        this.prepareOutputDepth(depth);
        this.sBuf.append(this.vtIdent.toX10GIMLI());
        this.sBuf.append(" = ");
        this.sBuf.append(this.vcAssign.toX10GIMLI());
        this.sBuf.append(";\n");
        return this.sBuf.toString();
    }
}

