/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Command;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.Environment;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Function;
import X10Gimli.Value.ValueType;

public final class UserCommand
extends FuncCommand {
    public ValueType execute(EnvironmentSmall env) {
        super.execute(env);
        if (this.getNumParams() >= 0 && env != null) {
            String functionname = this.getCommand().intern();
            Environment fullenv = env.getFullEnvironment();
            Function function = fullenv.findFunction(functionname);
            if (function != null) {
                env.setReturn(null);
                if (function.getIdents().size() != this.getNumParams()) {
                    Debug.error(100, String.valueOf(String.valueOf(new StringBuffer("(Runtime) Invalid number of parameters passed to ").append(functionname).append("."))));
                    return null;
                }
                EnvironmentSmall spawn = env.spawnEnvironment();
                for (int j = 0; j < this.getNumParams(); ++j) {
                    Definition def = new Definition();
                    def.setName(function.getIdent(j).getValueString());
                    def.setValue(this.getParam(j));
                    spawn.addDefinition(def);
                }
                spawn.executeCommand(function.getCommand());
                ValueType vreturn = env.getReturn();
                env.setReturn(null);
                return vreturn;
            }
            Debug.error(108, String.valueOf(String.valueOf(new StringBuffer("(Runtime) No function found that matches the function name ").append(functionname).append("."))));
        }
        return null;
    }
}

