/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.GUI;

import X10Gimli.SystemProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class PropertiesPanel
extends JPanel {
    private SystemProperties systemProps = new SystemProperties();
    private JTextField jLastTextField = null;
    private File lastDirectory = new File(".");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jInnerSourcePanel = new JPanel();
    private JLabel jSourceLabel = new JLabel();
    private JTextField jTextFieldSource = new JTextField();
    private BorderLayout borderLayoutInnerSource = new BorderLayout();
    private JPanel jPathPanel = new JPanel();
    private JLabel jPathLabel = new JLabel();
    private JScrollPane jListScrollPane = new JScrollPane();
    private BorderLayout borderLayoutPath = new BorderLayout();
    private JList jListPath = new JList();
    private JPanel jOuterLogPanel = new JPanel();
    private JPanel jInnerLogPanel = new JPanel();
    private BorderLayout borderLayoutOuterLog = new BorderLayout();
    private BorderLayout borderLayoutInnerLog = new BorderLayout();
    private JPanel jLogPanel = new JPanel();
    private JTextField jTextFieldError = new JTextField();
    private JCheckBox jCheckBoxError = new JCheckBox();
    private BorderLayout borderLayoutError = new BorderLayout();
    private JLabel jErrorLabel = new JLabel();
    private JPanel jPanelError = new JPanel();
    private JTextField jTextFieldUser = new JTextField();
    private JCheckBox jCheckBoxUser = new JCheckBox();
    private BorderLayout borderLayoutUser = new BorderLayout();
    private JLabel jUserOutputLabel = new JLabel();
    private JPanel jPanelUser = new JPanel();
    private JTextField jTextFieldExec = new JTextField();
    private JCheckBox jCheckBoxExec = new JCheckBox();
    private BorderLayout borderLayoutExecution = new BorderLayout();
    private JLabel jExecutionLabel = new JLabel();
    private JPanel jPanelExecution = new JPanel();
    private JTextField jTextFieldMaster = new JTextField();
    private BorderLayout borderLayoutMaster = new BorderLayout();
    private JLabel jMasterLabel = new JLabel();
    private JPanel jPanelMaster = new JPanel();
    private GridLayout gridLayoutLog = new GridLayout();
    private JPanel jButtonSpacerPanel = new JPanel();
    private JPanel jButtonPanel = new JPanel();
    private BorderLayout borderLayoutButtons = new BorderLayout();
    private JButton jButtonUpdate = new JButton();
    private JButton jButtonCancel = new JButton();
    private JButton jButtonBrowse = new JButton();
    private JPanel jMoreButtonSpacerPanel = new JPanel();
    private JTextField jTextFieldPath = new JTextField();
    private JSplitPane jSplitPane = new JSplitPane();
    private JPanel jCenterSpacerPanel = new JPanel();
    private JPanel jLeftSpacerPanel = new JPanel();
    private JPanel jRightSpacePanel = new JPanel();
    private JPanel jOuterSourcePanel = new JPanel();
    private JPanel jBottomSpacerPanel = new JPanel();
    private JPanel jLeftSourcePanel = new JPanel();
    private JPanel jTopSpacerPanel = new JPanel();
    private JPanel jRightSourcePanel = new JPanel();
    private BorderLayout borderLayoutOuterSource = new BorderLayout();
    private JCheckBox jCheckBoxSystem = new JCheckBox();
    private BorderLayout borderLayoutSystem = new BorderLayout();
    private JLabel jSystemLabel = new JLabel();
    private JTextField jTextFieldSystem = new JTextField();
    private JPanel jPanelSystem = new JPanel();
    TitledBorder titledBorder1;

    public PropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setSystemProperties(this.systemProps);
    }

    public void setSystemProperties(SystemProperties sys) {
        this.systemProps = sys;
        this.getPropertyValues(sys);
    }

    public SystemProperties getSystemProperties() {
        return this.systemProps;
    }

    private void getPropertyValues(SystemProperties sys) {
        sys.load();
        this.jTextFieldSource.setText(sys.getProperty("SOURCE"));
        this.jTextFieldMaster.setText(sys.getProperty("MASTER_LOG_FILE"));
        this.jTextFieldUser.setText(sys.getProperty("USER_LOG_FILE"));
        this.jTextFieldExec.setText(sys.getProperty("EXECUTION_LOG_FILE"));
        this.jTextFieldSystem.setText(sys.getProperty("SYSTEM_LOG_FILE"));
        this.jTextFieldError.setText(sys.getProperty("ERROR_LOG_FILE"));
        this.jCheckBoxUser.setSelected(sys.getProperty("USER_LOG").equalsIgnoreCase("TRUE"));
        this.jCheckBoxExec.setSelected(sys.getProperty("EXECUTION_LOG").equalsIgnoreCase("TRUE"));
        this.jCheckBoxSystem.setSelected(sys.getProperty("SYSTEM_LOG").equalsIgnoreCase("TRUE"));
        this.jCheckBoxError.setSelected(sys.getProperty("ERROR_LOG").equalsIgnoreCase("TRUE"));
        ArrayList a = sys.getPaths();
        DefaultListModel m = new DefaultListModel();
        for (int i = 0; i < a.size(); ++i) {
            m.addElement(a.get(i));
        }
        this.jListPath.setModel(m);
        this.unchanged();
    }

    private void setPropertyValues(SystemProperties sys) {
        sys.setProperty("SOURCE", this.jTextFieldSource.getText());
        sys.setProperty("MASTER_LOG_FILE", this.jTextFieldMaster.getText());
        sys.setProperty("USER_LOG_FILE", this.jTextFieldUser.getText());
        sys.setProperty("EXECUTION_LOG_FILE", this.jTextFieldExec.getText());
        sys.setProperty("SYSTEM_LOG_FILE", this.jTextFieldSystem.getText());
        sys.setProperty("ERROR_LOG_FILE", this.jTextFieldError.getText());
        sys.setProperty("USER_LOG", this.jCheckBoxUser.isSelected() ? "TRUE" : "FALSE");
        sys.setProperty("EXECUTION_LOG", this.jCheckBoxExec.isSelected() ? "TRUE" : "FALSE");
        sys.setProperty("SYSTEM_LOG", this.jCheckBoxSystem.isSelected() ? "TRUE" : "FALSE");
        sys.setProperty("ERROR_LOG", this.jCheckBoxError.isSelected() ? "TRUE" : "FALSE");
        DefaultListModel m = (DefaultListModel)this.jListPath.getModel();
        sys.setPaths(m.toArray());
        sys.save();
        this.unchanged();
    }

    public void saveProperties() {
        this.setPropertyValues(this.systemProps);
    }

    private void unchanged() {
        this.jButtonCancel.setEnabled(false);
        this.jButtonUpdate.setEnabled(false);
    }

    private void changed() {
        this.jButtonCancel.setEnabled(true);
        this.jButtonUpdate.setEnabled(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.setMinimumSize(new Dimension(370, 400));
        this.setPreferredSize(new Dimension(370, 400));
        this.setLayout(this.borderLayout1);
        this.jSourceLabel.setText("Source");
        this.jInnerSourcePanel.setLayout(this.borderLayoutInnerSource);
        this.jPathLabel.setText("Path");
        this.jPathPanel.setLayout(this.borderLayoutPath);
        this.jListScrollPane.setPreferredSize(new Dimension(150, 132));
        this.jListScrollPane.setToolTipText("");
        this.jInnerLogPanel.setLayout(this.borderLayoutInnerLog);
        this.jOuterLogPanel.setLayout(this.borderLayoutOuterLog);
        this.jCheckBoxError.setVerticalAlignment(3);
        this.jCheckBoxError.setText("Active");
        this.jCheckBoxError.setHorizontalTextPosition(10);
        this.jCheckBoxError.setHorizontalAlignment(0);
        this.jCheckBoxError.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesPanel.this.jCheckBoxError_itemStateChanged(e);
            }
        });
        this.jErrorLabel.setText("Error Log");
        this.jErrorLabel.setVerticalAlignment(3);
        this.jPanelError.setLayout(this.borderLayoutError);
        this.jCheckBoxUser.setHorizontalAlignment(0);
        this.jCheckBoxUser.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesPanel.this.jCheckBoxUser_itemStateChanged(e);
            }
        });
        this.jCheckBoxUser.setHorizontalTextPosition(10);
        this.jCheckBoxUser.setText("Active");
        this.jCheckBoxUser.setVerticalAlignment(3);
        this.jUserOutputLabel.setVerticalAlignment(3);
        this.jUserOutputLabel.setText("User Output Log");
        this.jPanelUser.setLayout(this.borderLayoutUser);
        this.jCheckBoxExec.setHorizontalAlignment(0);
        this.jCheckBoxExec.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesPanel.this.jCheckBoxExec_itemStateChanged(e);
            }
        });
        this.jCheckBoxExec.setHorizontalTextPosition(10);
        this.jCheckBoxExec.setText("Active");
        this.jCheckBoxExec.setVerticalAlignment(3);
        this.jExecutionLabel.setVerticalAlignment(3);
        this.jExecutionLabel.setText("Execution Log");
        this.jPanelExecution.setLayout(this.borderLayoutExecution);
        this.jMasterLabel.setVerticalAlignment(3);
        this.jMasterLabel.setText("Master Log");
        this.jPanelMaster.setLayout(this.borderLayoutMaster);
        this.jLogPanel.setLayout(this.gridLayoutLog);
        this.gridLayoutLog.setRows(5);
        this.gridLayoutLog.setColumns(1);
        this.jButtonSpacerPanel.setLayout(this.borderLayoutButtons);
        this.jButtonUpdate.setBackground(Color.lightGray);
        this.jButtonUpdate.setEnabled(false);
        this.jButtonUpdate.setText("Update");
        this.jButtonUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesPanel.this.jButtonUpdate_actionPerformed(e);
            }
        });
        this.jButtonCancel.setBackground(Color.lightGray);
        this.jButtonCancel.setEnabled(false);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesPanel.this.jButtonCancel_actionPerformed(e);
            }
        });
        this.jButtonBrowse.setBackground(Color.lightGray);
        this.jButtonBrowse.setToolTipText("");
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesPanel.this.jButtonBrowse_actionPerformed(e);
            }
        });
        this.jTextFieldMaster.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldMaster_focusLost(e);
            }
        });
        this.jTextFieldExec.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldExec_focusLost(e);
            }
        });
        this.jTextFieldUser.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldUser_focusLost(e);
            }
        });
        this.jTextFieldError.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldError_focusLost(e);
            }
        });
        this.jTextFieldSource.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldSource_focusLost(e);
            }
        });
        this.jTextFieldPath.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldPath_focusLost(e);
            }
        });
        this.jTextFieldPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PropertiesPanel.this.jTextFieldPath_actionPerformed(e);
            }
        });
        this.jListPath.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                PropertiesPanel.this.jListPath_keyReleased(e);
            }
        });
        this.jTextFieldMaster.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldMaster_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jTextFieldExec.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldExec_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jTextFieldUser.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldUser_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jTextFieldError.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldError_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jTextFieldSource.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldSource_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jOuterSourcePanel.setLayout(this.borderLayoutOuterSource);
        this.jCheckBoxSystem.setVerticalAlignment(3);
        this.jCheckBoxSystem.setText("Active");
        this.jCheckBoxSystem.setHorizontalTextPosition(10);
        this.jCheckBoxSystem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PropertiesPanel.this.jCheckBoxSystem_itemStateChanged(e);
            }
        });
        this.jCheckBoxSystem.setHorizontalAlignment(0);
        this.jSystemLabel.setText("System Log");
        this.jSystemLabel.setVerticalAlignment(3);
        this.jTextFieldSystem.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent e) {
                PropertiesPanel.this.jTextFieldSystem_inputMethodTextChanged(e);
            }

            public void caretPositionChanged(InputMethodEvent e) {
            }
        });
        this.jTextFieldSystem.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PropertiesPanel.this.jTextFieldSystem_focusLost(e);
            }
        });
        this.jPanelSystem.setLayout(this.borderLayoutSystem);
        this.jPathPanel.setMinimumSize(new Dimension(150, 62));
        this.jSplitPane.setBorder(null);
        this.jOuterSourcePanel.add((Component)this.jInnerSourcePanel, "Center");
        this.jInnerSourcePanel.add((Component)this.jSourceLabel, "Center");
        this.jInnerSourcePanel.add((Component)this.jTextFieldSource, "South");
        this.jSplitPane.add((Component)this.jPathPanel, "left");
        this.jPathPanel.add((Component)this.jPathLabel, "North");
        this.jPathPanel.add((Component)this.jListScrollPane, "Center");
        this.jPathPanel.add((Component)this.jTextFieldPath, "South");
        this.jSplitPane.add((Component)this.jOuterLogPanel, "right");
        this.jOuterLogPanel.add((Component)this.jInnerLogPanel, "Center");
        this.jInnerLogPanel.add((Component)this.jLogPanel, "North");
        this.jLogPanel.add((Component)this.jPanelMaster, null);
        this.jPanelMaster.add((Component)this.jMasterLabel, "Center");
        this.jPanelMaster.add((Component)this.jTextFieldMaster, "South");
        this.jLogPanel.add((Component)this.jPanelSystem, null);
        this.jPanelSystem.add((Component)this.jSystemLabel, "Center");
        this.jPanelSystem.add((Component)this.jTextFieldSystem, "South");
        this.jPanelSystem.add((Component)this.jCheckBoxSystem, "East");
        this.jLogPanel.add((Component)this.jPanelExecution, null);
        this.jPanelExecution.add((Component)this.jExecutionLabel, "Center");
        this.jPanelExecution.add((Component)this.jTextFieldExec, "South");
        this.jPanelExecution.add((Component)this.jCheckBoxExec, "East");
        this.jLogPanel.add((Component)this.jPanelUser, null);
        this.jPanelUser.add((Component)this.jUserOutputLabel, "Center");
        this.jPanelUser.add((Component)this.jTextFieldUser, "South");
        this.jPanelUser.add((Component)this.jCheckBoxUser, "East");
        this.jLogPanel.add((Component)this.jPanelError, null);
        this.jPanelError.add((Component)this.jErrorLabel, "Center");
        this.jPanelError.add((Component)this.jTextFieldError, "South");
        this.jPanelError.add((Component)this.jCheckBoxError, "East");
        this.jInnerLogPanel.add((Component)this.jButtonSpacerPanel, "Center");
        this.jButtonSpacerPanel.add((Component)this.jButtonPanel, "South");
        this.jButtonPanel.add((Component)this.jButtonUpdate, null);
        this.jButtonPanel.add((Component)this.jButtonCancel, null);
        this.jButtonSpacerPanel.add((Component)this.jButtonBrowse, "Center");
        this.jButtonSpacerPanel.add((Component)this.jMoreButtonSpacerPanel, "North");
        this.jOuterLogPanel.add((Component)this.jCenterSpacerPanel, "West");
        this.add((Component)this.jBottomSpacerPanel, "South");
        this.add((Component)this.jLeftSpacerPanel, "West");
        this.add((Component)this.jRightSpacePanel, "East");
        this.add((Component)this.jOuterSourcePanel, "North");
        this.jOuterSourcePanel.add((Component)this.jRightSourcePanel, "East");
        this.jOuterSourcePanel.add((Component)this.jTopSpacerPanel, "North");
        this.jOuterSourcePanel.add((Component)this.jLeftSourcePanel, "West");
        this.add((Component)this.jSplitPane, "Center");
        this.jListScrollPane.getViewport().add((Component)this.jListPath, null);
        this.jListPath.setModel(new DefaultListModel());
    }

    private void jButtonBrowse_actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.lastDirectory);
        if (this.jLastTextField == this.jTextFieldPath) {
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this.getParentFrame());
            if (returnVal == 0) {
                this.jLastTextField.setText(chooser.getSelectedFile().getAbsolutePath());
                this.jTextFieldPath_actionPerformed(null);
            }
        } else {
            if (this.jLastTextField == this.jTextFieldSource) {
                chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        if (f != null && f.getName().toUpperCase().endsWith(".GIM")) {
                            return true;
                        }
                        return f.isDirectory();
                    }

                    public String getDescription() {
                        return "X10GIMLI source files";
                    }
                });
            } else {
                chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        if (f != null && f.getName().toUpperCase().endsWith(".LOG")) {
                            return true;
                        }
                        return f.isDirectory();
                    }

                    public String getDescription() {
                        return "X10GIMLI log files";
                    }
                });
            }
            int returnVal = chooser.showOpenDialog(this.getParentFrame());
            if (returnVal == 0) {
                if (!chooser.getSelectedFile().getAbsolutePath().equals(this.jLastTextField.getText())) {
                    this.changed();
                }
                this.jLastTextField.setText(chooser.getSelectedFile().getAbsolutePath());
            }
        }
        this.lastDirectory = chooser.getCurrentDirectory();
    }

    private void jTextFieldMaster_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldMaster;
    }

    private void jTextFieldExec_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldExec;
    }

    private void jTextFieldUser_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldUser;
    }

    private void jTextFieldError_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldError;
    }

    private void jTextFieldSource_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldSource;
    }

    private void jTextFieldSystem_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldSystem;
    }

    private void jTextFieldPath_focusLost(FocusEvent e) {
        this.jLastTextField = this.jTextFieldPath;
    }

    private Frame getParentFrame() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    private void jTextFieldPath_actionPerformed(ActionEvent e) {
        if (!((DefaultListModel)this.jListPath.getModel()).contains(this.jTextFieldPath.getText())) {
            ((DefaultListModel)this.jListPath.getModel()).addElement(this.jTextFieldPath.getText());
            this.changed();
        }
        this.jTextFieldPath.setText("");
    }

    private void jListPath_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            Object[] sel = this.jListPath.getSelectedValues();
            int count = sel.length;
            DefaultListModel m = (DefaultListModel)this.jListPath.getModel();
            for (int i = 0; i < count; ++i) {
                m.removeElement(sel[i]);
            }
            if (count > 0) {
                this.changed();
            }
        }
    }

    private void jTextFieldMaster_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }

    private void jTextFieldExec_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }

    private void jTextFieldUser_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }

    private void jTextFieldError_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }

    private void jTextFieldSource_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }

    private void jCheckBoxSystem_itemStateChanged(ItemEvent e) {
        this.changed();
    }

    private void jCheckBoxExec_itemStateChanged(ItemEvent e) {
        this.changed();
    }

    private void jCheckBoxUser_itemStateChanged(ItemEvent e) {
        this.changed();
    }

    private void jCheckBoxError_itemStateChanged(ItemEvent e) {
        this.changed();
    }

    private void jButtonUpdate_actionPerformed(ActionEvent e) {
        this.setPropertyValues(this.systemProps);
    }

    private void jButtonCancel_actionPerformed(ActionEvent e) {
        this.getPropertyValues(this.systemProps);
    }

    private void jTextFieldSystem_inputMethodTextChanged(InputMethodEvent e) {
        this.changed();
    }
}

