/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.GUIApplication;

import X10Gimli.Debug;
import X10Gimli.GUI.TabbedLogPanel;
import X10Gimli.Interface.Gateway.LocalDebugGateway;
import X10Gimli.Interface.Gateway.TCPGateway;
import X10Gimli.System.Packet.X10gimliPacket;
import X10Gimli.Value.ValueString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogViewer
extends JFrame {
    private TCPGateway tcp = new TCPGateway();
    private boolean bVisible;
    private BorderLayout borderLayout1;
    private JPanel panelConnect;
    private TabbedLogPanel tabbedLogPanel;
    private FlowLayout flowLayout1;
    private JPanel jPanel1;
    private GridLayout gridLayout1;
    private JLabel labelTitle;
    private JButton buttonConnect;
    private JTextField textfieldIP;
    private JPanel panelIP;
    private JLabel labelIP;
    private BorderLayout borderLayout3;
    private JTextField textfieldPort;
    private BorderLayout borderLayout2;
    private JPanel panelPort;
    private JLabel labelPort;
    private JButton jButtonConnect;
    private JButton jButtonQuit;

    public LogViewer() {
        this.tcp.initialize(null);
        this.bVisible = true;
        this.borderLayout1 = new BorderLayout();
        this.panelConnect = new JPanel();
        this.tabbedLogPanel = new TabbedLogPanel();
        this.flowLayout1 = new FlowLayout();
        this.jPanel1 = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.labelTitle = new JLabel();
        this.buttonConnect = new JButton();
        this.textfieldIP = new JTextField();
        this.panelIP = new JPanel();
        this.labelIP = new JLabel();
        this.borderLayout3 = new BorderLayout();
        this.textfieldPort = new JTextField();
        this.borderLayout2 = new BorderLayout();
        this.panelPort = new JPanel();
        this.labelPort = new JLabel();
        this.jButtonConnect = new JButton();
        this.jButtonQuit = new JButton();
        try {
            this.jbInit();
            Debug.onYesLevel(1);
            Debug.onYesLevel(2);
            Debug.onYesLevel(3);
            Debug.onYesLevel(4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.localDebugConnection();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 1) {
            if (args[0].equalsIgnoreCase("-localhost") || args[0].equalsIgnoreCase("-l")) {
                LogViewer logViewer = new LogViewer();
                logViewer.removeConnectButton();
                logViewer.localDebugConnection();
            } else if (args[0].equalsIgnoreCase("-autoconnect") || args[0].equalsIgnoreCase("-a")) {
                LogViewer logViewer = new LogViewer();
                logViewer.removeConnectButton();
                logViewer.tcp.autoConnectThread();
                logViewer.tabbedLogPanel.setGateway(logViewer.tcp);
            }
        } else {
            new LogViewer();
        }
    }

    private void removeConnectButton() {
        this.getContentPane().remove(this.jButtonConnect);
        this.removeConnectPanel();
    }

    private void removeConnectPanel() {
        this.getContentPane().remove(this.panelConnect);
        this.show();
    }

    private void addConnectPanel() {
        this.getContentPane().add((Component)this.panelConnect, "West");
        this.show();
    }

    private void localDebugConnection() {
        this.tabbedLogPanel.setGateway(new LocalDebugGateway());
    }

    private void remoteDebugConnection() {
        this.tabbedLogPanel.setGateway(this.tcp);
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setTitle("Log Viewer");
        this.getContentPane().setLayout(this.borderLayout1);
        this.panelConnect.setMinimumSize(new Dimension(100, 10));
        this.panelConnect.setPreferredSize(new Dimension(100, 10));
        this.panelConnect.setLayout(this.flowLayout1);
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setVgap(5);
        this.labelTitle.setFont(new Font("Dialog", 1, 15));
        this.labelTitle.setHorizontalAlignment(0);
        this.labelTitle.setText("X10GIMLI");
        this.buttonConnect.setText("Connect");
        this.buttonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogViewer.this.buttonConnect_actionPerformed(e);
            }
        });
        this.textfieldIP.setMinimumSize(new Dimension(50, 21));
        this.textfieldIP.setPreferredSize(new Dimension(50, 21));
        this.panelIP.setLayout(this.borderLayout3);
        this.panelIP.setMinimumSize(new Dimension(100, 31));
        this.labelIP.setMaximumSize(new Dimension(16, 17));
        this.labelIP.setMinimumSize(new Dimension(16, 17));
        this.labelIP.setPreferredSize(new Dimension(16, 17));
        this.labelIP.setText("IP");
        this.textfieldPort.setMinimumSize(new Dimension(50, 21));
        this.textfieldPort.setPreferredSize(new Dimension(50, 21));
        this.textfieldPort.setText("5879");
        this.panelPort.setLayout(this.borderLayout2);
        this.panelPort.setMinimumSize(new Dimension(100, 31));
        this.labelPort.setMaximumSize(new Dimension(27, 17));
        this.labelPort.setMinimumSize(new Dimension(27, 17));
        this.labelPort.setPreferredSize(new Dimension(27, 17));
        this.labelPort.setText("Port");
        this.jButtonConnect.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jButtonConnect.setText("Connection View");
        this.jButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogViewer.this.jButtonConnect_actionPerformed(e);
            }
        });
        this.jButtonQuit.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jButtonQuit.setToolTipText("");
        this.jButtonQuit.setText("Stop X10GIMLI");
        this.jButtonQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogViewer.this.jButtonQuit_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.panelConnect, "West");
        this.panelConnect.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.labelTitle, null);
        this.jPanel1.add((Component)this.panelPort, null);
        this.panelPort.add((Component)this.labelPort, "West");
        this.panelPort.add((Component)this.textfieldPort, "Center");
        this.jPanel1.add((Component)this.panelIP, null);
        this.panelIP.add((Component)this.labelIP, "West");
        this.panelIP.add((Component)this.textfieldIP, "Center");
        this.jPanel1.add((Component)this.buttonConnect, null);
        this.getContentPane().add((Component)this.tabbedLogPanel, "Center");
        this.getContentPane().add((Component)this.jButtonConnect, "South");
        this.getContentPane().add((Component)this.jButtonQuit, "North");
        ((Component)this).setLocation(new Random().nextInt(600), new Random().nextInt(600));
        ((Component)this).setSize(500, 500);
        ((Component)this).setVisible(true);
        this.show();
    }

    private void jButtonConnect_actionPerformed(ActionEvent e) {
        if (this.bVisible) {
            this.removeConnectPanel();
            this.bVisible = false;
        } else {
            this.addConnectPanel();
            this.bVisible = true;
        }
    }

    private void buttonConnect_actionPerformed(ActionEvent e) {
        try {
            if (this.textfieldIP.getText().equals("")) {
                this.tcp.connect(InetAddress.getLocalHost(), Integer.parseInt(this.textfieldPort.getText()));
                this.tabbedLogPanel.setGateway(this.tcp);
            } else {
                this.tcp.connect(InetAddress.getByName(this.textfieldIP.getText()), Integer.parseInt(this.textfieldPort.getText()));
                this.tabbedLogPanel.setGateway(this.tcp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButtonQuit_actionPerformed(ActionEvent e) {
        int result = JOptionPane.showConfirmDialog(this, "Do you want to terminate the X10GIMLI execution process?", "Shutdown X10GIMLI?", 0);
        if (result == 0) {
            Debug.transmitPacket(new X10gimliPacket(new ValueString("SHUTDOWN")));
            this.tcp.transmitPacket(new X10gimliPacket(new ValueString("SHUTDOWN")));
        }
    }
}

