/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Interface.Gateway;

import X10Gimli.Debug;
import X10Gimli.Interface.InputOutputGateway;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueString;
import javax.speech.AudioException;
import javax.speech.Central;
import javax.speech.EngineList;
import javax.speech.EngineModeDesc;
import javax.speech.recognition.FinalRuleResult;
import javax.speech.recognition.GrammarException;
import javax.speech.recognition.Recognizer;
import javax.speech.recognition.ResultAdapter;
import javax.speech.recognition.ResultEvent;
import javax.speech.recognition.ResultListener;
import javax.speech.recognition.ResultToken;
import javax.speech.recognition.RuleGrammar;
import javax.speech.synthesis.Synthesizer;
import javax.speech.synthesis.SynthesizerModeDesc;

public class SPEECHGateway
extends InputOutputGateway {
    private RuleGrammar gram = null;
    private Recognizer reco = null;
    private Synthesizer synth = null;
    private ResultListener ruleListener = new ResultAdapter(){

        public void resultAccepted(ResultEvent e) {
            try {
                FinalRuleResult result = (FinalRuleResult)e.getSource();
                ResultToken[] tokens = result.getBestTokens();
                String token = "";
                for (int i = 0; i < tokens.length; ++i) {
                    token = String.valueOf(String.valueOf(token)).concat(String.valueOf(String.valueOf(tokens[i].getWrittenText())));
                    if (i + 1 >= tokens.length) continue;
                    token = String.valueOf(String.valueOf(token)).concat(" ");
                }
                Packet p = new Packet();
                p.setType("SPEECH");
                p.setSegment("INPUT", new ValueString(token));
                SPEECHGateway.this.inputReceived(p);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void resultRejected(ResultEvent e) {
        }
    };

    public SPEECHGateway() {
        this.setName("SPEECH");
    }

    public boolean initialize(Value id) {
        this.synth = null;
        if (id == null) {
            try {
                EngineList list = Central.availableSynthesizers(null);
                SynthesizerModeDesc mode = (SynthesizerModeDesc)list.get(0);
                if (mode == null) {
                    Debug.error(300, "\"No text-to-speech engine found.\"");
                } else {
                    this.synth = Central.createSynthesizer((EngineModeDesc)mode);
                    this.synth.allocate();
                }
                this.reco = Central.createRecognizer(null);
                if (this.reco == null) {
                    Debug.error(300, "\"No speech recognition engine found.\"");
                } else {
                    this.reco.allocate();
                    this.gram = this.reco.newRuleGrammar("X10GIMLI");
                    this.gram.addResultListener(this.ruleListener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.synth == null && this.reco == null) {
                return false;
            }
            Debug.log(1, "\"Successfully activated text-to-speech gateway.\"");
            return true;
        }
        Debug.error(100, "\"No parameters expected for text-to-speech gateway.\"");
        return false;
    }

    public void sendPacket(Packet p) {
        block19: {
            p.unpackData();
            if (p.getType().equals("SPEECH")) {
                if (p.getValue("COMMAND").getValueString() == "START") {
                    try {
                        if (this.reco != null) {
                            this.reco.requestFocus();
                            this.reco.resume();
                            this.gram.setEnabled(true);
                            this.reco.commitChanges();
                            break block19;
                        }
                        Debug.error("Speech recognition is not available.");
                    }
                    catch (AudioException e) {
                        Debug.error("There was a problem starting the speech recognition engine.");
                    }
                    catch (GrammarException e) {
                        Debug.error("There was a problem starting the speech recognition engine.");
                    }
                } else if (p.getValue("COMMAND").getValueString() == "STOP") {
                    if (this.reco != null) {
                        this.reco.pause();
                    } else {
                        Debug.error("Speech recognition is not available.");
                    }
                } else if (p.getValue("COMMAND").getValueString() == "ADDRULE") {
                    try {
                        if (this.reco != null) {
                            this.gram.setRule("RULE".concat(String.valueOf(String.valueOf(this.gram.listRuleNames().length))), this.gram.ruleForJSGF(p.getValue("RULE").getValueString()), true);
                            this.reco.commitChanges();
                            break block19;
                        }
                        Debug.error("Speech recognition is not available.");
                    }
                    catch (GrammarException e) {
                        Debug.error("There was a problem adding a speech grammar rule.");
                    }
                } else if (p.getValue("COMMAND").getValueString() == "TTS") {
                    if (this.synth != null) {
                        this.speakText(p.getValue("TEXT").getValueString());
                    } else {
                        Debug.error("Speech synthesis is not available.");
                    }
                }
            }
        }
    }

    public void speakText(String speak) {
        if (this.synth != null) {
            this.synth.speakPlainText(speak, null);
        }
    }
}

