/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Switch;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class Control {
    private ArrayList vID = new ArrayList();
    private ArrayList vSwitches = new ArrayList();

    public void setID(ArrayList id) {
        if (id != null) {
            this.vID = id;
        }
    }

    public void setSwitches(ArrayList switches) {
        if (switches != null) {
            this.vSwitches = switches;
        }
    }

    public ArrayList getID() {
        return this.vID;
    }

    public ArrayList getSwitches() {
        return this.vSwitches;
    }

    public Switch getSwitch(int num) {
        return (Switch)this.vSwitches.get(num);
    }

    public ArrayList getSwitches(ArrayList id, EnvironmentSmall env) {
        int size = this.vSwitches.size();
        ArrayList<Switch> slist = null;
        for (int i = 0; i < size; ++i) {
            Switch s = (Switch)this.vSwitches.get(i);
            if (!s.isSwitch(id, env)) continue;
            if (slist == null) {
                slist = new ArrayList<Switch>();
            }
            slist.add(s);
        }
        return slist;
    }

    public boolean isControl(ArrayList id, EnvironmentSmall env) {
        if (id != null) {
            boolean yes = true;
            int size = this.vID.size();
            int size2 = id.size();
            for (int i = 0; i < size; ++i) {
                Value vs = ((ValueType)this.vID.get(i)).getValue(env);
                boolean item = false;
                for (int j = 0; j < size2; ++j) {
                    Value vi = (Value)id.get(j);
                    if (!vs.getClass().equals(vi.getClass()) || !vs.applyCondition("==", vi, env).getBoolean()) continue;
                    item = true;
                }
                if (item) continue;
                yes = false;
            }
            return yes;
        }
        return false;
    }

    public String toX10GIMLI(int depth) {
        int i;
        char[] sBytes = new char[15];
        for (i = 0; i < 15; ++i) {
            sBytes[i] = 32;
        }
        StringBuffer sBuf = new StringBuffer("");
        int indent = depth * 2;
        sBuf.append(sBytes, 0, indent);
        sBuf.append("control <");
        for (i = 0; i < this.vID.size(); ++i) {
            sBuf.append(((ValueType)this.vID.get(i)).toX10GIMLI());
            if (i + 1 >= this.vID.size()) continue;
            sBuf.append(", ");
        }
        sBuf.append(">\r\n");
        for (i = 0; i < this.vSwitches.size(); ++i) {
            sBuf.append(((Switch)this.vSwitches.get(i)).toX10GIMLI(depth + 1));
        }
        return sBuf.toString();
    }
}

