/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.Command;
import X10Gimli.Command.MotionCommand;
import X10Gimli.Command.TriggerCommand;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public class Switch {
    private ArrayList vID = new ArrayList();
    private Command cCommand;
    private boolean bActive = true;

    public void setID(ArrayList id) {
        if (id != null) {
            this.vID = id;
        }
    }

    public void setCommand(Command command) {
        this.cCommand = command;
    }

    public void setActive(boolean active) {
        this.bActive = active;
    }

    public ArrayList getID() {
        return this.vID;
    }

    public Command getCommand() {
        return this.cCommand;
    }

    public boolean isActive() {
        return this.bActive;
    }

    public boolean isSwitch(ArrayList id, EnvironmentSmall env) {
        if (id != null) {
            boolean yes = true;
            int size = this.vID.size();
            int size2 = id.size();
            for (int i = 0; i < size; ++i) {
                Value vs = ((ValueType)this.vID.get(i)).getValue(env);
                boolean item = false;
                for (int j = 0; j < size2; ++j) {
                    Value vi = ((ValueType)id.get(j)).getValue(env);
                    if (!vs.getClass().equals(vi.getClass()) || !vs.applyCondition("==", vi, env).getBoolean()) continue;
                    item = true;
                }
                if (item) continue;
                yes = false;
            }
            return yes;
        }
        return false;
    }

    public void toggleActive() {
        this.bActive = !this.bActive;
    }

    public String toString() {
        String out = "";
        if (this.vID != null && this.vID.size() > 0) {
            out = String.valueOf(String.valueOf(out)).concat(String.valueOf(String.valueOf(this.vID.get(0).toString())));
            for (int i = 1; i < this.vID.size(); ++i) {
                out = String.valueOf(String.valueOf(out)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(this.vID.get(i).toString()))))));
            }
        }
        return out;
    }

    public String toX10GIMLI(int depth) {
        int i;
        char[] sBytes = new char[15];
        for (i = 0; i < 15; ++i) {
            sBytes[i] = 32;
        }
        StringBuffer sBuf = new StringBuffer("");
        int indent = depth * 2;
        sBuf.append(sBytes, 0, indent);
        sBuf.append("[");
        for (i = 0; i < this.vID.size(); ++i) {
            sBuf.append(((ValueType)this.vID.get(i)).toX10GIMLI());
            if (i + 1 >= this.vID.size()) continue;
            sBuf.append(", ");
        }
        if (this.cCommand instanceof BeginCommand || this.cCommand instanceof MotionCommand || this.cCommand instanceof TriggerCommand) {
            sBuf.append("]\r\n");
            sBuf.append(this.cCommand.toX10GIMLI(depth + 1));
        } else {
            sBuf.append("] ");
            sBuf.append(this.cCommand.toX10GIMLI(0));
        }
        return sBuf.toString();
    }
}

