/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueBoolean;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueList;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValuePacket;
import X10Gimli.Value.ValueTime;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public final class ValueItem
extends Value {
    public static final int TYPE_LIST = 1;
    public static final int TYPE_PACKET = 2;
    private ValueType vtList;
    private ValueType vtNum;
    private int iType;

    public ValueItem() {
    }

    public ValueItem(ValueType list, ValueType num, int i) {
        this.setList(list);
        this.setNum(num);
        this.setType(i);
    }

    public void setType(int i) {
        this.iType = i;
        this.makeString();
    }

    public void setList(ValueType list) {
        this.vtList = list;
        this.makeString();
    }

    public void setNum(ValueType num) {
        this.vtNum = num;
        this.makeString();
    }

    public int getType() {
        return this.iType;
    }

    public ValueType getList() {
        return this.vtList;
    }

    public ValueType getNum() {
        return this.vtNum;
    }

    public void setValue(ValueType val, EnvironmentSmall env) {
        if (env != null) {
            Value list = this.vtList.getValue(env);
            Value num = null;
            num = this.vtNum instanceof ValueIdent && !(list instanceof ValueList) ? (Value)this.vtNum : this.vtNum.getValue(env);
            if (this.iType == 1) {
                if (list instanceof ValueList && (num instanceof ValueNumber || num instanceof ValueMonth || num instanceof ValueDay || num instanceof ValueCommand)) {
                    ((ValueList)list).setItem(num.getNumber(), val);
                }
            } else if (this.iType == 2) {
                if (list instanceof ValuePacket) {
                    if (num.getValueString() == "TYPE") {
                        ((ValuePacket)list).setType(num.getValueString());
                    } else {
                        ((ValuePacket)list).setItem(num.getValueString(), val);
                    }
                } else if (list instanceof ValueTime) {
                    Calendar c = list.getTime();
                    if (num.getValueString() == "PRECISE") {
                        if (val instanceof ValueBoolean) {
                            ((ValueTime)list).setPrecision(((Value)val).getBoolean());
                            list.makeString();
                        } else {
                            Debug.error(103, "(Runtime) Precision must be of boolean type.");
                        }
                    } else if (num.getValueString() == "HOUR") {
                        if (val instanceof ValueNumber) {
                            c.set(11, ((Value)val).getNumber());
                            list.makeString();
                        } else {
                            Debug.error(103, "(Runtime) Hour must be of number type.");
                        }
                    } else if (num.getValueString() == "MINUTE") {
                        if (val instanceof ValueNumber) {
                            c.set(12, ((Value)val).getNumber());
                            list.makeString();
                        } else {
                            Debug.error(103, "(Runtime) Minute must be of number type.");
                        }
                    } else if (num.getValueString() == "SECOND") {
                        if (((ValueTime)list).isPrecise()) {
                            if (val instanceof ValueNumber) {
                                c.set(13, ((Value)val).getNumber());
                                list.makeString();
                            } else {
                                Debug.error(103, "(Runtime) Seconds must be of number type.");
                            }
                        } else {
                            Debug.error(109, "(Runtime) Full time precision not available for this value.");
                        }
                    } else {
                        Debug.error(108, "(Runtime) List item must reference a specific element of a time.");
                    }
                } else if (list instanceof ValueDate) {
                    Calendar c = list.getDate();
                    if (num.getValueString() == "PRECISE") {
                        if (val instanceof ValueBoolean) {
                            ((ValueDate)list).setPrecision(((Value)val).getBoolean());
                        } else {
                            Debug.error(103, "(Runtime) Precision must be of boolean type.");
                        }
                    } else if (num.getValueString() == "MONTH") {
                        if (val instanceof ValueNumber || num instanceof ValueMonth) {
                            c.set(2, ((Value)val).getNumber() - 1);
                            list.makeString();
                        } else {
                            Debug.error(103, "(Runtime) Month must be of number or month type.");
                        }
                    } else if (num.getValueString() == "DAY") {
                        if (val instanceof ValueNumber) {
                            c.set(5, ((Value)val).getNumber());
                            list.makeString();
                        } else {
                            Debug.error(103, "(Runtime) Date must be of number type.");
                        }
                    } else if (num.getValueString() == "YEAR") {
                        if (((ValueDate)list).isPrecise()) {
                            if (val instanceof ValueNumber) {
                                c.set(1, ((Value)val).getNumber());
                                list.makeString();
                            } else {
                                Debug.error(103, "(Runtime) Year must be of number type.");
                            }
                        } else {
                            Debug.error(109, "(Runtime) Full time precision not available for this value.");
                        }
                    } else {
                        Debug.error(108, "(Runtime) List item must reference a specific element of a date.");
                    }
                }
            } else {
                Debug.error(103, "(Runtime) List items must reference a specific numbered element of a list.");
            }
        }
    }

    public Value getValue(EnvironmentSmall env) {
        if (env != null) {
            Value list = this.vtList.getValue(env);
            Value num = this.vtNum.getValue(env);
            if (list instanceof ValuePacket) {
                num = this.vtNum.getValue(null);
            }
            if (this.iType == 1) {
                ValueType v;
                if (list instanceof ValueList && (num instanceof ValueNumber || num instanceof ValueMonth || num instanceof ValueDay || num instanceof ValueCommand) && (v = ((ValueList)list).getItem(num.getNumber())) != null) {
                    return v.getValue(env);
                }
            } else if (this.iType == 2) {
                if (list instanceof ValuePacket) {
                    if (num.getValueString() == "TYPE") {
                        return new ValueIdent(((ValuePacket)list).getType());
                    }
                    ValueType v = ((ValuePacket)list).getItem(num.getValueString());
                    if (v != null) {
                        return v.getValue(env);
                    }
                } else if (list instanceof ValueTime) {
                    Calendar c = list.getTime();
                    if (num.getValueString() == "HOUR") {
                        return new ValueNumber(c.get(11));
                    }
                    if (num.getValueString() == "MINUTE") {
                        return new ValueNumber(c.get(12));
                    }
                    if (num.getValueString() == "SECOND") {
                        return new ValueNumber(c.get(13));
                    }
                    if (num.getValueString() == "PRECISE") {
                        return new ValueBoolean(((ValueTime)list).isPrecise());
                    }
                } else if (list instanceof ValueDate) {
                    Calendar c = list.getDate();
                    if (num.getValueString() == "MONTH") {
                        return new ValueNumber(c.get(2) + 1);
                    }
                    if (num.getValueString() == "DAY") {
                        return new ValueNumber(c.get(5));
                    }
                    if (num.getValueString() == "YEAR") {
                        return new ValueNumber(c.get(1));
                    }
                    if (num.getValueString() == "PRECISE") {
                        return new ValueBoolean(((ValueDate)list).isPrecise());
                    }
                }
            } else {
                Debug.error(103, "(Runtime) List items must reference a specific numbered element of a list.");
            }
        }
        return ValueNothing.value;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for ITEM type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Debug.error(101, "(WARNING) Incompatible comparison to ITEM type : ".concat(String.valueOf(String.valueOf(val.string))));
        return 100;
    }

    public String toString() {
        if (this.vtList != null && this.vtNum != null) {
            if (this.iType == 1) {
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.vtList.toString()))).append("[").append(this.vtNum.toString()).append("]")));
            }
            if (this.iType == 2) {
                return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.vtList.toString()))).append(".").append(this.vtNum.toString())));
            }
        }
        return "";
    }

    public String toX10GIMLI() {
        return this.toString();
    }

    static {
        TYPE_LIST = 1;
        TYPE_PACKET = 2;
    }
}

