/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.System.Packet.Packet;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;

public final class ValuePacket
extends Value {
    private String sType;
    private ArrayList vLookup;
    private ArrayList vValues;

    public ValuePacket() {
        this.sType = "";
        this.vLookup = new ArrayList();
        this.vValues = new ArrayList();
    }

    public ValuePacket(Packet pack) {
        this.sType = pack.getType();
        this.vLookup = (ArrayList)pack.getTags().clone();
        this.vValues = (ArrayList)pack.getValues().clone();
    }

    public void setType(String type) {
        this.sType = type;
        this.makeString();
    }

    public void setLookup(ArrayList items) {
        if (items != null) {
            this.vLookup = items;
        }
        this.makeString();
    }

    public void setValues(ArrayList values) {
        if (values != null) {
            this.vValues = values;
        }
        this.makeString();
    }

    public String getType() {
        return this.sType;
    }

    public ArrayList getLookup() {
        return this.vLookup;
    }

    public ArrayList getValues() {
        return this.vValues;
    }

    public void addItem(String name, ValueType item) {
        if (this.vLookup != null && this.vValues != null) {
            this.vLookup.add(name);
            this.vValues.add(item);
        }
    }

    public void setItem(String lookup, ValueType val) {
        int size = this.vLookup.size();
        for (int i = 0; i < size; ++i) {
            String s = (String)this.vLookup.get(i);
            if (s != lookup) continue;
            this.vValues.set(i, val);
            return;
        }
        this.addItem(lookup, val);
    }

    public ValueType getItem(String lookup) {
        int size = this.vLookup.size();
        for (int i = 0; i < size; ++i) {
            String s = (String)this.vLookup.get(i);
            if (s != lookup) continue;
            return (ValueType)this.vValues.get(i);
        }
        Debug.error(109, "(Runtime) Attempted to access unknown packet entry.");
        return ValueNothing.value;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for PACKET type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Debug.error(101, "(WARNING) Incompatible comparison to PACKET type : ".concat(String.valueOf(String.valueOf(val.string))));
        return 100;
    }

    public String toString() {
        int i;
        this.sbuf.setLength(0);
        this.sbuf.append("PACKET(");
        this.sbuf.append(this.sType);
        this.sbuf.append(", {");
        if (this.vLookup.size() > 0) {
            this.sbuf.append((String)this.vLookup.get(0));
            for (i = 1; i < this.vLookup.size(); ++i) {
                this.sbuf.append(", ");
                this.sbuf.append((String)this.vLookup.get(i));
            }
        }
        this.sbuf.append("}, {");
        if (this.vValues.size() > 0) {
            this.sbuf.append(((ValueType)this.vValues.get(0)).toString());
            for (i = 1; i < this.vValues.size(); ++i) {
                this.sbuf.append(", ");
                this.sbuf.append(((ValueType)this.vValues.get(i)).toString());
            }
        }
        this.sbuf.append("})");
        return this.sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

