/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public final class ValueTime
extends Value {
    private Calendar calTime;
    private int iSeconds = 0;
    private boolean bFullPrecision;

    public ValueTime() {
    }

    public ValueTime(String string) {
        this.setValueString(string.toUpperCase());
        this.setTime(string);
    }

    public ValueTime(Calendar time) {
        this.setTime(time);
    }

    public ValueTime(Calendar time, boolean b) {
        this.setTime(time);
        this.setPrecision(b);
    }

    public void setTime(Calendar time) {
        this.calTime = time;
        this.setPrecision(true);
    }

    public void setRange(int s) {
        this.iSeconds = s;
    }

    public void setPrecision(boolean b) {
        this.bFullPrecision = b;
        this.makeString();
    }

    public void setTime(String time) {
        String h = null;
        String m = null;
        String s = null;
        String t = null;
        if (time.length() >= 4) {
            if (time.charAt(1) == ':') {
                h = time.substring(0, 1);
                m = time.substring(2, 4);
                if (time.length() >= 7) {
                    if (time.charAt(4) == ':') {
                        s = time.substring(5, 7);
                        if (time.length() == 9) {
                            t = time.substring(7, 9);
                        }
                    }
                } else if (time.length() >= 5) {
                    t = time.substring(4, 6);
                }
            } else if (time.charAt(2) == ':') {
                h = time.substring(0, 2);
                m = time.substring(3, 5);
                if (time.length() >= 8) {
                    if (time.charAt(5) == ':') {
                        s = time.substring(6, 8);
                        if (time.length() == 10) {
                            t = time.substring(8, 10);
                        }
                    }
                } else if (time.length() >= 7) {
                    t = time.substring(5, 7);
                }
            }
        }
        if (h != null && m != null) {
            int hour = Integer.parseInt(h);
            int minute = Integer.parseInt(m);
            int second = 0;
            if (s != null) {
                second = Integer.parseInt(s);
            }
            int am = 0;
            if (t != null && t.equals("pm")) {
                am = 1;
            }
            this.calTime = Calendar.getInstance();
            if (hour < 12 && am > 0) {
                hour += 12;
            }
            this.calTime.set(this.calTime.get(1), this.calTime.get(2), this.calTime.get(5), hour, minute, second);
            this.setPrecision(s != null);
        }
    }

    public Calendar getTime() {
        return this.calTime;
    }

    public boolean isPrecise() {
        return this.bFullPrecision;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        Calendar c1 = (Calendar)this.getTime().clone();
        if (cmp instanceof ValueTime) {
            Calendar c2 = cmp.getTime();
            if (op == "+") {
                c1.add(10, c2.get(10));
                c1.add(12, c2.get(12));
                if (((ValueTime)cmp).isPrecise()) {
                    c1.add(13, c2.get(13));
                }
                return new ValueTime(c1, this.isPrecise() || ((ValueTime)cmp).isPrecise());
            }
            if (op == "-") {
                c1.add(10, -c2.get(10));
                c1.add(12, -c2.get(12));
                if (((ValueTime)cmp).isPrecise()) {
                    c1.add(13, -c2.get(13));
                }
                return new ValueTime(c1, this.isPrecise() || ((ValueTime)cmp).isPrecise());
            }
        }
        if (cmp instanceof ValueNumber) {
            if (op == "+") {
                c1.add(13, cmp.getNumber());
                return new ValueTime(c1, true);
            }
            if (op == "-") {
                c1.add(13, -cmp.getNumber());
                return new ValueTime(c1, true);
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for TIME type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueTime) {
            Calendar c1 = (Calendar)this.getTime().clone();
            Calendar c2 = cmp.getTime();
            if (c1.get(11) < c2.get(11)) {
                return -1;
            }
            if (c1.get(11) > c2.get(11)) {
                return 1;
            }
            if (c1.get(11) == c2.get(11)) {
                if (c1.get(12) < c2.get(12)) {
                    return -1;
                }
                if (c1.get(12) > c2.get(12)) {
                    return 1;
                }
                if (this.isPrecise() && ((ValueTime)cmp).isPrecise()) {
                    if (c1.get(12) == c2.get(12)) {
                        for (int i = 0; i <= this.iSeconds; ++i) {
                            if (c1.get(13) == c2.get(13)) {
                                return 0;
                            }
                            c1.add(13, 1);
                        }
                        c1 = this.getTime();
                        if (c1.get(13) < c2.get(13)) {
                            return -1;
                        }
                        if (c1.get(13) > c2.get(13)) {
                            return 1;
                        }
                    }
                } else if (c1.get(12) == c2.get(12)) {
                    return 0;
                }
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to TIME type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public Calendar resetTime(EnvironmentSmall env) {
        Calendar temp = Calendar.getInstance();
        temp.add(12, 1);
        return temp;
    }

    public String toString() {
        this.sbuf.setLength(0);
        this.sbuf.append(this.calTime.get(11));
        this.sbuf.append(":");
        if (this.calTime.get(12) < 10) {
            this.sbuf.append("0");
        }
        this.sbuf.append(this.calTime.get(12));
        if (this.bFullPrecision) {
            this.sbuf.append(":");
            if (this.calTime.get(13) < 10) {
                this.sbuf.append("0");
            }
            this.sbuf.append(this.calTime.get(13));
        }
        return this.sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

